/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.lstargeneric.table;

import de.learnlib.algorithms.lstargeneric.table.Inconsistency;
import de.learnlib.algorithms.lstargeneric.table.Row;
import de.learnlib.api.AccessSequenceTransformer;
import de.learnlib.api.MembershipOracle;
import de.learnlib.oracles.DefaultQuery;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;

public final class ObservationTable<I, O>
implements AccessSequenceTransformer<I> {
    private static final int NO_ENTRY = -1;
    private final Alphabet<I> alphabet;
    private final List<Row<I>> shortPrefixRows = new ArrayList<Row<I>>();
    private final List<Row<I>> longPrefixRows = new ArrayList<Row<I>>();
    private final List<Row<I>> allRows = new ArrayList<Row<I>>();
    private final List<List<O>> allRowContents = new ArrayList<List<O>>();
    private final List<Row<I>> canonicalRows = new ArrayList<Row<I>>();
    private final TObjectIntMap<List<O>> rowContentIds = new TObjectIntHashMap(10, 0.75f, -1);
    private final Map<Word<I>, Row<I>> rowMap = new HashMap<Word<I>, Row<I>>();
    private int numRows = 0;
    private final List<Word<I>> suffixes = new ArrayList<Word<I>>();

    public ObservationTable(Alphabet<I> alphabet) {
        this.alphabet = alphabet;
    }

    public List<List<Row<I>>> initialize(List<Word<I>> initialSuffixes, MembershipOracle<I, O> oracle) {
        if (this.allRows.size() > 0) {
            throw new IllegalStateException("Called initialize, but there are already rows present");
        }
        int numSuffixes = initialSuffixes.size();
        this.suffixes.addAll(initialSuffixes);
        int numLps = this.alphabet.size();
        int numPrefixes = 1 + numLps;
        ArrayList<DefaultQuery<I, O>> queries = new ArrayList<DefaultQuery<I, O>>(numPrefixes * numSuffixes);
        Word eps = Word.epsilon();
        Row<I> epsRow = this.createSpRow(Word.epsilon());
        ObservationTable.buildQueries(queries, eps, this.suffixes);
        for (int i = 0; i < this.alphabet.size(); ++i) {
            Object sym = this.alphabet.getSymbol(i);
            Word w = Word.fromLetter((Object)sym);
            Row<I> lpRow = this.createLpRow(w);
            ObservationTable.buildQueries(queries, w, this.suffixes);
            epsRow.setSuccessor(i, lpRow);
        }
        oracle.processQueries(queries);
        Iterator<DefaultQuery<I, O>> queryIt = queries.iterator();
        ArrayList firstRowContents = new ArrayList(numSuffixes);
        ObservationTable.fetchResults(queryIt, firstRowContents, numSuffixes);
        this.processContents(epsRow, firstRowContents, true);
        ArrayList<List<Row<I>>> unclosed = new ArrayList<List<Row<I>>>();
        for (Row<I> lpRow : this.longPrefixRows) {
            int id;
            ArrayList rowContents = new ArrayList(numSuffixes);
            ObservationTable.fetchResults(queryIt, rowContents, numSuffixes);
            if (this.processContents(lpRow, rowContents, false)) {
                unclosed.add(new ArrayList());
            }
            if ((id = lpRow.getRowContentId()) <= 0) continue;
            ((List)unclosed.get(id - 1)).add(lpRow);
        }
        return unclosed;
    }

    public List<List<Row<I>>> addSuffix(Word<I> suffix, MembershipOracle<I, O> oracle) {
        return this.addSuffixes(Collections.singletonList(suffix), oracle);
    }

    public List<List<Row<I>>> addSuffixes(List<Word<I>> newSuffixes, MembershipOracle<I, O> oracle) {
        int oldSuffixCount = this.suffixes.size();
        int numNewSuffixes = newSuffixes.size();
        int numSpRows = this.shortPrefixRows.size();
        int rowCount = numSpRows + this.longPrefixRows.size();
        ArrayList<DefaultQuery<I, O>> queries = new ArrayList<DefaultQuery<I, O>>(rowCount * numNewSuffixes);
        for (Row<I> row : this.shortPrefixRows) {
            ObservationTable.buildQueries(queries, row.getPrefix(), newSuffixes);
        }
        for (Row<I> row : this.longPrefixRows) {
            ObservationTable.buildQueries(queries, row.getPrefix(), newSuffixes);
        }
        oracle.processQueries(queries);
        Iterator<DefaultQuery<I, O>> queryIt = queries.iterator();
        for (Row<I> row : this.shortPrefixRows) {
            List<O> rowContents = this.allRowContents.get(row.getRowContentId());
            if (rowContents.size() == oldSuffixCount) {
                this.rowContentIds.remove(rowContents);
                ObservationTable.fetchResults(queryIt, rowContents, numNewSuffixes);
                this.rowContentIds.put(rowContents, row.getRowContentId());
                continue;
            }
            ArrayList<O> newContents = new ArrayList<O>(oldSuffixCount + numNewSuffixes);
            newContents.addAll(rowContents.subList(0, oldSuffixCount));
            ObservationTable.fetchResults(queryIt, newContents, numNewSuffixes);
            this.processContents(row, newContents, true);
        }
        ArrayList<List<Row<I>>> unclosed = new ArrayList<List<Row<I>>>();
        numSpRows = this.numDistinctRows();
        for (Row<I> row : this.longPrefixRows) {
            int id;
            List<O> rowContents = this.allRowContents.get(row.getRowContentId());
            if (rowContents.size() == oldSuffixCount) {
                this.rowContentIds.remove(rowContents);
                ObservationTable.fetchResults(queryIt, rowContents, numNewSuffixes);
                this.rowContentIds.put(rowContents, row.getRowContentId());
                continue;
            }
            ArrayList<O> newContents = new ArrayList<O>(oldSuffixCount + numNewSuffixes);
            newContents.addAll(rowContents.subList(0, oldSuffixCount));
            ObservationTable.fetchResults(queryIt, newContents, numNewSuffixes);
            if (this.processContents(row, newContents, false)) {
                unclosed.add(new ArrayList());
            }
            if ((id = row.getRowContentId()) < numSpRows) continue;
            ((List)unclosed.get(id - numSpRows)).add(row);
        }
        this.suffixes.addAll(newSuffixes);
        return unclosed;
    }

    public List<List<Row<I>>> toShortPrefixes(List<Row<I>> lpRows, MembershipOracle<I, O> oracle) {
        ArrayList<Row<I>> freshSpRows = new ArrayList<Row<I>>();
        ArrayList<Row<I>> freshLpRows = new ArrayList<Row<I>>();
        for (Row<I> row : lpRows) {
            if (row.isShortPrefix()) {
                if (row.hasContents()) continue;
                freshSpRows.add(row);
            } else {
                this.makeShort(row);
                if (!row.hasContents()) {
                    freshSpRows.add(row);
                }
            }
            Word<I> prefix = row.getPrefix();
            for (int i = 0; i < this.alphabet.size(); ++i) {
                Object sym = this.alphabet.getSymbol(i);
                Word word = prefix.append(sym);
                Row<I> lpRow = this.rowMap.get(word);
                if (lpRow == null) {
                    lpRow = this.createLpRow(word);
                    freshLpRows.add(lpRow);
                }
                row.setSuccessor(i, lpRow);
            }
        }
        int numSuffixes = this.suffixes.size();
        int numFreshRows = freshSpRows.size() + freshLpRows.size();
        ArrayList<DefaultQuery<I, O>> queries = new ArrayList<DefaultQuery<I, O>>(numFreshRows * numSuffixes);
        ObservationTable.buildRowQueries(queries, freshSpRows, this.suffixes);
        ObservationTable.buildRowQueries(queries, freshLpRows, this.suffixes);
        oracle.processQueries(queries);
        Iterator<DefaultQuery<I, O>> queryIt = queries.iterator();
        for (Row row : freshSpRows) {
            ArrayList contents = new ArrayList(numSuffixes);
            ObservationTable.fetchResults(queryIt, contents, numSuffixes);
            this.processContents(row, contents, true);
        }
        int numSpRows = this.numDistinctRows();
        ArrayList<List<Row<I>>> arrayList = new ArrayList<List<Row<I>>>();
        for (Row row : freshLpRows) {
            int id;
            ArrayList contents = new ArrayList(numSuffixes);
            ObservationTable.fetchResults(queryIt, contents, numSuffixes);
            if (this.processContents(row, contents, false)) {
                arrayList.add(new ArrayList());
            }
            if ((id = row.getRowContentId()) < numSpRows) continue;
            ((List)arrayList.get(id - numSpRows)).add(row);
        }
        return arrayList;
    }

    public Row<I> getRowSuccessor(Row<I> row, I sym) {
        return row.getSuccessor(this.alphabet.getSymbolIndex(sym));
    }

    public List<List<Row<I>>> addShortPrefixes(List<Word<I>> shortPrefixes, MembershipOracle<I, O> oracle) {
        ArrayList<Row<I>> toSpRows = new ArrayList<Row<I>>();
        for (Word<I> sp : shortPrefixes) {
            Row<I> row = this.rowMap.get(sp);
            if (row != null) {
                if (row.isShortPrefix()) {
                    continue;
                }
            } else {
                row = this.createSpRow(sp);
            }
            toSpRows.add(row);
        }
        return this.toShortPrefixes(toSpRows, oracle);
    }

    public Inconsistency<I, O> findInconsistency() {
        Row[] canonicRows = new Row[this.numDistinctRows()];
        for (Row<I> spRow : this.shortPrefixRows) {
            int contentId = spRow.getRowContentId();
            Row canRow = canonicRows[contentId];
            if (canRow == null) {
                canonicRows[contentId] = spRow;
                continue;
            }
            for (int i = 0; i < this.alphabet.size(); ++i) {
                int canSuccContent;
                int spSuccContent = spRow.getSuccessor(i).getRowContentId();
                if (spSuccContent == (canSuccContent = canRow.getSuccessor(i).getRowContentId())) continue;
                return new Inconsistency(canRow, spRow, i);
            }
        }
        return null;
    }

    protected boolean makeShort(Row<I> row) {
        int cid;
        if (row.isShortPrefix()) {
            return false;
        }
        int lastIdx = this.longPrefixRows.size() - 1;
        Row<I> last = this.longPrefixRows.get(lastIdx);
        int rowIdx = row.getLpIndex();
        this.longPrefixRows.remove(lastIdx);
        if (last != row) {
            this.longPrefixRows.set(rowIdx, last);
            last.setLpIndex(rowIdx);
        }
        this.shortPrefixRows.add(row);
        row.makeShort(this.alphabet.size());
        if (row.hasContents() && this.canonicalRows.get(cid = row.getRowContentId()) == null) {
            this.canonicalRows.set(cid, row);
        }
        return true;
    }

    protected Row<I> createLpRow(Word<I> prefix) {
        Row<I> newRow = new Row<I>(prefix, this.numRows++);
        this.allRows.add(newRow);
        this.rowMap.put(prefix, newRow);
        int idx = this.longPrefixRows.size();
        this.longPrefixRows.add(newRow);
        newRow.setLpIndex(idx);
        return newRow;
    }

    protected Row<I> createSpRow(Word<I> prefix) {
        Row<I> newRow = new Row<I>(prefix, this.numRows++, this.alphabet.size());
        this.allRows.add(newRow);
        this.rowMap.put(prefix, newRow);
        this.shortPrefixRows.add(newRow);
        return newRow;
    }

    public List<O> rowContents(Row<I> row) {
        return this.allRowContents.get(row.getRowContentId());
    }

    public O cellContents(Row<I> row, int columnId) {
        List<O> contents = this.rowContents(row);
        return contents.get(columnId);
    }

    public Row<I> getRow(int rowId) {
        return this.allRows.get(rowId);
    }

    public int numDistinctRows() {
        return this.allRowContents.size();
    }

    public List<Row<I>> getShortPrefixRows() {
        return this.shortPrefixRows;
    }

    public int numShortPrefixRows() {
        return this.shortPrefixRows.size();
    }

    public int numLongPrefixRows() {
        return this.longPrefixRows.size();
    }

    public int numTotalRows() {
        return this.shortPrefixRows.size() + this.longPrefixRows.size();
    }

    public int numSuffixes() {
        return this.suffixes.size();
    }

    public List<Word<I>> getSuffixes() {
        return this.suffixes;
    }

    protected boolean processContents(Row<I> row, List<O> rowContents, boolean makeCanonical) {
        boolean added = false;
        int contentId = this.rowContentIds.get(rowContents);
        if (contentId == -1) {
            contentId = this.numDistinctRows();
            this.rowContentIds.put(rowContents, contentId);
            this.allRowContents.add(rowContents);
            added = true;
            if (makeCanonical) {
                this.canonicalRows.add(row);
            } else {
                this.canonicalRows.add(null);
            }
        }
        row.setRowContentId(contentId);
        return added;
    }

    protected static <I, O> void buildQueries(List<DefaultQuery<I, O>> queryList, List<Word<I>> prefixes, List<Word<I>> suffixes) {
        for (Word<I> prefix : prefixes) {
            ObservationTable.buildQueries(queryList, prefix, suffixes);
        }
    }

    protected static <I, O> void buildRowQueries(List<DefaultQuery<I, O>> queryList, List<Row<I>> rows, List<Word<I>> suffixes) {
        for (Row<I> row : rows) {
            ObservationTable.buildQueries(queryList, row.getPrefix(), suffixes);
        }
    }

    protected static <I, O> void buildQueries(List<DefaultQuery<I, O>> queryList, Word<I> prefix, List<Word<I>> suffixes) {
        for (Word<I> suffix : suffixes) {
            queryList.add(new DefaultQuery(prefix, suffix));
        }
    }

    protected static <I, O> void fetchResults(Iterator<DefaultQuery<I, O>> queryIt, List<O> output, int numSuffixes) {
        for (int j = 0; j < numSuffixes; ++j) {
            DefaultQuery<I, O> qry = queryIt.next();
            output.add(qry.getOutput());
        }
    }

    public boolean isInitialized() {
        return this.allRows.size() > 0;
    }

    public Alphabet<I> getInputAlphabet() {
        return this.alphabet;
    }

    public Word<I> transformAccessSequence(Word<I> word) {
        Row<I> current = this.shortPrefixRows.get(0);
        for (Object sym : word) {
            if ((current = this.getRowSuccessor(current, sym)).isShortPrefix()) continue;
            current = this.canonicalRows.get(current.getRowContentId());
        }
        return current.getPrefix();
    }

    public boolean isAccessSequence(Word<I> word) {
        Row<I> current = this.shortPrefixRows.get(0);
        for (Object sym : word) {
            if ((current = this.getRowSuccessor(current, sym)).isShortPrefix()) continue;
            return false;
        }
        return true;
    }
}

