/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.lstargeneric.table;

import net.automatalib.words.Word;

public final class Row<I> {
    private final Word<I> prefix;
    private final int rowId;
    private int rowContentId = -1;
    private int lpIndex = 0;
    private Row<I>[] successors = null;

    public Row(Word<I> prefix, int rowId) {
        this.prefix = prefix;
        this.rowId = rowId;
    }

    public Row(Word<I> prefix, int rowId, int alphabetSize) {
        this(prefix, rowId);
        this.makeShort(alphabetSize);
    }

    public void makeShort(int alphabetSize) {
        if (this.lpIndex == -1) {
            return;
        }
        this.lpIndex = -1;
        this.successors = new Row[alphabetSize];
    }

    public Row<I> getSuccessor(int inputIdx) {
        return this.successors[inputIdx];
    }

    public void setSuccessor(int inputIdx, Row<I> succ) {
        this.successors[inputIdx] = succ;
    }

    public Word<I> getPrefix() {
        return this.prefix;
    }

    public int getRowId() {
        return this.rowId;
    }

    public int getRowContentId() {
        return this.rowContentId;
    }

    public void setRowContentId(int id) {
        this.rowContentId = id;
    }

    public boolean isShortPrefix() {
        return this.lpIndex == -1;
    }

    public boolean hasContents() {
        return this.rowContentId != -1;
    }

    int getLpIndex() {
        return this.lpIndex;
    }

    void setLpIndex(int lpIndex) {
        this.lpIndex = lpIndex;
    }
}

