/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.nlstar;

import de.learnlib.algorithm.nlstar.Inconsistency;
import de.learnlib.algorithm.nlstar.Row;
import de.learnlib.oracle.MembershipOracle;
import de.learnlib.query.DefaultQuery;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ObservationTable<I> {
    private final Alphabet<I> alphabet;
    private final MembershipOracle<I, Boolean> oracle;
    private final List<Row<I>> upperRows = new ArrayList<Row<I>>();
    private final List<Row<I>> allRows = new ArrayList<Row<I>>();
    private final List<Row<I>> newUppers = new ArrayList<Row<I>>();
    private final List<Row<I>> newRows = new ArrayList<Row<I>>();
    private final List<Word<I>> suffixes = new ArrayList<Word<I>>();
    private final Set<Word<I>> suffixSet = new HashSet<Word<I>>();
    private final List<Row<I>> upperPrimes = new ArrayList<Row<I>>();

    public ObservationTable(Alphabet<I> alphabet, MembershipOracle<I, Boolean> oracle) {
        this.alphabet = alphabet;
        this.oracle = oracle;
    }

    public List<List<Row<I>>> initialize() {
        if (!this.suffixes.isEmpty()) {
            throw new IllegalStateException();
        }
        Row<I> row = this.createRow(Word.epsilon());
        this.makeUpper(row);
        return this.addSuffix(Word.epsilon());
    }

    private Row<I> createRow(Word<I> prefix) {
        Row<I> row = new Row<I>(prefix);
        this.allRows.add(row);
        this.newRows.add(row);
        return row;
    }

    public List<List<Row<I>>> addSuffix(Word<I> suffixToAdd) {
        return this.addSuffixes(Collections.singletonList(suffixToAdd));
    }

    private void makeUpper(Row<I> row) {
        this.makeUpper(Collections.singletonList(row));
    }

    public List<List<Row<I>>> makeUpper(List<Row<I>> rows) {
        ArrayList<Row<I>> newRows = new ArrayList<Row<I>>(rows.size() * this.alphabet.size());
        for (Row<I> row : rows) {
            this.makeShort(row);
            Word<I> prefix = row.getPrefix();
            for (int i = 0; i < this.alphabet.size(); ++i) {
                Object object = this.alphabet.getSymbol(i);
                Word newPrefix = prefix.append(object);
                Row<I> newRow = this.createRow(newPrefix);
                row.setSuccessorRow(i, newRow);
                newRows.add(newRow);
            }
        }
        if (this.suffixes.isEmpty()) {
            return Collections.emptyList();
        }
        int numSuffixes = this.suffixes.size();
        ArrayList<DefaultQuery> queries = new ArrayList<DefaultQuery>(newRows.size() * numSuffixes);
        for (Row row : newRows) {
            for (Word<I> suffix : this.suffixes) {
                queries.add(new DefaultQuery(row.getPrefix(), suffix));
            }
        }
        this.oracle.processQueries(queries);
        Iterator queryIt = queries.iterator();
        for (Row row : newRows) {
            row.fetchContents(queryIt, 0, numSuffixes);
        }
        return this.updateMetadata();
    }

    public List<List<Row<I>>> addSuffixes(List<? extends Word<I>> suffixesToAdd) {
        ArrayList<Word<I>> newSuffixes = new ArrayList<Word<I>>();
        int oldNumSuffixes = this.suffixes.size();
        for (Word<I> suffix : suffixesToAdd) {
            if (!this.suffixSet.add(suffix)) continue;
            this.suffixes.add(suffix);
            newSuffixes.add(suffix);
        }
        if (newSuffixes.isEmpty()) {
            return Collections.emptyList();
        }
        int numNewSuffixes = newSuffixes.size();
        ArrayList<DefaultQuery> queries = new ArrayList<DefaultQuery>(this.allRows.size() * numNewSuffixes);
        for (Row<I> row : this.allRows) {
            Word<I> prefix = row.getPrefix();
            for (Word word : newSuffixes) {
                queries.add(new DefaultQuery(prefix, word));
            }
        }
        this.oracle.processQueries(queries);
        Iterator queryIt = queries.iterator();
        for (Row<I> row : this.allRows) {
            row.fetchContents(queryIt, oldNumSuffixes, numNewSuffixes);
        }
        return this.updateMetadata();
    }

    private void makeShort(Row<I> row) {
        row.makeShort(this.upperRows.size(), this.alphabet.size());
        this.upperRows.add(row);
        this.newUppers.add(row);
    }

    private List<List<Row<I>>> updateMetadata() {
        for (Row<I> row : this.allRows) {
            if (row.isShortPrefixRow()) {
                if (row.isNew()) {
                    row.updateCovered(this.upperRows);
                    continue;
                }
                row.updateCovered(this.newUppers);
                continue;
            }
            if (row.isNew()) {
                row.updateCovered(this.allRows);
                continue;
            }
            row.updateCovered(this.newRows);
        }
        this.newRows.clear();
        this.newUppers.clear();
        this.upperPrimes.clear();
        HashMap<BitSet, ArrayList<Row<I>>> primeContents = new HashMap<BitSet, ArrayList<Row<I>>>();
        ArrayList<List<Row<I>>> allUnclosed = new ArrayList<List<Row<I>>>();
        for (Row<I> row : this.allRows) {
            boolean prime = row.checkPrime();
            if (!prime) continue;
            if (row.isShortPrefixRow()) {
                this.upperPrimes.add(row);
                continue;
            }
            ArrayList<Row<I>> unclosedClass = (ArrayList<Row<I>>)primeContents.get(row.getContents());
            if (unclosedClass == null) {
                unclosedClass = new ArrayList<Row<I>>();
                allUnclosed.add(unclosedClass);
                primeContents.put(row.getContents(), unclosedClass);
            }
            unclosedClass.add(row);
        }
        return allUnclosed;
    }

    public Word<I> getSuffix(int suffixIdx) {
        return this.suffixes.get(suffixIdx);
    }

    public List<Row<I>> getCoveredRows(Row<I> coveringRow) {
        return coveringRow.getCoveredRows();
    }

    public Row<I> getUpperRow(int index) {
        return this.upperRows.get(index);
    }

    public List<Row<I>> getUpperRows() {
        return this.upperRows;
    }

    public List<Row<I>> getUpperPrimes() {
        return this.upperPrimes;
    }

    public int getNumUpperRows() {
        return this.upperRows.size();
    }

    public @Nullable Inconsistency<I> findInconsistency() {
        for (Row<I> row1 : this.upperRows) {
            for (Row<I> row2 : row1.getCoveredRows()) {
                assert (row2.isShortPrefixRow());
                for (int i = 0; i < this.alphabet.size(); ++i) {
                    Row<I> row1succ = row1.getSuccessorRow(i);
                    Row<I> row2succ = row2.getSuccessorRow(i);
                    for (int j = 0; j < this.suffixes.size(); ++j) {
                        if (row1succ.getContent(j) || !row2succ.getContent(j)) continue;
                        return new Inconsistency<I>(row1, row2, i, j);
                    }
                }
            }
        }
        return null;
    }
}

