/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database;

import de.lmu.ifi.dbs.elki.data.type.NoSupportedDataTypeException;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.DatabaseEventManager;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreListener;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.query.rknn.RKNNQuery;
import de.lmu.ifi.dbs.elki.database.query.similarity.SimilarityQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.datasource.bundle.SingleObjectBundle;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.SimilarityFunction;
import de.lmu.ifi.dbs.elki.index.IndexFactory;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.AbstractHierarchicalResult;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class AbstractDatabase
extends AbstractHierarchicalResult
implements Database {
    protected final DatabaseEventManager eventManager = new DatabaseEventManager();
    protected final List<Relation<?>> relations = new ArrayList();
    protected final Collection<IndexFactory<?>> indexFactories = new ArrayList();

    public SingleObjectBundle getBundle(DBIDRef id) {
        assert (id != null);
        try {
            SingleObjectBundle ret = new SingleObjectBundle();
            for (Relation<?> relation : this.relations) {
                ret.append(relation.getDataTypeInformation(), relation.get(id));
            }
            return ret;
        }
        catch (RuntimeException e) {
            if (id == null) {
                throw new UnsupportedOperationException("AbstractDatabase.getPackage(null) called!");
            }
            throw e;
        }
    }

    public Collection<Relation<?>> getRelations() {
        return Collections.unmodifiableCollection(this.relations);
    }

    public <O> Relation<O> getRelation(TypeInformation restriction, Object ... hints) throws NoSupportedDataTypeException {
        for (Relation<?> relation : this.relations) {
            if (!restriction.isAssignableFromType((TypeInformation)relation.getDataTypeInformation())) continue;
            return relation;
        }
        ArrayList<SimpleTypeInformation> types = new ArrayList<SimpleTypeInformation>(this.relations.size());
        for (Relation<?> relation : this.relations) {
            types.add(relation.getDataTypeInformation());
        }
        throw new NoSupportedDataTypeException(restriction, types);
    }

    public <O> DistanceQuery<O> getDistanceQuery(Relation<O> objQuery, DistanceFunction<? super O> distanceFunction, Object ... hints) {
        return objQuery.getDistanceQuery(distanceFunction, hints);
    }

    public <O> SimilarityQuery<O> getSimilarityQuery(Relation<O> objQuery, SimilarityFunction<? super O> similarityFunction, Object ... hints) {
        return objQuery.getSimilarityQuery(similarityFunction, hints);
    }

    public <O> KNNQuery<O> getKNNQuery(DistanceQuery<O> distanceQuery, Object ... hints) {
        Relation relation = distanceQuery.getRelation();
        return relation.getKNNQuery(distanceQuery, hints);
    }

    public <O> RangeQuery<O> getRangeQuery(DistanceQuery<O> distanceQuery, Object ... hints) {
        Relation relation = distanceQuery.getRelation();
        return relation.getRangeQuery(distanceQuery, hints);
    }

    public <O> RangeQuery<O> getSimilarityRangeQuery(SimilarityQuery<O> simQuery, Object ... hints) {
        Relation relation = simQuery.getRelation();
        return relation.getSimilarityRangeQuery(simQuery, hints);
    }

    public <O> RKNNQuery<O> getRKNNQuery(DistanceQuery<O> distanceQuery, Object ... hints) {
        Relation relation = distanceQuery.getRelation();
        return relation.getRKNNQuery(distanceQuery, hints);
    }

    public void addDataStoreListener(DataStoreListener l) {
        this.eventManager.addListener(l);
    }

    public void removeDataStoreListener(DataStoreListener l) {
        this.eventManager.removeListener(l);
    }

    public void accumulateDataStoreEvents() {
        this.eventManager.accumulateDataStoreEvents();
    }

    public void flushDataStoreEvents() {
        this.eventManager.flushDataStoreEvents();
    }

    public String getLongName() {
        return "Database";
    }

    public String getShortName() {
        return "database";
    }

    protected abstract Logging getLogger();

    public static abstract class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID DATABASE_CONNECTION_ID = new OptionID("dbc", "Database connection class.");
        public static final OptionID INDEX_ID = new OptionID("db.index", "Database indexes to add.");

        protected abstract Database makeInstance();
    }
}

