/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database;

import de.lmu.ifi.dbs.elki.database.datastore.DataStoreEvent;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreListener;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultListener;
import java.util.ArrayList;
import java.util.List;

public class DatabaseEventManager {
    private List<DataStoreListener> dataListenerList = new ArrayList<DataStoreListener>();
    private List<ResultListener> resultListenerList = new ArrayList<ResultListener>();
    private boolean accumulateDataStoreEvents = false;
    private Type currentDataStoreEventType = null;
    private HashSetModifiableDBIDs dataStoreObjects;

    public void accumulateDataStoreEvents() {
        this.accumulateDataStoreEvents = true;
    }

    public void flushDataStoreEvents() {
        DataStoreEvent e;
        switch (this.currentDataStoreEventType) {
            case INSERT: {
                e = DataStoreEvent.insertionEvent((DBIDs)this.dataStoreObjects);
                break;
            }
            case REMOVE: {
                e = DataStoreEvent.removalEvent((DBIDs)this.dataStoreObjects);
                break;
            }
            case UPDATE: {
                e = DataStoreEvent.updateEvent((DBIDs)this.dataStoreObjects);
                break;
            }
            default: {
                return;
            }
        }
        int i = this.dataListenerList.size();
        while (--i >= 0) {
            this.dataListenerList.get(i).contentChanged(e);
        }
        this.accumulateDataStoreEvents = false;
        this.currentDataStoreEventType = null;
        this.dataStoreObjects = null;
    }

    public void addListener(DataStoreListener l) {
        this.dataListenerList.add(l);
    }

    public void removeListener(DataStoreListener l) {
        this.dataListenerList.remove(l);
    }

    public void addListener(ResultListener l) {
        this.resultListenerList.add(l);
    }

    public void removeListener(ResultListener l) {
        this.resultListenerList.remove(l);
    }

    public void fireObjectsInserted(DBIDs insertions) {
        this.fireObjectsChanged(insertions, Type.INSERT);
    }

    public void fireObjectInserted(DBIDRef insertion) {
        this.fireObjectChanged(insertion, Type.INSERT);
    }

    public void fireObjectsUpdated(DBIDs updates) {
        this.fireObjectsChanged(updates, Type.UPDATE);
    }

    public void fireObjectsUpdated(DBIDRef update) {
        this.fireObjectChanged(update, Type.UPDATE);
    }

    protected void fireObjectsRemoved(DBIDs deletions) {
        this.fireObjectsChanged(deletions, Type.REMOVE);
    }

    protected void fireObjectRemoved(DBIDRef deletion) {
        this.fireObjectChanged(deletion, Type.REMOVE);
    }

    private void fireObjectsChanged(DBIDs objects, Type type) {
        DataStoreEvent e;
        if (this.currentDataStoreEventType != null && !this.currentDataStoreEventType.equals((Object)type)) {
            this.flushDataStoreEvents();
        }
        if (this.accumulateDataStoreEvents) {
            if (this.dataStoreObjects == null) {
                this.dataStoreObjects = DBIDUtil.newHashSet();
            }
            this.dataStoreObjects.addDBIDs(objects);
            this.currentDataStoreEventType = type;
            return;
        }
        switch (type) {
            case INSERT: {
                e = DataStoreEvent.insertionEvent((DBIDs)objects);
                break;
            }
            case REMOVE: {
                e = DataStoreEvent.removalEvent((DBIDs)objects);
                break;
            }
            case UPDATE: {
                e = DataStoreEvent.updateEvent((DBIDs)objects);
                break;
            }
            default: {
                return;
            }
        }
        int i = this.dataListenerList.size();
        while (--i >= 0) {
            this.dataListenerList.get(i).contentChanged(e);
        }
    }

    private void fireObjectChanged(DBIDRef object, Type type) {
        if (this.currentDataStoreEventType != null && !this.currentDataStoreEventType.equals((Object)type)) {
            this.flushDataStoreEvents();
        }
        if (this.dataStoreObjects == null) {
            this.dataStoreObjects = DBIDUtil.newHashSet();
        }
        this.dataStoreObjects.add(object);
        this.currentDataStoreEventType = type;
        if (!this.accumulateDataStoreEvents) {
            this.flushDataStoreEvents();
        }
    }

    public void fireResultAdded(Result r, Result parent) {
        int i = this.resultListenerList.size();
        while (--i >= 0) {
            this.resultListenerList.get(i).resultAdded(r, parent);
        }
    }

    public void fireResultRemoved(Result r, Result parent) {
        int i = this.resultListenerList.size();
        while (--i >= 0) {
            this.resultListenerList.get(i).resultRemoved(r, parent);
        }
    }

    private static enum Type {
        INSERT,
        REMOVE,
        UPDATE;

    }
}

