/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database;

import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.database.AbstractDatabase;
import de.lmu.ifi.dbs.elki.database.UpdatableDatabase;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDFactory;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.DBIDView;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedRelation;
import de.lmu.ifi.dbs.elki.database.relation.ModifiableRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.datasource.DatabaseConnection;
import de.lmu.ifi.dbs.elki.datasource.FileBasedDatabaseConnection;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.datasource.bundle.ObjectBundle;
import de.lmu.ifi.dbs.elki.datasource.bundle.SingleObjectBundle;
import de.lmu.ifi.dbs.elki.index.Index;
import de.lmu.ifi.dbs.elki.index.IndexFactory;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.utilities.datastructures.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectListParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Parameter;
import java.util.ArrayList;
import java.util.Collection;

@Description(value="Database using an in-memory hashtable and at least providing linear scans.")
public class HashmapDatabase
extends AbstractDatabase
implements UpdatableDatabase {
    private static final Logging LOG = Logging.getLogger(HashmapDatabase.class);
    private HashSetModifiableDBIDs ids;
    private final DBIDView idrep;
    protected DatabaseConnection databaseConnection;

    public HashmapDatabase(DatabaseConnection databaseConnection, Collection<? extends IndexFactory<?>> indexFactories) {
        this.databaseConnection = databaseConnection;
        this.ids = DBIDUtil.newHashSet();
        this.idrep = new DBIDView((DBIDs)this.ids);
        this.relations.add(this.idrep);
        this.addChildResult((Result)this.idrep);
        if (indexFactories != null) {
            this.indexFactories.addAll(indexFactories);
        }
    }

    public HashmapDatabase() {
        this(null, null);
    }

    public void initialize() {
        if (this.databaseConnection != null) {
            this.insert((ObjectBundle)this.databaseConnection.loadData());
            this.databaseConnection = null;
        }
    }

    public DBIDs insert(ObjectBundle objpackages) {
        if (objpackages.dataLength() == 0) {
            return DBIDUtil.EMPTYDBIDS;
        }
        ArrayModifiableDBIDs newids = DBIDUtil.newArray((int)objpackages.dataLength());
        Relation<?>[] targets = this.alignColumns(objpackages);
        DBIDVar var = DBIDUtil.newVar();
        for (int j = 0; j < objpackages.dataLength(); ++j) {
            if (!objpackages.assignDBID(j, var)) {
                var.set((DBIDRef)DBIDUtil.generateSingleDBID());
            }
            if (this.ids.contains((DBIDRef)var)) {
                throw new AbortException("Duplicate DBID conflict.");
            }
            this.ids.add((DBIDRef)var);
            for (int i = 0; i < targets.length; ++i) {
                if (!(targets[i] instanceof ModifiableRelation)) {
                    throw new AbortException("Non-modifiable relations have been added to the database.");
                }
                ModifiableRelation relation = (ModifiableRelation)targets[i];
                relation.insert((DBIDRef)var, objpackages.data(j, i));
            }
            newids.add((DBIDRef)var);
        }
        this.eventManager.fireObjectsInserted((DBIDs)newids);
        return newids;
    }

    protected Relation<?>[] alignColumns(ObjectBundle pack) {
        Relation[] targets = new Relation[pack.metaLength()];
        long[] used = BitsUtil.zero((int)this.relations.size());
        for (int i = 0; i < targets.length; ++i) {
            SimpleTypeInformation meta = pack.meta(i);
            int j = BitsUtil.nextClearBit((long[])used, (int)0);
            while (j >= 0 && j < this.relations.size()) {
                Relation relation = (Relation)this.relations.get(j);
                if (relation.getDataTypeInformation().isAssignableFromType((TypeInformation)meta)) {
                    targets[i] = relation;
                    BitsUtil.setI((long[])used, (int)j);
                    break;
                }
                j = BitsUtil.nextClearBit((long[])used, (int)(j + 1));
            }
            if (targets[i] != null) continue;
            targets[i] = this.addNewRelation(meta);
            BitsUtil.setI((long[])used, (int)(this.relations.size() - 1));
        }
        return targets;
    }

    private Relation<?> addNewRelation(SimpleTypeInformation<?> meta) {
        SimpleTypeInformation<?> ometa = meta;
        MaterializedRelation relation = new MaterializedRelation(ometa, (DBIDs)this.ids);
        this.relations.add(relation);
        this.getHierarchy().add((Result)this, relation);
        for (IndexFactory factory : this.indexFactories) {
            if (!factory.getInputTypeRestriction().isAssignableFromType(meta)) continue;
            IndexFactory ofact = factory;
            MaterializedRelation orep = relation;
            Index index = ofact.instantiate(orep);
            index.initialize();
            this.getHierarchy().add(relation, (Result)index);
        }
        return relation;
    }

    public MultipleObjectsBundle delete(DBIDs ids) {
        MultipleObjectsBundle bundle = new MultipleObjectsBundle();
        for (Relation relation : this.relations) {
            ArrayList<Object> data = new ArrayList<Object>(ids.size());
            DBIDIter iter = ids.iter();
            while (iter.valid()) {
                data.add(relation.get((DBIDRef)iter));
                iter.advance();
            }
            bundle.appendColumn(relation.getDataTypeInformation(), data);
        }
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            this.doDelete((DBIDRef)iter);
            iter.advance();
        }
        this.eventManager.fireObjectsRemoved(ids);
        return bundle;
    }

    public SingleObjectBundle delete(DBIDRef id) {
        SingleObjectBundle bundle = new SingleObjectBundle();
        for (Relation relation : this.relations) {
            bundle.append(relation.getDataTypeInformation(), relation.get(id));
        }
        this.doDelete(id);
        this.eventManager.fireObjectRemoved(id);
        return bundle;
    }

    private void doDelete(DBIDRef id) {
        this.ids.remove(id);
        for (Relation relation : this.relations) {
            if (relation == this.idrep) continue;
            if (!(relation instanceof ModifiableRelation)) {
                throw new AbortException("Non-modifiable relations have been added to the database.");
            }
            ((ModifiableRelation)relation).delete(id);
        }
        DBIDFactory.FACTORY.deallocateSingleDBID(id);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractDatabase.Parameterizer {
        protected DatabaseConnection databaseConnection = null;
        private Collection<? extends IndexFactory<?>> indexFactories;

        protected void makeOptions(Parameterization config) {
            ObjectListParameter indexFactoryP;
            super.makeOptions(config);
            ObjectParameter dbcP = new ObjectParameter(DATABASE_CONNECTION_ID, DatabaseConnection.class, FileBasedDatabaseConnection.class);
            if (config.grab((Parameter)dbcP)) {
                this.databaseConnection = (DatabaseConnection)dbcP.instantiateClass(config);
            }
            if (config.grab((Parameter)(indexFactoryP = new ObjectListParameter(INDEX_ID, IndexFactory.class, true)))) {
                this.indexFactories = indexFactoryP.instantiateClasses(config);
            }
        }

        @Override
        protected HashmapDatabase makeInstance() {
            return new HashmapDatabase(this.databaseConnection, this.indexFactories);
        }
    }
}

