/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database;

import de.lmu.ifi.dbs.elki.database.AbstractDatabase;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.DBIDView;
import de.lmu.ifi.dbs.elki.database.relation.ProxyView;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.Result;
import java.util.Arrays;

public class ProxyDatabase
extends AbstractDatabase {
    private static final Logging LOG = Logging.getLogger(ProxyDatabase.class);
    protected DBIDView idrep;

    public ProxyDatabase(DBIDs ids) {
        this.idrep = new DBIDView(ids);
        this.relations.add(this.idrep);
        this.addChildResult((Result)this.idrep);
    }

    public ProxyDatabase(DBIDs ids, Iterable<Relation<?>> relations) {
        this.idrep = new DBIDView(ids);
        this.relations.add(this.idrep);
        this.addChildResult((Result)this.idrep);
        for (Relation<?> orel : relations) {
            ProxyView relation = new ProxyView(ids, orel);
            this.relations.add(relation);
            this.addChildResult((Result)relation);
        }
    }

    public ProxyDatabase(DBIDs ids, Relation<?> ... relations) {
        this(ids, Arrays.asList(relations));
    }

    public ProxyDatabase(DBIDs ids, Database database) {
        this(ids, database.getRelations());
    }

    public void initialize() {
    }

    public void addRelation(Relation<?> relation) {
        this.relations.add(relation);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public void setDBIDs(DBIDs ids) {
        this.idrep.setDBIDs(ids);
        for (Relation orel : this.relations) {
            if (!(orel instanceof ProxyView)) continue;
            ((ProxyView)orel).setDBIDs(this.idrep.getDBIDs());
        }
    }
}

