/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database;

import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.database.AbstractDatabase;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ArrayStaticDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.DBIDView;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedRelation;
import de.lmu.ifi.dbs.elki.datasource.DatabaseConnection;
import de.lmu.ifi.dbs.elki.datasource.FileBasedDatabaseConnection;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.index.Index;
import de.lmu.ifi.dbs.elki.index.IndexFactory;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.Duration;
import de.lmu.ifi.dbs.elki.logging.statistics.Statistic;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectListParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Parameter;
import java.util.Collection;

@Description(value="Database using an in-memory hashtable and at least providing linear scans.")
public class StaticArrayDatabase
extends AbstractDatabase {
    private static final Logging LOG = Logging.getLogger(StaticArrayDatabase.class);
    private ArrayStaticDBIDs ids;
    private DBIDView idrep;
    protected DatabaseConnection databaseConnection;

    public StaticArrayDatabase(DatabaseConnection databaseConnection, Collection<? extends IndexFactory<?>> indexFactories) {
        this.databaseConnection = databaseConnection;
        this.ids = null;
        this.idrep = null;
        if (indexFactories != null) {
            this.indexFactories.addAll(indexFactories);
        }
    }

    public StaticArrayDatabase(DatabaseConnection databaseConnection) {
        this(databaseConnection, null);
    }

    public void initialize() {
        if (this.databaseConnection == null) {
            return;
        }
        if (LOG.isDebugging()) {
            LOG.debugFine((CharSequence)"Loading data from database connection.");
        }
        MultipleObjectsBundle bundle = this.databaseConnection.loadData();
        this.databaseConnection = null;
        ArrayDBIDs bids = bundle.getDBIDs();
        this.ids = bids instanceof ArrayStaticDBIDs ? (ArrayStaticDBIDs)bids : (bids == null ? DBIDUtil.generateStaticDBIDRange((int)bundle.dataLength()) : (ArrayStaticDBIDs)DBIDUtil.makeUnmodifiable((DBIDs)DBIDUtil.ensureArray((DBIDs)bids)));
        this.idrep = new DBIDView((DBIDs)this.ids);
        this.relations.add(this.idrep);
        this.getHierarchy().add((Result)this, (Result)this.idrep);
        DBIDArrayIter it = this.ids.iter();
        int numrel = bundle.metaLength();
        for (int i = 0; i < numrel; ++i) {
            SimpleTypeInformation meta;
            SimpleTypeInformation ometa = meta = bundle.meta(i);
            WritableDataStore store = DataStoreUtil.makeStorage((DBIDs)this.ids, (int)30, (Class)ometa.getRestrictionClass());
            it.seek(0);
            while (it.valid()) {
                store.put((DBIDRef)it, bundle.data(it.getOffset(), i));
                it.advance();
            }
            MaterializedRelation relation = new MaterializedRelation(ometa, (DBIDs)this.ids, null, store);
            this.relations.add(relation);
            this.getHierarchy().add((Result)this, relation);
            for (IndexFactory factory : this.indexFactories) {
                if (!factory.getInputTypeRestriction().isAssignableFromType((TypeInformation)ometa)) continue;
                IndexFactory ofact = factory;
                MaterializedRelation orep = relation;
                Index index = ofact.instantiate(orep);
                Duration duration = LOG.isStatistics() ? LOG.newDuration(index.getClass().getName() + ".construction").begin() : null;
                index.initialize();
                if (duration != null) {
                    LOG.statistics((Statistic)duration.end());
                }
                this.getHierarchy().add(relation, (Result)index);
            }
        }
        this.eventManager.fireObjectsInserted((DBIDs)this.ids);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractDatabase.Parameterizer {
        protected DatabaseConnection databaseConnection = null;
        private Collection<? extends IndexFactory<?>> indexFactories;

        protected void makeOptions(Parameterization config) {
            ObjectListParameter indexFactoryP;
            super.makeOptions(config);
            ObjectParameter dbcP = new ObjectParameter(DATABASE_CONNECTION_ID, DatabaseConnection.class, FileBasedDatabaseConnection.class);
            if (config.grab((Parameter)dbcP)) {
                this.databaseConnection = (DatabaseConnection)dbcP.instantiateClass(config);
            }
            if (config.grab((Parameter)(indexFactoryP = new ObjectListParameter(INDEX_ID, IndexFactory.class, true)))) {
                this.indexFactories = indexFactoryP.instantiateClasses(config);
            }
        }

        @Override
        protected StaticArrayDatabase makeInstance() {
            return new StaticArrayDatabase(this.databaseConnection, this.indexFactories);
        }
    }
}

