/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.query.distance;

import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRange;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DBIDDistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DBIDDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DBIDRangeDistanceFunction;

public class DBIDRangeDistanceQuery
extends DBIDDistanceQuery {
    protected final DBIDRangeDistanceFunction distanceFunction;
    protected final DBIDRange range;

    public DBIDRangeDistanceQuery(Relation<DBID> relation, DBIDRangeDistanceFunction distanceFunction) {
        super(relation, (DBIDDistanceFunction)distanceFunction);
        this.range = DBIDUtil.assertRange((DBIDs)relation.getDBIDs());
        distanceFunction.checkRange(this.range);
        this.distanceFunction = distanceFunction;
    }

    @Override
    public double distance(DBIDRef id1, DBIDRef id2) {
        return this.distanceFunction.distance(this.range.getOffset(id1), this.range.getOffset(id2));
    }

    @Override
    public DBIDDistanceFunction getDistanceFunction() {
        return this.distanceFunction;
    }
}

