/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.query.knn;

import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractDistanceKNNQuery<O>
implements KNNQuery<O> {
    protected final DistanceQuery<O> distanceQuery;

    public AbstractDistanceKNNQuery(DistanceQuery<O> distanceQuery) {
        this.distanceQuery = distanceQuery;
    }

    public List<? extends KNNList> getKNNForBulkDBIDs(ArrayDBIDs ids, int k) {
        ArrayList<KNNList> ret = new ArrayList<KNNList>(ids.size());
        DBIDArrayIter iter = ids.iter();
        while (iter.valid()) {
            ret.add(this.getKNNForDBID((DBIDRef)iter, k));
            iter.advance();
        }
        return ret;
    }

    public KNNList getKNNForDBID(DBIDRef id, int k) {
        return this.getKNNForObject(this.getRelation().get(id), k);
    }

    protected Relation<? extends O> getRelation() {
        return this.distanceQuery.getRelation();
    }

    public abstract KNNList getKNNForObject(O var1, int var2);
}

