/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.query.knn;

import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.LinearScanQuery;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.AbstractDistanceKNNQuery;
import java.util.ArrayList;
import java.util.List;

public class LinearScanDistanceKNNQuery<O>
extends AbstractDistanceKNNQuery<O>
implements LinearScanQuery {
    public LinearScanDistanceKNNQuery(DistanceQuery<O> distanceQuery) {
        super(distanceQuery);
    }

    @Override
    public KNNList getKNNForDBID(DBIDRef id, int k) {
        DistanceQuery dq = this.distanceQuery;
        KNNHeap heap = DBIDUtil.newHeap((int)k);
        double max = Double.POSITIVE_INFINITY;
        DBIDIter iter = this.getRelation().getDBIDs().iter();
        while (iter.valid()) {
            double dist = dq.distance(id, (DBIDRef)iter);
            if (dist <= max) {
                max = heap.insert(dist, (DBIDRef)iter);
            }
            iter.advance();
        }
        return heap.toKNNList();
    }

    @Override
    public KNNList getKNNForObject(O obj, int k) {
        DistanceQuery dq = this.distanceQuery;
        KNNHeap heap = DBIDUtil.newHeap((int)k);
        double max = Double.POSITIVE_INFINITY;
        DBIDIter iter = this.getRelation().getDBIDs().iter();
        while (iter.valid()) {
            double dist = dq.distance(obj, (DBIDRef)iter);
            if (dist <= max) {
                max = heap.insert(dist, (DBIDRef)iter);
            }
            iter.advance();
        }
        return heap.toKNNList();
    }

    @Override
    public List<KNNList> getKNNForBulkDBIDs(ArrayDBIDs ids, int k) {
        int size = ids.size();
        ArrayList<KNNHeap> heaps = new ArrayList<KNNHeap>(size);
        for (int i = 0; i < size; ++i) {
            heaps.add(DBIDUtil.newHeap((int)k));
        }
        this.linearScanBatchKNN(ids, heaps);
        ArrayList<KNNList> result = new ArrayList<KNNList>(size);
        for (KNNHeap heap : heaps) {
            result.add(heap.toKNNList());
        }
        return result;
    }

    private void linearScanBatchKNN(ArrayDBIDs ids, List<KNNHeap> heaps) {
        DistanceQuery dq = this.distanceQuery;
        DBIDIter iter = this.getRelation().getDBIDs().iter();
        while (iter.valid()) {
            int index = 0;
            DBIDArrayIter iter2 = ids.iter();
            while (iter2.valid()) {
                KNNHeap heap = heaps.get(index);
                heap.insert(dq.distance((DBIDRef)iter2, (DBIDRef)iter), (DBIDRef)iter);
                iter2.advance();
                ++index;
            }
            iter.advance();
        }
    }
}

