/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.query.knn;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.LinearScanQuery;
import de.lmu.ifi.dbs.elki.database.query.distance.PrimitiveDistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.LinearScanPrimitiveDistanceKNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SquaredEuclideanDistanceFunction;
import java.util.ArrayList;
import java.util.List;

public class LinearScanEuclideanDistanceKNNQuery<O extends NumberVector>
extends LinearScanPrimitiveDistanceKNNQuery<O>
implements LinearScanQuery {
    public LinearScanEuclideanDistanceKNNQuery(PrimitiveDistanceQuery<O> distanceQuery) {
        super(distanceQuery);
        assert (EuclideanDistanceFunction.STATIC.equals((Object)distanceQuery.getDistanceFunction()));
    }

    @Override
    public KNNList getKNNForDBID(DBIDRef id, int k) {
        Relation relation = this.getRelation();
        return this.linearScan(relation, relation.iterDBIDs(), (NumberVector)relation.get(id), DBIDUtil.newHeap((int)k)).toKNNListSqrt();
    }

    @Override
    public KNNList getKNNForObject(O obj, int k) {
        Relation relation = this.getRelation();
        return this.linearScan(relation, relation.iterDBIDs(), obj, DBIDUtil.newHeap((int)k)).toKNNListSqrt();
    }

    private KNNHeap linearScan(Relation<? extends O> relation, DBIDIter iter, O obj, KNNHeap heap) {
        SquaredEuclideanDistanceFunction squared = SquaredEuclideanDistanceFunction.STATIC;
        double max = Double.POSITIVE_INFINITY;
        while (iter.valid()) {
            double dist = squared.distance(obj, (NumberVector)relation.get((DBIDRef)iter));
            if (dist <= max) {
                max = heap.insert(dist, (DBIDRef)iter);
            }
            iter.advance();
        }
        return heap;
    }

    @Override
    public List<KNNList> getKNNForBulkDBIDs(ArrayDBIDs ids, int k) {
        Relation relation = this.getRelation();
        int size = ids.size();
        ArrayList<KNNHeap> heaps = new ArrayList<KNNHeap>(size);
        ArrayList<Object> objs = new ArrayList<Object>(size);
        DBIDArrayIter iter = ids.iter();
        while (iter.valid()) {
            heaps.add(DBIDUtil.newHeap((int)k));
            objs.add(relation.get((DBIDRef)iter));
            iter.advance();
        }
        this.linearScanBatchKNN(objs, heaps);
        ArrayList<KNNList> result = new ArrayList<KNNList>(heaps.size());
        for (KNNHeap heap : heaps) {
            result.add(heap.toKNNListSqrt());
        }
        return result;
    }

    @Override
    protected void linearScanBatchKNN(List<O> objs, List<KNNHeap> heaps) {
        SquaredEuclideanDistanceFunction squared = SquaredEuclideanDistanceFunction.STATIC;
        Relation relation = this.getRelation();
        int size = objs.size();
        DBIDIter iter = relation.getDBIDs().iter();
        while (iter.valid()) {
            NumberVector candidate = (NumberVector)relation.get((DBIDRef)iter);
            for (int index = 0; index < size; ++index) {
                KNNHeap heap = heaps.get(index);
                double dist = squared.distance((NumberVector)objs.get(index), candidate);
                if (!(dist <= heap.getKNNDistance())) continue;
                heap.insert(dist, (DBIDRef)iter);
            }
            iter.advance();
        }
    }
}

