/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.query.range;

import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;

public abstract class AbstractDistanceRangeQuery<O>
implements RangeQuery<O> {
    protected final DistanceQuery<O> distanceQuery;

    public AbstractDistanceRangeQuery(DistanceQuery<O> distanceQuery) {
        this.distanceQuery = distanceQuery;
    }

    public DoubleDBIDList getRangeForDBID(DBIDRef id, double range) {
        ModifiableDoubleDBIDList ret = DBIDUtil.newDistanceDBIDList();
        this.getRangeForObject(this.getRelation().get(id), range, ret);
        ret.sort();
        return ret;
    }

    public DoubleDBIDList getRangeForObject(O obj, double range) {
        ModifiableDoubleDBIDList ret = DBIDUtil.newDistanceDBIDList();
        this.getRangeForObject(obj, range, ret);
        ret.sort();
        return ret;
    }

    public void getRangeForDBID(DBIDRef id, double range, ModifiableDoubleDBIDList neighbors) {
        this.getRangeForObject(this.getRelation().get(id), range, neighbors);
    }

    protected Relation<? extends O> getRelation() {
        return this.distanceQuery.getRelation();
    }
}

