/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.query.range;

import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.query.similarity.SimilarityQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;

public abstract class AbstractSimilarityRangeQuery<O>
implements RangeQuery<O> {
    protected final Relation<? extends O> relation;
    protected final SimilarityQuery<O> simQuery;

    public AbstractSimilarityRangeQuery(SimilarityQuery<O> simQuery) {
        this.relation = simQuery.getRelation();
        this.simQuery = simQuery;
    }

    public DoubleDBIDList getRangeForDBID(DBIDRef id, double range) {
        ModifiableDoubleDBIDList ret = DBIDUtil.newDistanceDBIDList();
        this.getRangeForObject(this.relation.get(id), range, ret);
        ret.sort();
        return ret;
    }

    public DoubleDBIDList getRangeForObject(O obj, double range) {
        ModifiableDoubleDBIDList ret = DBIDUtil.newDistanceDBIDList();
        this.getRangeForObject(obj, range, ret);
        ret.sort();
        return ret;
    }

    public void getRangeForDBID(DBIDRef id, double range, ModifiableDoubleDBIDList neighbors) {
        this.getRangeForObject(this.relation.get(id), range, neighbors);
    }
}

