/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.query.range;

import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.LinearScanQuery;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.range.AbstractDistanceRangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;

public class LinearScanDistanceRangeQuery<O>
extends AbstractDistanceRangeQuery<O>
implements LinearScanQuery {
    public LinearScanDistanceRangeQuery(DistanceQuery<O> distanceQuery) {
        super(distanceQuery);
    }

    @Override
    public DoubleDBIDList getRangeForDBID(DBIDRef id, double range) {
        DistanceQuery dq = this.distanceQuery;
        ModifiableDoubleDBIDList result = DBIDUtil.newDistanceDBIDList();
        DBIDIter iter = this.getRelation().getDBIDs().iter();
        while (iter.valid()) {
            double currentDistance = dq.distance(id, (DBIDRef)iter);
            if (currentDistance <= range) {
                result.add(currentDistance, (DBIDRef)iter);
            }
            iter.advance();
        }
        result.sort();
        return result;
    }

    @Override
    public DoubleDBIDList getRangeForObject(O obj, double range) {
        DistanceQuery dq = this.distanceQuery;
        ModifiableDoubleDBIDList result = DBIDUtil.newDistanceDBIDList();
        DBIDIter iter = this.getRelation().getDBIDs().iter();
        while (iter.valid()) {
            double currentDistance = dq.distance(obj, (DBIDRef)iter);
            if (currentDistance <= range) {
                result.add(currentDistance, (DBIDRef)iter);
            }
            iter.advance();
        }
        result.sort();
        return result;
    }

    @Override
    public void getRangeForDBID(DBIDRef id, double range, ModifiableDoubleDBIDList neighbors) {
        DistanceQuery dq = this.distanceQuery;
        DBIDIter iter = this.getRelation().iterDBIDs();
        while (iter.valid()) {
            double currentDistance = dq.distance(id, (DBIDRef)iter);
            if (currentDistance <= range) {
                neighbors.add(currentDistance, (DBIDRef)iter);
            }
            iter.advance();
        }
    }

    public void getRangeForObject(O obj, double range, ModifiableDoubleDBIDList neighbors) {
        Relation relation = this.getRelation();
        DistanceQuery dq = this.distanceQuery;
        DBIDIter iter = relation.iterDBIDs();
        while (iter.valid()) {
            double currentDistance = dq.distance(obj, (DBIDRef)iter);
            if (currentDistance <= range) {
                neighbors.add(currentDistance, (DBIDRef)iter);
            }
            iter.advance();
        }
    }
}

