/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.query.range;

import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.distance.PrimitiveDistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.range.AbstractDistanceRangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.PrimitiveDistanceFunction;

public class LinearScanPrimitiveDistanceRangeQuery<O>
extends AbstractDistanceRangeQuery<O> {
    private PrimitiveDistanceFunction<? super O> rawdist;

    public LinearScanPrimitiveDistanceRangeQuery(PrimitiveDistanceQuery<O> distanceQuery) {
        super(distanceQuery);
        this.rawdist = distanceQuery.getDistanceFunction();
    }

    @Override
    public DoubleDBIDList getRangeForDBID(DBIDRef id, double range) {
        Relation relation = this.getRelation();
        Object obj = relation.get(id);
        ModifiableDoubleDBIDList result = DBIDUtil.newDistanceDBIDList();
        this.linearScan(relation, relation.iterDBIDs(), obj, range, result);
        result.sort();
        return result;
    }

    @Override
    public DoubleDBIDList getRangeForObject(O obj, double range) {
        Relation relation = this.getRelation();
        ModifiableDoubleDBIDList result = DBIDUtil.newDistanceDBIDList();
        this.linearScan(relation, relation.iterDBIDs(), obj, range, result);
        result.sort();
        return result;
    }

    @Override
    public void getRangeForDBID(DBIDRef id, double range, ModifiableDoubleDBIDList neighbors) {
        Relation relation = this.getRelation();
        this.linearScan(relation, relation.iterDBIDs(), relation.get(id), range, neighbors);
    }

    public void getRangeForObject(O obj, double range, ModifiableDoubleDBIDList neighbors) {
        Relation relation = this.getRelation();
        this.linearScan(relation, relation.iterDBIDs(), obj, range, neighbors);
    }

    private void linearScan(Relation<? extends O> relation, DBIDIter iter, O obj, double range, ModifiableDoubleDBIDList result) {
        PrimitiveDistanceFunction<? super O> rawdist = this.rawdist;
        while (iter.valid()) {
            double distance = rawdist.distance(obj, relation.get((DBIDRef)iter));
            if (distance <= range) {
                result.add(distance, (DBIDRef)iter);
            }
            iter.advance();
        }
    }
}

