/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.relation;

import de.lmu.ifi.dbs.elki.database.QueryUtil;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.query.rknn.LinearScanRKNNQuery;
import de.lmu.ifi.dbs.elki.database.query.rknn.RKNNQuery;
import de.lmu.ifi.dbs.elki.database.query.similarity.SimilarityQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DBIDDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.DBIDSimilarityFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.SimilarityFunction;
import de.lmu.ifi.dbs.elki.index.DistanceIndex;
import de.lmu.ifi.dbs.elki.index.KNNIndex;
import de.lmu.ifi.dbs.elki.index.RKNNIndex;
import de.lmu.ifi.dbs.elki.index.RangeIndex;
import de.lmu.ifi.dbs.elki.index.SimilarityIndex;
import de.lmu.ifi.dbs.elki.index.SimilarityRangeIndex;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.AbstractHierarchicalResult;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.It;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;

public abstract class AbstractRelation<O>
extends AbstractHierarchicalResult
implements Relation<O> {
    public DistanceQuery<O> getDistanceQuery(DistanceFunction<? super O> distanceFunction, Object ... hints) {
        if (distanceFunction == null) {
            throw new AbortException("Distance query requested for 'null' distance!");
        }
        It it = this.getHierarchy().iterChildrenReverse((Object)this).filter(DistanceIndex.class);
        while (it.valid()) {
            DistanceQuery q = ((DistanceIndex)it.get()).getDistanceQuery(distanceFunction, hints);
            if (this.getLogger().isDebuggingFinest()) {
                this.getLogger().debugFinest((CharSequence)((q != null ? "Using" : "Not using") + " index for distance query: " + it.get()));
            }
            if (q != null) {
                return q;
            }
            it.advance();
        }
        for (Object o : hints) {
            if (o != "optimized" || distanceFunction instanceof DBIDDistanceFunction) continue;
            return null;
        }
        return distanceFunction.instantiate((Relation)this);
    }

    public SimilarityQuery<O> getSimilarityQuery(SimilarityFunction<? super O> similarityFunction, Object ... hints) {
        if (similarityFunction == null) {
            throw new AbortException("Similarity query requested for 'null' similarity!");
        }
        It it = this.getHierarchy().iterChildrenReverse((Object)this).filter(SimilarityIndex.class);
        while (it.valid()) {
            SimilarityQuery q = ((SimilarityIndex)it.get()).getSimilarityQuery(similarityFunction, hints);
            if (this.getLogger().isDebuggingFinest()) {
                this.getLogger().debugFinest((CharSequence)((q != null ? "Using" : "Not using") + " index for similarity query: " + it.get()));
            }
            if (q != null) {
                return q;
            }
            it.advance();
        }
        for (Object o : hints) {
            if (o != "optimized" || similarityFunction instanceof DBIDSimilarityFunction) continue;
            return null;
        }
        return similarityFunction.instantiate((Relation)this);
    }

    public KNNQuery<O> getKNNQuery(DistanceQuery<O> distanceQuery, Object ... hints) {
        if (distanceQuery == null) {
            throw new AbortException("kNN query requested for 'null' distance!");
        }
        Object[] it = this.getHierarchy().iterChildrenReverse((Object)this).filter(KNNIndex.class);
        while (it.valid()) {
            KNNQuery q = ((KNNIndex)it.get()).getKNNQuery(distanceQuery, hints);
            if (this.getLogger().isDebuggingFinest()) {
                this.getLogger().debugFinest((CharSequence)((q != null ? "Using" : "Not using") + " index for kNN query: " + it.get()));
            }
            if (q != null) {
                return q;
            }
            it.advance();
        }
        for (Object hint : hints) {
            if (hint != "optimized") continue;
            return null;
        }
        if (this.getLogger().isDebuggingFinest()) {
            StringBuilder buf = new StringBuilder();
            buf.append("Fallback to linear scan - no index was able to accelerate this query.\n");
            buf.append("Distance query: ").append(distanceQuery).append('\n');
            if (hints.length > 0) {
                buf.append("Hints:");
                for (Object o : hints) {
                    buf.append(' ').append(o);
                }
            }
            this.getLogger().debugFinest((CharSequence)buf.toString());
        }
        return QueryUtil.getLinearScanKNNQuery(distanceQuery);
    }

    public RangeQuery<O> getRangeQuery(DistanceQuery<O> distanceQuery, Object ... hints) {
        if (distanceQuery == null) {
            throw new AbortException("Range query requested for 'null' distance!");
        }
        Object[] it = this.getHierarchy().iterChildrenReverse((Object)this).filter(RangeIndex.class);
        while (it.valid()) {
            RangeQuery q = ((RangeIndex)it.get()).getRangeQuery(distanceQuery, hints);
            if (this.getLogger().isDebuggingFinest()) {
                this.getLogger().debugFinest((CharSequence)((q != null ? "Using" : "Not using") + " index for range query: " + it.get()));
            }
            if (q != null) {
                return q;
            }
            it.advance();
        }
        for (Object hint : hints) {
            if (hint != "optimized") continue;
            return null;
        }
        if (this.getLogger().isDebuggingFinest()) {
            StringBuilder buf = new StringBuilder();
            buf.append("Fallback to linear scan - no index was able to accelerate this query.\n");
            buf.append("Distance query: ").append(distanceQuery).append('\n');
            if (hints.length > 0) {
                buf.append("Hints:");
                for (Object o : hints) {
                    buf.append(' ').append(o);
                }
            }
            this.getLogger().debugFinest((CharSequence)buf.toString());
        }
        return QueryUtil.getLinearScanRangeQuery(distanceQuery);
    }

    public RangeQuery<O> getSimilarityRangeQuery(SimilarityQuery<O> simQuery, Object ... hints) {
        if (simQuery == null) {
            throw new AbortException("Range query requested for 'null' distance!");
        }
        Object[] it = this.getHierarchy().iterChildrenReverse((Object)this).filter(SimilarityRangeIndex.class);
        while (it.valid()) {
            RangeQuery q = ((SimilarityRangeIndex)it.get()).getSimilarityRangeQuery(simQuery, hints);
            if (this.getLogger().isDebuggingFinest()) {
                this.getLogger().debugFinest((CharSequence)((q != null ? "Using" : "Not using") + " index for range query: " + it.get()));
            }
            if (q != null) {
                return q;
            }
            it.advance();
        }
        for (Object hint : hints) {
            if (hint != "optimized") continue;
            return null;
        }
        if (this.getLogger().isDebuggingFinest()) {
            StringBuilder buf = new StringBuilder();
            buf.append("Fallback to linear scan - no index was able to accelerate this query.\n");
            buf.append("Distance query: ").append(simQuery).append('\n');
            if (hints.length > 0) {
                buf.append("Hints:");
                for (Object o : hints) {
                    buf.append(' ').append(o);
                }
            }
            this.getLogger().debugFinest((CharSequence)buf.toString());
        }
        return QueryUtil.getLinearScanSimilarityRangeQuery(simQuery);
    }

    public RKNNQuery<O> getRKNNQuery(DistanceQuery<O> distanceQuery, Object ... hints) {
        if (distanceQuery == null) {
            throw new AbortException("RKNN query requested for 'null' distance!");
        }
        It it = this.getHierarchy().iterChildrenReverse((Object)this).filter(RKNNIndex.class);
        while (it.valid()) {
            RKNNQuery q = ((RKNNIndex)it.get()).getRKNNQuery(distanceQuery, (Object[])hints);
            if (this.getLogger().isDebuggingFinest()) {
                this.getLogger().debugFinest((CharSequence)((q != null ? "Using" : "Not using") + " index for RkNN query: " + it.get()));
            }
            if (q != null) {
                return q;
            }
            it.advance();
        }
        Integer maxk = null;
        for (RKNNQuery hint : hints) {
            if (hint == "optimized") {
                return null;
            }
            if (!(hint instanceof Integer)) continue;
            maxk = (Integer)hint;
        }
        if (this.getLogger().isDebuggingFinest()) {
            StringBuilder buf = new StringBuilder();
            buf.append("Fallback to linear scan - no index was able to accelerate this query.\n");
            buf.append("Distance query: ").append(distanceQuery).append('\n');
            if (((RKNNQuery)hints).length > 0) {
                buf.append("Hints:");
                for (RKNNQuery o : hints) {
                    buf.append(' ').append(o);
                }
            }
            this.getLogger().debugFinest((CharSequence)buf.toString());
        }
        KNNQuery<O> knnQuery = this.getKNNQuery(distanceQuery, "need_bulk", maxk);
        return new LinearScanRKNNQuery<O>(distanceQuery, knnQuery, maxk);
    }

    protected abstract Logging getLogger();
}

