/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.relation;

import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.AbstractRelation;
import de.lmu.ifi.dbs.elki.logging.Logging;

public class DBIDView
extends AbstractRelation<DBID> {
    private static final Logging LOG = Logging.getLogger(DBIDView.class);
    private DBIDs ids;

    public DBIDView(DBIDs ids) {
        this.ids = DBIDUtil.makeUnmodifiable((DBIDs)ids);
    }

    public DBID get(DBIDRef id) {
        assert (this.ids.contains(id));
        return DBIDUtil.deref((DBIDRef)id);
    }

    public SimpleTypeInformation<DBID> getDataTypeInformation() {
        return TypeUtil.DBID;
    }

    public DBIDs getDBIDs() {
        return this.ids;
    }

    public DBIDIter iterDBIDs() {
        return this.ids.iter();
    }

    public void setDBIDs(DBIDs ids) {
        this.ids = DBIDUtil.makeUnmodifiable((DBIDs)ids);
    }

    public int size() {
        return this.ids.size();
    }

    public String getLongName() {
        return "Database IDs";
    }

    public String getShortName() {
        return "DBID";
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }
}

