/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.adapter;

import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.similarity.SimilarityQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractDatabaseDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.NormalizedSimilarityFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.SimilarityFunction;
import de.lmu.ifi.dbs.elki.utilities.ClassGenericsUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Parameter;

public abstract class AbstractSimilarityAdapter<O>
extends AbstractDatabaseDistanceFunction<O> {
    protected SimilarityFunction<? super O> similarityFunction;

    public AbstractSimilarityAdapter(SimilarityFunction<? super O> similarityFunction) {
        this.similarityFunction = similarityFunction;
    }

    public TypeInformation getInputTypeRestriction() {
        return this.similarityFunction.getInputTypeRestriction();
    }

    @Override
    public boolean isSymmetric() {
        return this.similarityFunction.isSymmetric();
    }

    public abstract <T extends O> DistanceQuery<T> instantiate(Relation<T> var1);

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        AbstractSimilarityAdapter other = (AbstractSimilarityAdapter)obj;
        return other.similarityFunction.equals(other.similarityFunction);
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.similarityFunction.hashCode();
    }

    public static abstract class Parameterizer<O, S extends SimilarityFunction<? super O>>
    extends AbstractParameterizer {
        public static final OptionID SIMILARITY_FUNCTION_ID = new OptionID("adapter.similarityfunction", "Similarity function to derive the distance between database objects from.");
        protected S similarityFunction = null;
        protected Class<SimilarityFunction<? super O>> ARBITRARY_SIMILARITY = ClassGenericsUtil.uglyCastIntoSubclass(SimilarityFunction.class);
        protected Class<NormalizedSimilarityFunction<? super O>> NORMALIZED_SIMILARITY = ClassGenericsUtil.uglyCastIntoSubclass(NormalizedSimilarityFunction.class);

        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            ObjectParameter param = new ObjectParameter(SIMILARITY_FUNCTION_ID, this.getSimilarityRestriction());
            if (config.grab((Parameter)param)) {
                this.similarityFunction = (SimilarityFunction)param.instantiateClass(config);
            }
        }

        protected abstract Class<? extends S> getSimilarityRestriction();
    }

    public static abstract class Instance<O>
    extends AbstractDatabaseDistanceFunction.Instance<O> {
        private SimilarityQuery<? super O> similarityQuery;

        public Instance(Relation<O> database, DistanceFunction<? super O> parent, SimilarityQuery<? super O> similarityQuery) {
            super(database, parent);
            this.similarityQuery = similarityQuery;
        }

        public abstract double transform(double var1);

        @Override
        public double distance(DBIDRef id1, DBIDRef id2) {
            return this.transform(this.similarityQuery.similarity(id1, id2));
        }
    }
}

