/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.covertree;

import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListMIter;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.index.AbstractIndex;
import de.lmu.ifi.dbs.elki.index.IndexFactory;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.Statistic;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Parameter;
import net.jafama.FastMath;

public abstract class AbstractCoverTree<O>
extends AbstractIndex<O> {
    final double expansion;
    final double invLogExpansion;
    protected final int scaleBottom;
    protected DistanceFunction<? super O> distanceFunction;
    private DistanceQuery<O> distanceQuery;
    protected long distComputations = 0L;
    protected int truncate = 10;

    public AbstractCoverTree(Relation<O> relation, DistanceFunction<? super O> distanceFunction, double expansion, int truncate) {
        super(relation);
        this.distanceFunction = distanceFunction;
        this.distanceQuery = distanceFunction.instantiate(relation);
        this.truncate = truncate;
        this.expansion = expansion;
        this.invLogExpansion = 1.0 / FastMath.log((double)expansion);
        this.scaleBottom = (int)Math.ceil(FastMath.log((double)Double.MIN_NORMAL) * this.invLogExpansion);
    }

    protected final double scaleToDist(int s) {
        return FastMath.pow((double)this.expansion, (double)s);
    }

    protected final int distToScale(double d) {
        return (int)Math.ceil(FastMath.log((double)d) * this.invLogExpansion);
    }

    protected double maxDistance(DoubleDBIDList elems) {
        double max = 0.0;
        DoubleDBIDListIter it = elems.iter();
        while (it.valid()) {
            double v = it.doubleValue();
            max = max > v ? max : v;
            it.advance();
        }
        return max;
    }

    protected double distance(DBIDRef a, DBIDRef b) {
        ++this.distComputations;
        return this.distanceQuery.distance(a, b);
    }

    protected double distance(O a, DBIDRef b) {
        ++this.distComputations;
        return this.distanceQuery.distance(a, b);
    }

    protected void excludeNotCovered(ModifiableDoubleDBIDList candidates, double fmax, ModifiableDoubleDBIDList collect) {
        DoubleDBIDListMIter it = candidates.iter();
        while (it.valid()) {
            if (it.doubleValue() > fmax) {
                collect.add(it.doubleValue(), (DBIDRef)it);
                candidates.removeSwap(it.getOffset());
                continue;
            }
            it.advance();
        }
    }

    protected void collectByCover(DBIDRef cur, ModifiableDoubleDBIDList candidates, double fmax, ModifiableDoubleDBIDList collect) {
        assert (collect.size() == 0) : "Not empty";
        DoubleDBIDListIter it = candidates.iter().advance();
        while (it.valid()) {
            assert (!DBIDUtil.equal((DBIDRef)cur, (DBIDRef)it));
            double dist = this.distance(cur, (DBIDRef)it);
            if (dist <= fmax) {
                collect.add(dist, (DBIDRef)it);
                candidates.removeSwap(it.getOffset());
                continue;
            }
            it.advance();
        }
    }

    public void logStatistics() {
        this.getLogger().statistics((Statistic)new LongStatistic(((Object)((Object)this)).getClass().getName() + ".distance-computations", this.distComputations));
    }

    protected abstract Logging getLogger();

    public String getLongName() {
        return "Cover Tree";
    }

    public String getShortName() {
        return "cover-tree";
    }

    public static abstract class Factory<O>
    implements IndexFactory<O> {
        protected DistanceFunction<? super O> distanceFunction;
        protected double expansion;
        protected int truncate;

        public Factory(DistanceFunction<? super O> distanceFunction, double expansion, int truncate) {
            this.distanceFunction = distanceFunction;
            this.expansion = expansion;
            this.truncate = truncate;
        }

        public TypeInformation getInputTypeRestriction() {
            return this.distanceFunction.getInputTypeRestriction();
        }

        public static abstract class Parameterizer<O>
        extends AbstractParameterizer {
            public static final OptionID DISTANCE_FUNCTION_ID = new OptionID("covertree.distancefunction", "Distance function to determine the distance between objects.");
            public static final OptionID TRUNCATE_ID = new OptionID("covertree.truncate", "Truncate tree when branches have less than this number of instances.");
            public static final OptionID EXPANSION_ID = new OptionID("covertree.expansionrate", "Expansion rate of the tree (Default: 1.3).");
            protected DistanceFunction<? super O> distanceFunction;
            protected int truncate = 10;
            protected double expansion = 1.3;

            protected void makeOptions(Parameterization config) {
                DoubleParameter expansionP;
                IntParameter truncateP;
                super.makeOptions(config);
                ObjectParameter distanceFunctionP = new ObjectParameter(DISTANCE_FUNCTION_ID, DistanceFunction.class);
                if (config.grab((Parameter)distanceFunctionP)) {
                    this.distanceFunction = (DistanceFunction)distanceFunctionP.instantiateClass(config);
                    if (!this.distanceFunction.isMetric()) {
                        LoggingUtil.warning((String)"CoverTree requires a metric to be exact.");
                    }
                }
                if (config.grab((Parameter)(truncateP = (IntParameter)new IntParameter(TRUNCATE_ID, 10).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)))) {
                    this.truncate = truncateP.intValue();
                }
                if (config.grab((Parameter)(expansionP = (DoubleParameter)new DoubleParameter(EXPANSION_ID, 1.3).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ONE_DOUBLE)))) {
                    this.expansion = expansionP.doubleValue();
                }
            }
        }
    }
}

