/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.covertree;

import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListMIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.AbstractDistanceKNNQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.range.AbstractDistanceRangeQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.index.KNNIndex;
import de.lmu.ifi.dbs.elki.index.RangeIndex;
import de.lmu.ifi.dbs.elki.index.tree.metrical.covertree.AbstractCoverTree;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.Statistic;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.DoubleObjectMinHeap;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import java.util.ArrayList;

@Reference(authors="A. Beygelzimer, S. Kakade, J. Langford", title="Cover trees for nearest neighbor", booktitle="In Proc. 23rd Int. Conf. Machine Learning (ICML 2006)", url="https://doi.org/10.1145/1143844.1143857", bibkey="DBLP:conf/icml/BeygelzimerKL06")
public class CoverTree<O>
extends AbstractCoverTree<O>
implements RangeIndex<O>,
KNNIndex<O> {
    static final Logging LOG = Logging.getLogger(CoverTree.class);
    private Node root = null;

    public CoverTree(Relation<O> relation, DistanceFunction<? super O> distanceFunction, double expansion, int truncate) {
        super(relation, distanceFunction, expansion, truncate);
    }

    public void initialize() {
        this.bulkLoad(this.relation.getDBIDs());
        if (LOG.isVerbose()) {
            int[] counts = new int[5];
            this.checkCoverTree(this.root, counts, 0);
            LOG.statistics((Statistic)new LongStatistic(((Object)((Object)this)).getClass().getName() + ".nodes", (long)counts[0]));
            LOG.statistics((Statistic)new DoubleStatistic(((Object)((Object)this)).getClass().getName() + ".avg-depth", (double)counts[1] / (double)counts[0]));
            LOG.statistics((Statistic)new LongStatistic(((Object)((Object)this)).getClass().getName() + ".max-depth", (long)counts[2]));
            LOG.statistics((Statistic)new LongStatistic(((Object)((Object)this)).getClass().getName() + ".singletons", (long)counts[3]));
            LOG.statistics((Statistic)new LongStatistic(((Object)((Object)this)).getClass().getName() + ".entries", (long)counts[4]));
        }
    }

    public void bulkLoad(DBIDs ids) {
        if (ids.size() == 0) {
            return;
        }
        assert (this.root == null) : "Tree already initialized.";
        DBIDIter it = ids.iter();
        DBID first = DBIDUtil.deref((DBIDRef)it);
        ModifiableDoubleDBIDList candidates = DBIDUtil.newDistanceDBIDList((int)(ids.size() - 1));
        it.advance();
        while (it.valid()) {
            candidates.add(this.distance((DBIDRef)first, (DBIDRef)it), (DBIDRef)it);
            it.advance();
        }
        this.root = this.bulkConstruct((DBIDRef)first, Integer.MAX_VALUE, 0.0, candidates);
    }

    protected Node bulkConstruct(DBIDRef cur, int maxScale, double parentDist, ModifiableDoubleDBIDList elems) {
        boolean curSingleton;
        assert (!elems.contains(cur));
        double max = this.maxDistance((DoubleDBIDList)elems);
        int scale = Math.min(this.distToScale(max) - 1, maxScale);
        int nextScale = scale - 1;
        if (max <= 0.0 || scale <= this.scaleBottom || elems.size() < this.truncate) {
            return new Node(cur, max, parentDist, (DoubleDBIDList)elems);
        }
        ModifiableDoubleDBIDList candidates = DBIDUtil.newDistanceDBIDList();
        this.excludeNotCovered(elems, this.scaleToDist(scale), candidates);
        if (candidates.size() == 0) {
            LOG.warning((CharSequence)("Scale not chosen appropriately? " + max + " " + this.scaleToDist(scale)));
            return this.bulkConstruct(cur, nextScale, parentDist, elems);
        }
        Node node = new Node(cur, max, parentDist);
        boolean bl = curSingleton = elems.size() == 0;
        if (!curSingleton) {
            node.children.add(this.bulkConstruct(cur, nextScale, 0.0, elems));
        }
        double fmax = this.scaleToDist(nextScale);
        DoubleDBIDListMIter it = candidates.iter();
        while (it.valid()) {
            assert (it.getOffset() == 0);
            DBID t = DBIDUtil.deref((DBIDRef)it);
            elems.clear();
            this.collectByCover((DBIDRef)it, candidates, fmax, elems);
            assert (DBIDUtil.equal((DBIDRef)t, (DBIDRef)it)) : "First element in candidates must not change!";
            if (elems.size() == 0) {
                node.singletons.add(it.doubleValue(), (DBIDRef)it);
            } else {
                node.children.add(this.bulkConstruct((DBIDRef)it, nextScale, it.doubleValue(), elems));
            }
            candidates.removeSwap(0);
        }
        assert (candidates.size() == 0);
        if (curSingleton) {
            if (node.isLeaf()) {
                node.children = null;
            } else {
                node.singletons.add(parentDist, cur);
            }
        }
        return node;
    }

    private void checkCoverTree(Node cur, int[] counts, int depth) {
        counts[0] = counts[0] + 1;
        counts[1] = counts[1] + depth;
        counts[2] = depth > counts[2] ? depth : counts[2];
        counts[3] = counts[3] + (cur.singletons.size() - 1);
        counts[4] = counts[4] + (cur.singletons.size() - (cur.children == null ? 0 : 1));
        if (cur.children != null) {
            ++depth;
            for (Node chi : cur.children) {
                this.checkCoverTree(chi, counts, depth);
            }
            assert (!cur.children.isEmpty()) : "Empty childs list.";
        }
    }

    public RangeQuery<O> getRangeQuery(DistanceQuery<O> distanceQuery, Object ... hints) {
        if (distanceQuery.getRelation() != this.relation) {
            return null;
        }
        DistanceFunction distanceFunction = distanceQuery.getDistanceFunction();
        if (!this.distanceFunction.equals(distanceFunction)) {
            LOG.debug((CharSequence)"Distance function not supported by index - or 'equals' not implemented right!");
            return null;
        }
        DistanceQuery dq = distanceFunction.instantiate(this.relation);
        return new CoverTreeRangeQuery(dq);
    }

    public KNNQuery<O> getKNNQuery(DistanceQuery<O> distanceQuery, Object ... hints) {
        if (distanceQuery.getRelation() != this.relation) {
            return null;
        }
        DistanceFunction distanceFunction = distanceQuery.getDistanceFunction();
        if (!this.distanceFunction.equals(distanceFunction)) {
            LOG.debug((CharSequence)"Distance function not supported by index - or 'equals' not implemented right!");
            return null;
        }
        DistanceQuery dq = distanceFunction.instantiate(this.relation);
        return new CoverTreeKNNQuery(dq);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Factory<O>
    extends AbstractCoverTree.Factory<O> {
        public Factory(DistanceFunction<? super O> distanceFunction, double expansion, int truncate) {
            super(distanceFunction, expansion, truncate);
        }

        public CoverTree<O> instantiate(Relation<O> relation) {
            return new CoverTree<O>(relation, this.distanceFunction, this.expansion, this.truncate);
        }

        public static class Parameterizer<O>
        extends AbstractCoverTree.Factory.Parameterizer<O> {
            protected Factory<O> makeInstance() {
                return new Factory(this.distanceFunction, this.expansion, this.truncate);
            }
        }
    }

    public class CoverTreeKNNQuery
    extends AbstractDistanceKNNQuery<O>
    implements KNNQuery<O> {
        public CoverTreeKNNQuery(DistanceQuery<O> distanceQuery) {
            super(distanceQuery);
        }

        public KNNList getKNNForObject(O obj, int k) {
            if (k < 1) {
                throw new IllegalArgumentException("At least one object has to be requested!");
            }
            KNNHeap knnList = DBIDUtil.newHeap((int)k);
            double d_k = Double.POSITIVE_INFINITY;
            DoubleObjectMinHeap pq = new DoubleObjectMinHeap();
            double rootdist = CoverTree.this.distance(obj, (DBIDRef)((CoverTree)CoverTree.this).root.singletons.iter());
            pq.add(rootdist - ((CoverTree)CoverTree.this).root.maxDist, (Object)CoverTree.this.root);
            while (!pq.isEmpty()) {
                Node cur = (Node)pq.peekValue();
                double prio = pq.peekKey();
                double d = prio + cur.maxDist;
                pq.poll();
                if (knnList.size() >= k && prio > d_k) continue;
                DoubleDBIDListMIter it = cur.singletons.iter();
                if (!cur.isLeaf()) {
                    for (Node c : cur.children) {
                        if (!(d - c.maxDist - c.parentDist <= d_k)) continue;
                        DoubleDBIDListMIter f = c.singletons.iter();
                        double d2 = DBIDUtil.equal((DBIDRef)f, (DBIDRef)it) ? d : CoverTree.this.distance(obj, (DBIDRef)f);
                        double dist = d2;
                        double newprio = dist - c.maxDist;
                        if (!(newprio <= d_k)) continue;
                        pq.add(newprio, (Object)c);
                    }
                } else if (d <= d_k) {
                    d_k = knnList.insert(d, (DBIDRef)it);
                }
                it.advance();
                while (it.valid()) {
                    double d2;
                    if (d - it.doubleValue() <= d_k && (d2 = CoverTree.this.distance(obj, (DBIDRef)it)) <= d_k) {
                        d_k = knnList.insert(d2, (DBIDRef)it);
                    }
                    it.advance();
                }
            }
            return knnList.toKNNList();
        }
    }

    public class CoverTreeRangeQuery
    extends AbstractDistanceRangeQuery<O>
    implements RangeQuery<O> {
        public CoverTreeRangeQuery(DistanceQuery<O> distanceQuery) {
            super(distanceQuery);
        }

        public void getRangeForObject(O obj, double range, ModifiableDoubleDBIDList ret) {
            ArrayList<Node> open = new ArrayList<Node>();
            open.add(CoverTree.this.root);
            while (!open.isEmpty()) {
                Node cur = (Node)open.remove(open.size() - 1);
                DoubleDBIDListMIter it = cur.singletons.iter();
                double d = CoverTree.this.distance(obj, (DBIDRef)it);
                if (d - cur.maxDist > range) continue;
                if (!cur.isLeaf()) {
                    for (Node c : cur.children) {
                        if (!(d - c.maxDist - c.parentDist <= range)) continue;
                        open.add(c);
                    }
                } else if (d <= range) {
                    ret.add(d, (DBIDRef)it);
                }
                it.advance();
                while (it.valid()) {
                    double d2;
                    if (d - it.doubleValue() <= range && (d2 = CoverTree.this.distance(obj, (DBIDRef)it)) <= range) {
                        ret.add(d2, (DBIDRef)it);
                    }
                    it.advance();
                }
            }
        }
    }

    private static final class Node {
        ModifiableDoubleDBIDList singletons;
        double maxDist = 0.0;
        double parentDist = 0.0;
        ArrayList<Node> children;

        public Node(DBIDRef r, double maxDist, double parentDist) {
            this.singletons = DBIDUtil.newDistanceDBIDList();
            this.singletons.add(0.0, r);
            this.children = new ArrayList();
            this.maxDist = maxDist;
            this.parentDist = parentDist;
        }

        public Node(DBIDRef r, double maxDist, double parentDist, DoubleDBIDList singletons) {
            assert (!singletons.contains(r));
            this.singletons = DBIDUtil.newDistanceDBIDList((int)(singletons.size() + 1));
            this.singletons.add(0.0, r);
            DoubleDBIDListIter it = singletons.iter();
            while (it.valid()) {
                this.singletons.add(it.doubleValue(), (DBIDRef)it);
                it.advance();
            }
            this.children = null;
            this.maxDist = maxDist;
            this.parentDist = parentDist;
        }

        public boolean isLeaf() {
            return this.children == null || this.children.isEmpty();
        }
    }
}

