/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.kd;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListMIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.QuickSelectDBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.AbstractDistanceKNNQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.range.AbstractDistanceRangeQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.Norm;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.LPNormDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SparseLPNormDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SquaredEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.index.AbstractIndex;
import de.lmu.ifi.dbs.elki.index.IndexFactory;
import de.lmu.ifi.dbs.elki.index.KNNIndex;
import de.lmu.ifi.dbs.elki.index.RangeIndex;
import de.lmu.ifi.dbs.elki.index.tree.spatial.kd.MinimalisticMemoryKDTree;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.Counter;
import de.lmu.ifi.dbs.elki.logging.statistics.Statistic;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Parameter;

@Reference(authors="J. L. Bentley", title="Multidimensional binary search trees used for associative searching", booktitle="Communications of the ACM 18(9)", url="https://doi.org/10.1145/361002.361007", bibkey="DBLP:journals/cacm/Bentley75")
public class SmallMemoryKDTree<O extends NumberVector>
extends AbstractIndex<O>
implements KNNIndex<O>,
RangeIndex<O> {
    private static final Logging LOG = Logging.getLogger(SmallMemoryKDTree.class);
    ModifiableDoubleDBIDList sorted = null;
    int dims = -1;
    int leafsize;
    final Counter objaccess;
    final Counter distcalc;

    public SmallMemoryKDTree(Relation<O> relation, int leafsize) {
        super(relation);
        this.leafsize = leafsize;
        assert (leafsize >= 1);
        if (LOG.isStatistics()) {
            String prefix = ((Object)((Object)this)).getClass().getName();
            this.objaccess = LOG.newCounter(prefix + ".objaccess");
            this.distcalc = LOG.newCounter(prefix + ".distancecalcs");
        } else {
            this.objaccess = null;
            this.distcalc = null;
        }
    }

    public void initialize() {
        this.sorted = DBIDUtil.newDistanceDBIDList((int)this.relation.size());
        this.dims = RelationUtil.dimensionality((Relation)this.relation);
        DBIDIter it = this.relation.iterDBIDs();
        while (it.valid()) {
            this.sorted.add(Double.NaN, (DBIDRef)it);
            it.advance();
        }
        this.buildTree(0, this.sorted.size(), 0, this.sorted.iter());
    }

    private void buildTree(int left, int right, int axis, DoubleDBIDListMIter iter) {
        assert (left < right);
        iter.seek(left);
        while (iter.getOffset() < right) {
            iter.setDouble(((NumberVector)this.relation.get((DBIDRef)iter)).doubleValue(axis));
            this.countObjectAccess();
            iter.advance();
        }
        if (right - left <= this.leafsize) {
            return;
        }
        int middle = left + right >>> 1;
        QuickSelectDBIDs.quickSelect((ModifiableDoubleDBIDList)this.sorted, (int)left, (int)right, (int)middle);
        int next = (axis + 1) % this.dims;
        if (left < middle) {
            this.buildTree(left, middle, next, iter);
        }
        if (++middle < right) {
            this.buildTree(middle, right, next, iter);
        }
    }

    public String getLongName() {
        return "kd-tree";
    }

    public String getShortName() {
        return "kd-tree";
    }

    public void logStatistics() {
        if (this.objaccess != null) {
            LOG.statistics((Statistic)this.objaccess);
        }
        if (this.distcalc != null) {
            LOG.statistics((Statistic)this.distcalc);
        }
    }

    protected void countObjectAccess() {
        if (this.objaccess != null) {
            this.objaccess.increment();
        }
    }

    protected void countDistanceComputation() {
        if (this.distcalc != null) {
            this.distcalc.increment();
        }
    }

    public KNNQuery<O> getKNNQuery(DistanceQuery<O> distanceQuery, Object ... hints) {
        DistanceFunction df = distanceQuery.getDistanceFunction();
        if (df instanceof LPNormDistanceFunction) {
            return new KDTreeKNNQuery(distanceQuery, (Norm)df);
        }
        if (df instanceof SquaredEuclideanDistanceFunction) {
            return new KDTreeKNNQuery(distanceQuery, (Norm)df);
        }
        if (df instanceof SparseLPNormDistanceFunction) {
            return new KDTreeKNNQuery(distanceQuery, (Norm)df);
        }
        return null;
    }

    public RangeQuery<O> getRangeQuery(DistanceQuery<O> distanceQuery, Object ... hints) {
        DistanceFunction df = distanceQuery.getDistanceFunction();
        if (df instanceof LPNormDistanceFunction) {
            return new KDTreeRangeQuery(distanceQuery, (Norm)df);
        }
        if (df instanceof SquaredEuclideanDistanceFunction) {
            return new KDTreeRangeQuery(distanceQuery, (Norm)df);
        }
        if (df instanceof SparseLPNormDistanceFunction) {
            return new KDTreeRangeQuery(distanceQuery, (Norm)df);
        }
        return null;
    }

    static /* synthetic */ Relation access$200(SmallMemoryKDTree x0) {
        return x0.relation;
    }

    static /* synthetic */ Relation access$300(SmallMemoryKDTree x0) {
        return x0.relation;
    }

    @Alias(value={"smallkd", "kd"})
    public static class Factory<O extends NumberVector>
    implements IndexFactory<O> {
        int leafsize;

        public Factory() {
            this(1);
        }

        public Factory(int leafsize) {
            this.leafsize = leafsize;
        }

        public SmallMemoryKDTree<O> instantiate(Relation<O> relation) {
            return new SmallMemoryKDTree<O>(relation, this.leafsize);
        }

        public TypeInformation getInputTypeRestriction() {
            return TypeUtil.NUMBER_VECTOR_FIELD;
        }

        public static class Parameterizer<O extends NumberVector>
        extends AbstractParameterizer {
            int leafsize;

            protected void makeOptions(Parameterization config) {
                super.makeOptions(config);
                IntParameter leafP = (IntParameter)new IntParameter(MinimalisticMemoryKDTree.Factory.Parameterizer.LEAFSIZE_P, 1).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
                if (config.grab((Parameter)leafP)) {
                    this.leafsize = leafP.intValue();
                }
            }

            protected Factory<O> makeInstance() {
                return new Factory(this.leafsize);
            }
        }
    }

    public class KDTreeRangeQuery
    extends AbstractDistanceRangeQuery<O> {
        private Norm<? super O> norm;

        public KDTreeRangeQuery(DistanceQuery<O> distanceQuery, Norm<? super O> norm) {
            super(distanceQuery);
            this.norm = norm;
        }

        public void getRangeForObject(O obj, double range, ModifiableDoubleDBIDList result) {
            this.kdRangeSearch(0, SmallMemoryKDTree.this.sorted.size(), 0, obj, result, (DoubleDBIDListIter)SmallMemoryKDTree.this.sorted.iter(), range);
        }

        private void kdRangeSearch(int left, int right, int axis, O query, ModifiableDoubleDBIDList res, DoubleDBIDListIter iter, double radius) {
            if (right - left <= SmallMemoryKDTree.this.leafsize) {
                iter.seek(left);
                while (iter.getOffset() < right) {
                    double dist = this.norm.distance(query, SmallMemoryKDTree.this.relation.get((DBIDRef)iter));
                    SmallMemoryKDTree.this.countObjectAccess();
                    SmallMemoryKDTree.this.countDistanceComputation();
                    if (dist <= radius) {
                        res.add(dist, (DBIDRef)iter);
                    }
                    iter.advance();
                }
                return;
            }
            int middle = left + right >>> 1;
            double delta = iter.seek(middle).doubleValue() - query.doubleValue(axis);
            boolean onleft = delta >= 0.0;
            boolean onright = delta <= 0.0;
            boolean close = Math.abs(delta) <= radius;
            int next = (axis + 1) % SmallMemoryKDTree.this.dims;
            if (close) {
                NumberVector split = (NumberVector)SmallMemoryKDTree.this.relation.get((DBIDRef)iter.seek(middle));
                SmallMemoryKDTree.this.countObjectAccess();
                double dist = this.norm.distance(query, (Object)split);
                SmallMemoryKDTree.this.countDistanceComputation();
                if (dist <= radius) {
                    assert (iter.getOffset() == middle);
                    res.add(dist, (DBIDRef)iter);
                }
            }
            if (left < middle && (onleft || close)) {
                this.kdRangeSearch(left, middle, next, query, res, iter, radius);
            }
            if (middle + 1 < right && (onright || close)) {
                this.kdRangeSearch(middle + 1, right, next, query, res, iter, radius);
            }
        }
    }

    public class KDTreeKNNQuery
    extends AbstractDistanceKNNQuery<O> {
        private Norm<? super O> norm;

        public KDTreeKNNQuery(DistanceQuery<O> distanceQuery, Norm<? super O> norm) {
            super(distanceQuery);
            this.norm = norm;
        }

        public KNNList getKNNForObject(O obj, int k) {
            KNNHeap knns = DBIDUtil.newHeap((int)k);
            this.kdKNNSearch(0, SmallMemoryKDTree.this.sorted.size(), 0, obj, knns, (DoubleDBIDListIter)SmallMemoryKDTree.this.sorted.iter(), Double.POSITIVE_INFINITY);
            return knns.toKNNList();
        }

        private double kdKNNSearch(int left, int right, int axis, O query, KNNHeap knns, DoubleDBIDListIter iter, double maxdist) {
            if (right - left <= SmallMemoryKDTree.this.leafsize) {
                iter.seek(left);
                while (iter.getOffset() < right) {
                    double dist = this.norm.distance(query, SmallMemoryKDTree.this.relation.get((DBIDRef)iter));
                    SmallMemoryKDTree.this.countObjectAccess();
                    SmallMemoryKDTree.this.countDistanceComputation();
                    if (dist <= maxdist) {
                        knns.insert(dist, (DBIDRef)iter);
                    }
                    maxdist = knns.getKNNDistance();
                    iter.advance();
                }
                return maxdist;
            }
            int middle = left + right >>> 1;
            double delta = iter.seek(middle).doubleValue() - query.doubleValue(axis);
            assert (iter.doubleValue() == ((NumberVector)SmallMemoryKDTree.this.relation.get((DBIDRef)iter)).doubleValue(axis)) : "Tree inconsistent " + left + " < " + middle + " < " + right + ": " + iter.doubleValue() + " != " + ((NumberVector)SmallMemoryKDTree.access$200(SmallMemoryKDTree.this).get((DBIDRef)iter)).doubleValue(axis) + " " + SmallMemoryKDTree.access$300(SmallMemoryKDTree.this).get((DBIDRef)iter);
            boolean onleft = delta >= 0.0;
            boolean onright = delta <= 0.0;
            int next = (axis + 1) % SmallMemoryKDTree.this.dims;
            if (onleft && onright) {
                NumberVector split = (NumberVector)SmallMemoryKDTree.this.relation.get((DBIDRef)iter.seek(middle));
                SmallMemoryKDTree.this.countObjectAccess();
                double dist = this.norm.distance(query, (Object)split);
                SmallMemoryKDTree.this.countDistanceComputation();
                if (dist <= maxdist) {
                    assert (iter.getOffset() == middle);
                    knns.insert(dist, (DBIDRef)iter);
                    maxdist = knns.getKNNDistance();
                }
                if (left < middle) {
                    maxdist = this.kdKNNSearch(left, middle, next, query, knns, iter, maxdist);
                }
                if (middle + 1 < right) {
                    maxdist = this.kdKNNSearch(middle + 1, right, next, query, knns, iter, maxdist);
                }
            } else if (onleft) {
                if (left < middle) {
                    maxdist = this.kdKNNSearch(left, middle, next, query, knns, iter, maxdist);
                }
                if (Math.abs(delta) <= maxdist) {
                    NumberVector split = (NumberVector)SmallMemoryKDTree.this.relation.get((DBIDRef)iter.seek(middle));
                    SmallMemoryKDTree.this.countObjectAccess();
                    double dist = this.norm.distance(query, (Object)split);
                    SmallMemoryKDTree.this.countDistanceComputation();
                    if (dist <= maxdist) {
                        assert (iter.getOffset() == middle);
                        knns.insert(dist, (DBIDRef)iter);
                        maxdist = knns.getKNNDistance();
                    }
                }
                if (middle + 1 < right && Math.abs(delta) <= maxdist) {
                    maxdist = this.kdKNNSearch(middle + 1, right, next, query, knns, iter, maxdist);
                }
            } else {
                if (middle + 1 < right) {
                    maxdist = this.kdKNNSearch(middle + 1, right, next, query, knns, iter, maxdist);
                }
                if (Math.abs(delta) <= maxdist) {
                    NumberVector split = (NumberVector)SmallMemoryKDTree.this.relation.get((DBIDRef)iter.seek(middle));
                    SmallMemoryKDTree.this.countObjectAccess();
                    double dist = this.norm.distance(query, (Object)split);
                    SmallMemoryKDTree.this.countDistanceComputation();
                    if (dist <= maxdist) {
                        iter.seek(middle);
                        knns.insert(dist, (DBIDRef)iter);
                        maxdist = knns.getKNNDistance();
                    }
                }
                if (left < middle && Math.abs(delta) <= maxdist) {
                    maxdist = this.kdKNNSearch(left, middle, next, query, knns, iter, maxdist);
                }
            }
            return maxdist;
        }
    }
}

