/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.vafile;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import java.util.Arrays;

@Reference(authors="Hans-Peter Kriegel, Peer Kr\u00f6ger, Matthias Schubert, Ziyue Zhu", title="Efficient Query Processing in Arbitrary Subspaces Using Vector Approximations", booktitle="Proc. 18th Int. Conf. on Scientific and Statistical Database Management (SSDBM 06)", url="https://doi.org/10.1109/SSDBM.2006.23", bibkey="DBLP:conf/ssdbm/KriegelKSZ06")
public class DAFile {
    private final int dimension;
    private final double[] splitPositions;

    public DAFile(Relation<? extends NumberVector> relation, int dimension, int partitions) {
        int size = relation.size();
        this.dimension = dimension;
        this.splitPositions = new double[partitions + 1];
        double[] tempdata = new double[size];
        int j = 0;
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            tempdata[j] = ((NumberVector)relation.get((DBIDRef)iditer)).doubleValue(dimension);
            ++j;
            iditer.advance();
        }
        Arrays.sort(tempdata);
        for (int b = 0; b < partitions; ++b) {
            int start = (int)((double)(b * size) / (double)partitions);
            this.splitPositions[b] = tempdata[start];
        }
        this.splitPositions[partitions] = tempdata[size - 1] + 1.0E-6;
    }

    public double[] getSplitPositions() {
        return this.splitPositions;
    }

    public int getDimension() {
        return this.dimension;
    }

    public int getIOCosts() {
        return this.splitPositions.length * 8 + 4;
    }
}

