/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.vafile;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListMIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.LPNormDistanceFunction;
import de.lmu.ifi.dbs.elki.index.AbstractRefiningIndex;
import de.lmu.ifi.dbs.elki.index.IndexFactory;
import de.lmu.ifi.dbs.elki.index.KNNIndex;
import de.lmu.ifi.dbs.elki.index.RangeIndex;
import de.lmu.ifi.dbs.elki.index.vafile.VALPNormDistance;
import de.lmu.ifi.dbs.elki.index.vafile.VectorApproximation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.persistent.AbstractPageFileFactory;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.DoubleMaxHeap;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.jafama.FastMath;

@Title(value="An approximation based data structure for similarity search")
@Reference(authors="R. Weber, S. Blott", title="An approximation based data structure for similarity search", booktitle="Report TR1997b, ETH Zentrum, Zurich, Switzerland", url="http://citeseerx.ist.psu.edu/viewdoc/download?doi=10.1.1.40.480&rep=rep1&type=pdf", bibkey="tr/ethz/WeberS97")
public class VAFile<V extends NumberVector>
extends AbstractRefiningIndex<V>
implements KNNIndex<V>,
RangeIndex<V> {
    private static final Logging LOG = Logging.getLogger(VAFile.class);
    private List<VectorApproximation> vectorApprox;
    private int partitions;
    private double[][] splitPositions;
    int pageSize;
    int scans;

    public VAFile(int pageSize, Relation<V> relation, int partitions) {
        super(relation);
        this.partitions = partitions;
        this.pageSize = pageSize;
        this.scans = 0;
        this.vectorApprox = new ArrayList<VectorApproximation>();
    }

    public void initialize() {
        this.setPartitions(this.relation);
        DBIDIter iter = this.relation.iterDBIDs();
        while (iter.valid()) {
            DBID id = DBIDUtil.deref((DBIDRef)iter);
            this.vectorApprox.add(this.calculateApproximation(id, (NumberVector)this.relation.get((DBIDRef)id)));
            iter.advance();
        }
    }

    public void setPartitions(Relation<V> relation) throws IllegalArgumentException {
        if (FastMath.log((double)this.partitions) / FastMath.log((double)2.0) != (double)((int)(FastMath.log((double)this.partitions) / FastMath.log((double)2.0)))) {
            throw new IllegalArgumentException("Number of partitions must be a power of 2!");
        }
        int dimensions = RelationUtil.dimensionality(relation);
        int size = relation.size();
        this.splitPositions = new double[dimensions][this.partitions + 1];
        for (int d = 0; d < dimensions; ++d) {
            double[] tempdata = new double[size];
            int j = 0;
            DBIDIter iditer = relation.iterDBIDs();
            while (iditer.valid()) {
                tempdata[j] = ((NumberVector)relation.get((DBIDRef)iditer)).doubleValue(d);
                ++j;
                iditer.advance();
            }
            Arrays.sort(tempdata);
            for (int b = 0; b < this.partitions; ++b) {
                int start = (int)((double)(b * size) / (double)this.partitions);
                this.splitPositions[d][b] = tempdata[start];
            }
            this.splitPositions[d][this.partitions] = tempdata[size - 1] + 1.0E-6;
        }
    }

    public VectorApproximation calculateApproximation(DBID id, V dv) {
        int[] approximation = new int[dv.getDimensionality()];
        for (int d = 0; d < this.splitPositions.length; ++d) {
            double val = dv.doubleValue(d);
            int lastBorderIndex = this.splitPositions[d].length - 1;
            if (val < this.splitPositions[d][0]) {
                approximation[d] = 0;
                if (id == null) continue;
                LOG.warning((CharSequence)"Vector outside of VAFile grid!");
                continue;
            }
            if (val > this.splitPositions[d][lastBorderIndex]) {
                approximation[d] = lastBorderIndex - 1;
                if (id == null) continue;
                LOG.warning((CharSequence)"Vector outside of VAFile grid!");
                continue;
            }
            int pos = Arrays.binarySearch(this.splitPositions[d], val);
            approximation[d] = pos = pos >= 0 ? pos : -pos - 2;
        }
        return new VectorApproximation(id, approximation);
    }

    public long getScannedPages() {
        int vacapacity = this.pageSize / VectorApproximation.byteOnDisk(this.splitPositions.length, this.partitions);
        long vasize = (long)Math.ceil((double)this.vectorApprox.size() / (1.0 * (double)vacapacity));
        return vasize * (long)this.scans;
    }

    public Logging getLogger() {
        return LOG;
    }

    public void logStatistics() {
        super.logStatistics();
        LOG.statistics((CharSequence)("scanned pages:" + this.getScannedPages()));
    }

    public String getLongName() {
        return "VA-file index";
    }

    public String getShortName() {
        return "va-file";
    }

    public KNNQuery<V> getKNNQuery(DistanceQuery<V> distanceQuery, Object ... hints) {
        DistanceFunction df = distanceQuery.getDistanceFunction();
        if (df instanceof LPNormDistanceFunction) {
            double p = ((LPNormDistanceFunction)df).getP();
            return new VAFileKNNQuery(distanceQuery, p);
        }
        return null;
    }

    public RangeQuery<V> getRangeQuery(DistanceQuery<V> distanceQuery, Object ... hints) {
        DistanceFunction df = distanceQuery.getDistanceFunction();
        if (df instanceof LPNormDistanceFunction) {
            double p = ((LPNormDistanceFunction)df).getP();
            return new VAFileRangeQuery(distanceQuery, p);
        }
        return null;
    }

    public static class Factory<V extends NumberVector>
    implements IndexFactory<V> {
        public static final OptionID PARTITIONS_ID = new OptionID("vafile.partitions", "Number of partitions to use in each dimension.");
        int pagesize = 1;
        int numpart = 2;

        public Factory(int pagesize, int numpart) {
            this.pagesize = pagesize;
            this.numpart = numpart;
        }

        public VAFile<V> instantiate(Relation<V> relation) {
            return new VAFile<V>(this.pagesize, relation, this.numpart);
        }

        public TypeInformation getInputTypeRestriction() {
            return TypeUtil.NUMBER_VECTOR_FIELD;
        }

        public static class Parameterizer
        extends AbstractParameterizer {
            int pagesize = 1;
            int numpart = 2;

            protected void makeOptions(Parameterization config) {
                IntParameter partitionsP;
                super.makeOptions(config);
                IntParameter pagesizeP = (IntParameter)new IntParameter(AbstractPageFileFactory.Parameterizer.PAGE_SIZE_ID, 1024).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
                if (config.grab((Parameter)pagesizeP)) {
                    this.pagesize = (Integer)pagesizeP.getValue();
                }
                if (config.grab((Parameter)(partitionsP = (IntParameter)new IntParameter(PARTITIONS_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ONE_INT)))) {
                    this.numpart = (Integer)partitionsP.getValue();
                }
            }

            protected Factory<?> makeInstance() {
                return new Factory(this.pagesize, this.numpart);
            }
        }
    }

    public class VAFileKNNQuery
    extends AbstractRefiningIndex.AbstractKNNQuery {
        final double p;

        public VAFileKNNQuery(DistanceQuery<V> distanceQuery, double p) {
            super((AbstractRefiningIndex)VAFile.this, distanceQuery);
            this.p = p;
        }

        public KNNList getKNNForObject(V query, int k) {
            VectorApproximation queryApprox = VAFile.this.calculateApproximation(null, query);
            VALPNormDistance vadist = new VALPNormDistance(this.p, VAFile.this.splitPositions, (NumberVector)query, queryApprox);
            DoubleMaxHeap minMaxHeap = new DoubleMaxHeap(k + 1);
            double minMaxDist = Double.POSITIVE_INFINITY;
            ModifiableDoubleDBIDList candidates = DBIDUtil.newDistanceDBIDList((int)VAFile.this.vectorApprox.size());
            ++VAFile.this.scans;
            for (int i = 0; i < VAFile.this.vectorApprox.size(); ++i) {
                VectorApproximation va = (VectorApproximation)VAFile.this.vectorApprox.get(i);
                double minDist = vadist.getMinDist(va);
                double maxDist = vadist.getMaxDist(va);
                if (minDist > minMaxDist) continue;
                candidates.add(minDist, (DBIDRef)va.id);
                minMaxHeap.add(maxDist, k);
                if (minMaxHeap.size() < k) continue;
                minMaxDist = minMaxHeap.peek();
            }
            candidates.sort();
            KNNHeap result = DBIDUtil.newHeap((int)k);
            DoubleDBIDListMIter iter = candidates.iter();
            while (iter.valid()) {
                if (result.size() >= k) {
                    double kDist = result.getKNNDistance();
                    if (iter.doubleValue() > kDist) break;
                }
                double dist = this.refine((DBIDRef)iter, query);
                result.insert(dist, (DBIDRef)iter);
                iter.advance();
            }
            if (LOG.isDebuggingFinest()) {
                LOG.finest((CharSequence)("query = (" + query + ")"));
                LOG.finest((CharSequence)("database: " + VAFile.this.vectorApprox.size() + ", candidates: " + candidates.size() + ", results: " + result.size()));
            }
            return result.toKNNList();
        }
    }

    public class VAFileRangeQuery
    extends AbstractRefiningIndex.AbstractRangeQuery {
        final double p;

        public VAFileRangeQuery(DistanceQuery<V> distanceQuery, double p) {
            super((AbstractRefiningIndex)VAFile.this, distanceQuery);
            this.p = p;
        }

        public void getRangeForObject(V query, double eps, ModifiableDoubleDBIDList result) {
            VectorApproximation queryApprox = VAFile.this.calculateApproximation(null, query);
            VALPNormDistance vadist = new VALPNormDistance(this.p, VAFile.this.splitPositions, (NumberVector)query, queryApprox);
            ++VAFile.this.scans;
            for (int i = 0; i < VAFile.this.vectorApprox.size(); ++i) {
                double dist;
                VectorApproximation va = (VectorApproximation)VAFile.this.vectorApprox.get(i);
                double minDist = vadist.getMinDist(va);
                if (minDist > eps || !((dist = this.refine((DBIDRef)va.id, query)) <= eps)) continue;
                result.add(dist, (DBIDRef)va.id);
            }
        }
    }
}

