/*
 * Decompiled with CFR 0.152.
 */
package de.m3y.hadoop.hdfs.hfsa.core;

import de.m3y.hadoop.hdfs.hfsa.core.FsImageLoader;
import de.m3y.hadoop.hdfs.hfsa.util.FsUtil;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.server.namenode.FSImageFormatPBINode;
import org.apache.hadoop.hdfs.server.namenode.FsImageProto;
import org.apache.hadoop.hdfs.server.namenode.SerialNumberManager;

public class FsImageData {
    public static final String ROOT_PATH = "/";
    public static final char PATH_SEPARATOR = '/';
    private final SerialNumberManager.StringTable stringTable;
    private final FsImageLoader.INodesRepository inodes;
    private final Long2ObjectLinkedOpenHashMap<long[]> dirMap;
    private static final Pattern DOUBLE_SLASH = Pattern.compile("//+");

    public FsImageData(SerialNumberManager.StringTable stringTable, FsImageLoader.INodesRepository inodes, Long2ObjectLinkedOpenHashMap<long[]> dirMap) {
        this.stringTable = stringTable;
        this.inodes = inodes;
        this.dirMap = dirMap;
    }

    public List<FsImageProto.INodeSection.INode> getFileINodesInDirectory(String path) throws IOException {
        FsImageProto.INodeSection.INode nodeId = this.getINodeFromPath(path);
        if (!FsUtil.isDirectory(nodeId)) {
            throw new IllegalArgumentException("Expected directory but <" + path + "> is of type " + nodeId.getType());
        }
        long[] children = (long[])this.dirMap.get(nodeId.getId());
        if (children.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<FsImageProto.INodeSection.INode> files = new ArrayList<FsImageProto.INodeSection.INode>(children.length);
        for (long cid : children) {
            FsImageProto.INodeSection.INode inode = this.inodes.getInode(cid);
            if (!FsUtil.isFile(inode)) continue;
            files.add(inode);
        }
        return files;
    }

    public FsImageProto.INodeSection.INode getInode(long id) throws IOException {
        return this.inodes.getInode(id);
    }

    public FsImageProto.INodeSection.INode getINodeFromPath(String path) throws IOException {
        int startIdx;
        if (!path.startsWith(ROOT_PATH)) {
            throw new IllegalArgumentException("Expected path <" + path + "> to start with " + '/');
        }
        String normalizedPath = FsImageData.normalizePath(path);
        long id = 16385L;
        if (ROOT_PATH.equals(normalizedPath)) {
            return this.inodes.getInode(id);
        }
        int endIdx = startIdx = 1;
        FsImageProto.INodeSection.INode node = null;
        while (endIdx > 0) {
            endIdx = normalizedPath.indexOf(47, startIdx);
            String pathSegment = endIdx >= 0 ? normalizedPath.substring(startIdx, endIdx) : normalizedPath.substring(startIdx);
            long[] children = (long[])this.dirMap.get(id);
            if (children.length == 0) {
                throw new FileNotFoundException(path);
            }
            boolean found = false;
            for (long cid : children) {
                node = this.inodes.getInode(cid);
                if (!pathSegment.equals(node.getName().toStringUtf8())) continue;
                found = true;
                id = node.getId();
                break;
            }
            if (!found) {
                throw new FileNotFoundException(path);
            }
            startIdx = endIdx + 1;
        }
        return node;
    }

    public boolean hasINode(String path) throws IOException {
        try {
            this.lookupInodeId(path);
            return true;
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    public List<String> getChildDirectories(String path) throws IOException {
        return this.getChildDirectories(path, childName -> true);
    }

    public List<String> getChildDirectories(String path, Predicate<FsImageProto.INodeSection.INode> filter) throws IOException {
        long parentNodeId = this.lookupInodeId(path);
        long[] children = (long[])this.dirMap.get(parentNodeId);
        if (children.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> childPaths = new ArrayList<String>();
        String pathWithTrailingSlash = path.lastIndexOf(47) == path.length() - 1 ? path : path + '/';
        for (long cid : children) {
            FsImageProto.INodeSection.INode inode = this.inodes.getInode(cid);
            if (!FsUtil.isDirectory(inode) || !filter.test(inode)) continue;
            childPaths.add(pathWithTrailingSlash + inode.getName().toStringUtf8());
        }
        return childPaths;
    }

    public boolean hasChildren(String path) throws IOException {
        long rootNodeId = this.lookupInodeId(path);
        return this.hasChildren(rootNodeId);
    }

    public boolean hasChildren(long nodeId) {
        return ((long[])this.dirMap.get(nodeId)).length > 0;
    }

    public AclStatus getAclStatus(String path) throws IOException {
        PermissionStatus p = this.getPermissionStatus(path);
        List<AclEntry> aclEntryList = this.getAclEntryList(path);
        FsPermission permission = p.getPermission();
        AclStatus.Builder builder = new AclStatus.Builder();
        builder.owner(p.getUserName()).group(p.getGroupName()).addEntries(aclEntryList).setPermission(permission).stickyBit(permission.getStickyBit());
        return builder.build();
    }

    protected List<AclEntry> getAclEntryList(String path) throws IOException {
        FsImageProto.INodeSection.INode inode = this.getINodeFromPath(path);
        switch (inode.getType()) {
            case FILE: {
                FsImageProto.INodeSection.INodeFile f = inode.getFile();
                return FSImageFormatPBINode.Loader.loadAclEntries((FsImageProto.INodeSection.AclFeatureProto)f.getAcl(), (SerialNumberManager.StringTable)this.stringTable);
            }
            case DIRECTORY: {
                FsImageProto.INodeSection.INodeDirectory d = inode.getDirectory();
                return FSImageFormatPBINode.Loader.loadAclEntries((FsImageProto.INodeSection.AclFeatureProto)d.getAcl(), (SerialNumberManager.StringTable)this.stringTable);
            }
        }
        return Collections.emptyList();
    }

    public PermissionStatus getPermissionStatus(String path) throws IOException {
        return this.getPermissionStatus(this.getINodeFromPath(path));
    }

    public PermissionStatus getPermissionStatus(FsImageProto.INodeSection.INode inode) {
        return FSImageFormatPBINode.Loader.loadPermission((long)this.getPermission(inode), (SerialNumberManager.StringTable)this.stringTable);
    }

    public long getPermission(FsImageProto.INodeSection.INode inode) {
        switch (inode.getType()) {
            case FILE: {
                FsImageProto.INodeSection.INodeFile f = inode.getFile();
                return f.getPermission();
            }
            case DIRECTORY: {
                FsImageProto.INodeSection.INodeDirectory d = inode.getDirectory();
                return d.getPermission();
            }
            case SYMLINK: {
                FsImageProto.INodeSection.INodeSymlink s = inode.getSymlink();
                return s.getPermission();
            }
        }
        throw new IllegalStateException("No implementation for getting permission status for type " + inode.getType().name() + " of INode " + inode);
    }

    private long lookupInodeId(String path) throws IOException {
        return this.getINodeFromPath(path).getId();
    }

    public PermissionStatus getPermissionStatus(long permission) {
        return FSImageFormatPBINode.Loader.loadPermission((long)permission, (SerialNumberManager.StringTable)this.stringTable);
    }

    public int getNumChildren(FsImageProto.INodeSection.INode inode) {
        return ((long[])this.dirMap.get(inode.getId())).length;
    }

    public long[] getChildINodeIds(long pathNodeId) {
        return (long[])this.dirMap.get(pathNodeId);
    }

    static String normalizePath(String path) {
        String pathWithoutDoubleSlashes = DOUBLE_SLASH.matcher(path).replaceAll(ROOT_PATH);
        int length = pathWithoutDoubleSlashes.length();
        if (length > 1 && pathWithoutDoubleSlashes.endsWith(ROOT_PATH)) {
            return pathWithoutDoubleSlashes.substring(0, length - 1);
        }
        return pathWithoutDoubleSlashes;
    }
}

