/*
 * Decompiled with CFR 0.152.
 */
package de.m3y.hadoop.hdfs.hfsa.core;

import com.google.common.primitives.ImmutableLongArray;
import de.m3y.hadoop.hdfs.hfsa.core.FsImageData;
import it.unimi.dsi.fastutil.io.FastBufferedInputStream;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.namenode.FSImageFormatProtobuf;
import org.apache.hadoop.hdfs.server.namenode.FSImageUtil;
import org.apache.hadoop.hdfs.server.namenode.FsImageProto;
import org.apache.hadoop.hdfs.server.namenode.SerialNumberManager;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.thirdparty.protobuf.CodedInputStream;
import org.apache.hadoop.thirdparty.protobuf.InvalidProtocolBufferException;
import org.apache.hadoop.thirdparty.protobuf.Parser;
import org.apache.hadoop.util.LimitInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FsImageLoader {
    private static final Logger LOG = LoggerFactory.getLogger(FsImageLoader.class);
    private final Builder.LoadingStrategy loadingStrategy;

    public FsImageLoader(Builder.LoadingStrategy loadingStrategy) {
        this.loadingStrategy = loadingStrategy;
    }

    private FsImageProto.FileSummary.Section findSectionByName(List<FsImageProto.FileSummary.Section> sectionList, FSImageFormatProtobuf.SectionName sectionName) {
        for (FsImageProto.FileSummary.Section section : sectionList) {
            if (!sectionName.name().equals(section.getName())) continue;
            return section;
        }
        throw new IllegalStateException("No such section of name " + sectionName + " found in " + sectionList.stream().map(FsImageProto.FileSummary.Section::getName).collect(Collectors.joining(", ")));
    }

    private <T> T loadSection(FileInputStream fin, String codec, FsImageProto.FileSummary.Section section, IOFunction<T> f) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loading fsimage section {} of {} bytes", (Object)section.getName(), (Object)section.getLength());
        }
        long startTime = System.currentTimeMillis();
        try {
            FileChannel fc = fin.getChannel();
            fc.position(section.getOffset());
            int bufferSize = Math.max((int)Math.min(section.getLength(), 0x100000L), 8192);
            InputStream is = FSImageUtil.wrapInputStreamForCompression((Configuration)new Configuration(), (String)codec, (InputStream)new FastBufferedInputStream((InputStream)new LimitInputStream((InputStream)fin, section.getLength()), bufferSize));
            T apply = f.apply(is, section.getLength());
            LOG.debug("Loaded fsimage section {} in {}ms", (Object)section.getName(), (Object)(System.currentTimeMillis() - startTime));
            return apply;
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Can not load fsimage section " + section.getName(), ex);
        }
    }

    public FsImageData load(RandomAccessFile file) throws IOException {
        if (!FSImageUtil.checkFileFormat((RandomAccessFile)file)) {
            throw new IOException("Unrecognized FSImage format (no magic header?)");
        }
        FsImageProto.FileSummary summary = FSImageUtil.loadSummary((RandomAccessFile)file);
        String codec = summary.getCodec();
        try (FileInputStream fin = new FileInputStream(file.getFD());){
            List sectionsList = summary.getSectionsList();
            FsImageProto.FileSummary.Section sectionStringTable = this.findSectionByName(sectionsList, FSImageFormatProtobuf.SectionName.STRING_TABLE);
            SerialNumberManager.StringTable stringTable = this.loadSection(fin, codec, sectionStringTable, this::loadStringTable);
            FsImageProto.FileSummary.Section sectionInodeRef = this.findSectionByName(sectionsList, FSImageFormatProtobuf.SectionName.INODE_REFERENCE);
            ImmutableLongArray refIdList = this.loadSection(fin, codec, sectionInodeRef, this::loadINodeReferenceSection);
            FsImageProto.FileSummary.Section sectionInode = this.findSectionByName(sectionsList, FSImageFormatProtobuf.SectionName.INODE);
            INodesRepository inodes = this.loadSection(fin, codec, sectionInode, this::loadINodeSection);
            FsImageProto.FileSummary.Section sectionInodeDir = this.findSectionByName(sectionsList, FSImageFormatProtobuf.SectionName.INODE_DIR);
            Long2ObjectLinkedOpenHashMap dirMap = this.loadSection(fin, codec, sectionInodeDir, (is, length) -> this.loadINodeDirectorySection(is, refIdList));
            FsImageData fsImageData = new FsImageData(stringTable, inodes, (Long2ObjectLinkedOpenHashMap<long[]>)dirMap);
            return fsImageData;
        }
    }

    private Long2ObjectLinkedOpenHashMap<long[]> loadINodeDirectorySection(InputStream in, ImmutableLongArray refIdList) throws IOException {
        FsImageProto.INodeDirectorySection.DirEntry e;
        Long2ObjectLinkedOpenHashMap dirs = new Long2ObjectLinkedOpenHashMap(524288);
        dirs.defaultReturnValue((Object)new long[0]);
        while ((e = FsImageProto.INodeDirectorySection.DirEntry.parseDelimitedFrom((InputStream)in)) != null) {
            int i;
            int childrenCount = e.getChildrenCount();
            long[] l = new long[childrenCount + e.getRefChildrenCount()];
            for (i = 0; i < childrenCount; ++i) {
                l[i] = e.getChildren(i);
            }
            for (i = childrenCount; i < l.length; ++i) {
                int refId = e.getRefChildren(i - childrenCount);
                l[i] = refIdList.get(refId);
            }
            dirs.put(e.getParent(), (Object)l);
        }
        LOG.debug("Loaded {} directories", (Object)dirs.size());
        return dirs;
    }

    private ImmutableLongArray loadINodeReferenceSection(InputStream in, long length) throws IOException {
        FsImageProto.INodeReferenceSection.INodeReference e;
        ImmutableLongArray.Builder builder = ImmutableLongArray.builder((int)2048);
        while ((e = FsImageProto.INodeReferenceSection.INodeReference.parseDelimitedFrom((InputStream)in)) != null) {
            builder.add(e.getReferredId());
        }
        ImmutableLongArray array = builder.build();
        LOG.debug("Loaded {} inode references of size {} bytes", (Object)array.length(), (Object)length);
        return array;
    }

    private INodesRepository loadINodeSection(InputStream in, long length) throws IOException {
        FsImageProto.INodeSection s = FsImageProto.INodeSection.parseDelimitedFrom((InputStream)in);
        return this.loadingStrategy.createInodeRepositoryBuilder().build(s, in, length);
    }

    SerialNumberManager.StringTable loadStringTable(InputStream in, long length) throws IOException {
        FsImageProto.StringTableSection s = FsImageProto.StringTableSection.parseDelimitedFrom((InputStream)in);
        SerialNumberManager.StringTable stringTable = SerialNumberManager.newStringTable((int)s.getNumEntry(), (int)s.getMaskBits());
        for (int i = 0; i < s.getNumEntry(); ++i) {
            FsImageProto.StringTableSection.Entry e = FsImageProto.StringTableSection.Entry.parseDelimitedFrom((InputStream)in);
            stringTable.put(e.getId(), e.getStr());
        }
        LOG.debug("Loaded {} strings into string table of length {} bytes", (Object)s.getNumEntry(), (Object)length);
        return stringTable;
    }

    public static class Builder {
        private LoadingStrategy loadingStrategy = PrimitiveArrayINodesRepository.Builder::new;

        public Builder parallel() {
            this.loadingStrategy = PrimitiveArrayINodesRepository.ParallelBuilder::new;
            return this;
        }

        public FsImageLoader build() {
            return new FsImageLoader(this.loadingStrategy);
        }

        static interface LoadingStrategy {
            public INodesRepositoryBuilder createInodeRepositoryBuilder();
        }
    }

    @FunctionalInterface
    private static interface IOFunction<R> {
        public R apply(InputStream var1, long var2) throws IOException;
    }

    static class PrimitiveArrayINodesRepository
    implements INodesRepository {
        private static final Parser<FsImageProto.INodeSection.INode> INODE_PARSER = FsImageProto.INodeSection.INode.parser();
        private static final Comparator<byte[]> INODE_BYTES_COMPARATOR = Comparator.comparingLong(PrimitiveArrayINodesRepository::extractNodeId);
        private final byte[][] inodes;
        private final long[] inodesIdxToIdCache;
        private final FsImageProto.INodeSection.INode rootInode;

        PrimitiveArrayINodesRepository(byte[][] buf, long[] inodeOffsets) throws InvalidProtocolBufferException {
            this.inodes = buf;
            this.inodesIdxToIdCache = inodeOffsets;
            this.rootInode = (FsImageProto.INodeSection.INode)INODE_PARSER.parseFrom(this.getInodeAsBytes(16385L));
        }

        private byte[] getInodeAsBytes(long inodeId) {
            int l = 0;
            int r = this.inodes.length - 1;
            while (l <= r) {
                int mid = l + r >>> 1;
                long currentInodeId = this.inodesIdxToIdCache[mid];
                if (currentInodeId < inodeId) {
                    l = mid + 1;
                    continue;
                }
                if (currentInodeId > inodeId) {
                    r = mid - 1;
                    continue;
                }
                return this.inodes[mid];
            }
            throw new IllegalArgumentException("Can not find inode by id " + inodeId);
        }

        @Override
        public FsImageProto.INodeSection.INode getInode(long inodeId) throws IOException {
            if (16385L == inodeId) {
                return this.rootInode;
            }
            return (FsImageProto.INodeSection.INode)INODE_PARSER.parseFrom(this.getInodeAsBytes(inodeId));
        }

        @Override
        public int getSize() {
            return this.inodes.length;
        }

        private static long extractNodeId(byte[] buf) {
            int bufferPos = 3;
            long result = 0L;
            for (int shift = 0; shift < 64; shift += 7) {
                byte b = buf[bufferPos++];
                result |= (long)(b & 0x7F) << shift;
                if ((b & 0x80) != 0) continue;
                return result;
            }
            throw new IllegalArgumentException("Malformed Varint at pos 3 : [" + buf[3] + "," + buf[4] + "," + buf[5] + "," + buf[6] + "]");
        }

        static class ParallelBuilder
        extends Builder {
            ParallelBuilder() {
            }

            @Override
            protected void sortINodes(byte[][] inodes) {
                Arrays.parallelSort(inodes, INODE_BYTES_COMPARATOR);
            }
        }

        static class Builder
        implements INodesRepositoryBuilder {
            Builder() {
            }

            @Override
            public INodesRepository build(FsImageProto.INodeSection s, InputStream in, long length) throws IOException {
                long start = System.currentTimeMillis();
                byte[][] inodes = new byte[(int)s.getNumInodes()][];
                int i = 0;
                while ((long)i < s.getNumInodes()) {
                    int size = CodedInputStream.readRawVarint32((int)in.read(), (InputStream)in);
                    byte[] bytes = new byte[size];
                    IOUtils.readFully((InputStream)in, (byte[])bytes, (int)0, (int)size);
                    inodes[i] = bytes;
                    ++i;
                }
                LOG.debug("Loaded {} inodes [{}ms] of length {} bytes", new Object[]{s.getNumInodes(), System.currentTimeMillis() - start, length});
                start = System.currentTimeMillis();
                this.sortINodes(inodes);
                LOG.debug("Sorted {} inodes [{}ms]", (Object)inodes.length, (Object)(System.currentTimeMillis() - start));
                return new PrimitiveArrayINodesRepository(inodes, this.computeInodesIdxToIdCache(inodes));
            }

            protected void sortINodes(byte[][] inodes) {
                Arrays.sort(inodes, INODE_BYTES_COMPARATOR);
            }

            protected long[] computeInodesIdxToIdCache(byte[][] buf) {
                long start = System.currentTimeMillis();
                long[] cache = new long[buf.length];
                for (int i = 0; i < cache.length; ++i) {
                    cache[i] = PrimitiveArrayINodesRepository.extractNodeId(buf[i]);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Computed inodes idx to id cache[len={}] in {}ms", (Object)cache.length, (Object)(System.currentTimeMillis() - start));
                }
                return cache;
            }
        }
    }

    static interface INodesRepositoryBuilder {
        public INodesRepository build(FsImageProto.INodeSection var1, InputStream var2, long var3) throws IOException;
    }

    static interface INodesRepository {
        public FsImageProto.INodeSection.INode getInode(long var1) throws IOException;

        public int getSize();
    }
}

