/*
 * Decompiled with CFR 0.152.
 */
package de.m3y.hadoop.hdfs.hfsa.core;

import de.m3y.hadoop.hdfs.hfsa.core.FsImageData;
import de.m3y.hadoop.hdfs.hfsa.util.FsUtil;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.hdfs.server.namenode.FsImageProto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface FsVisitor {
    public void onFile(FsImageProto.INodeSection.INode var1, String var2);

    public void onDirectory(FsImageProto.INodeSection.INode var1, String var2);

    public void onSymLink(FsImageProto.INodeSection.INode var1, String var2);

    public static class Builder {
        private static final Logger LOG = LoggerFactory.getLogger(Builder.class);
        public static final FsVisitorStrategy DEFAULT_STRATEGY = new FsVisitorDefaultStrategy();
        public static final FsVisitorStrategy PARALLEL_STRATEGY = new FsVisitorParallelStrategy();
        private final FsVisitorStrategy fsVisitorStrategy;

        public Builder() {
            this(DEFAULT_STRATEGY);
        }

        protected Builder(FsVisitorStrategy fsVisitorStrategy) {
            this.fsVisitorStrategy = fsVisitorStrategy;
        }

        public Builder parallel() {
            return new Builder(PARALLEL_STRATEGY);
        }

        public void visit(FsImageData fsImageData, FsVisitor visitor) throws IOException {
            this.fsVisitorStrategy.visit(fsImageData, visitor);
        }

        public void visit(FsImageData fsImageData, FsVisitor visitor, String path) throws IOException {
            this.fsVisitorStrategy.visit(fsImageData, visitor, path);
        }

        public static class FsVisitorParallelStrategy
        implements FsVisitorStrategy {
            @Override
            public void visit(FsImageData fsImageData, FsVisitor visitor) throws IOException {
                this.visit(fsImageData, visitor, "/");
            }

            @Override
            public void visit(FsImageData fsImageData, FsVisitor visitor, String path) throws IOException {
                FsImageProto.INodeSection.INode rootNode = fsImageData.getINodeFromPath(path);
                visitor.onDirectory(rootNode, path);
                long rootNodeId = rootNode.getId();
                long[] children = fsImageData.getChildINodeIds(rootNodeId);
                if (children.length > 0) {
                    ArrayList<FsImageProto.INodeSection.INode> dirs = new ArrayList<FsImageProto.INodeSection.INode>();
                    for (long cid : children) {
                        FsImageProto.INodeSection.INode inode2 = fsImageData.getInode(cid);
                        if (inode2.getType() == FsImageProto.INodeSection.INode.Type.DIRECTORY) {
                            dirs.add(inode2);
                            continue;
                        }
                        this.visit(fsImageData, visitor, inode2, path);
                    }
                    dirs.parallelStream().forEach(inode -> {
                        try {
                            this.visit(fsImageData, visitor, (FsImageProto.INodeSection.INode)inode, path);
                        }
                        catch (IOException e) {
                            LOG.error("Can not traverse {} : {}", new Object[]{inode.getId(), inode.getName().toStringUtf8(), e});
                        }
                    });
                }
            }

            void visit(FsImageData fsImageData, FsVisitor visitor, FsImageProto.INodeSection.INode inode, String path) throws IOException {
                if (FsUtil.isDirectory(inode)) {
                    visitor.onDirectory(inode, path);
                    long inodeId = inode.getId();
                    long[] children = fsImageData.getChildINodeIds(inodeId);
                    if (children.length > 0) {
                        String newPath = "/".equals(path) ? path + inode.getName().toStringUtf8() : path + '/' + inode.getName().toStringUtf8();
                        for (long cid : children) {
                            this.visit(fsImageData, visitor, fsImageData.getInode(cid), newPath);
                        }
                    }
                } else if (FsUtil.isFile(inode)) {
                    visitor.onFile(inode, path);
                } else if (FsUtil.isSymlink(inode)) {
                    visitor.onSymLink(inode, path);
                } else {
                    throw new IllegalStateException("Unsupported inode type " + inode.getType() + " for " + inode);
                }
            }
        }

        public static class FsVisitorDefaultStrategy
        implements FsVisitorStrategy {
            @Override
            public void visit(FsImageData fsImageData, FsVisitor visitor) throws IOException {
                this.visit(fsImageData, visitor, "/");
            }

            @Override
            public void visit(FsImageData fsImageData, FsVisitor visitor, String path) throws IOException {
                long[] children;
                FsImageProto.INodeSection.INode pathNode = fsImageData.getINodeFromPath(path);
                if ("/".equals(path)) {
                    visitor.onDirectory(pathNode, path);
                } else {
                    String substring = path.substring(0, path.length() - pathNode.getName().toStringUtf8().length());
                    visitor.onDirectory(pathNode, substring);
                }
                long pathNodeId = pathNode.getId();
                for (long cid : children = fsImageData.getChildINodeIds(pathNodeId)) {
                    this.visit(fsImageData, visitor, fsImageData.getInode(cid), path);
                }
            }

            void visit(FsImageData fsImageData, FsVisitor visitor, FsImageProto.INodeSection.INode inode, String path) throws IOException {
                if (FsUtil.isDirectory(inode)) {
                    visitor.onDirectory(inode, path);
                    long inodeId = inode.getId();
                    long[] children = fsImageData.getChildINodeIds(inodeId);
                    if (children.length > 0) {
                        String newPath = "/".equals(path) ? path + inode.getName().toStringUtf8() : path + '/' + inode.getName().toStringUtf8();
                        for (long cid : children) {
                            this.visit(fsImageData, visitor, fsImageData.getInode(cid), newPath);
                        }
                    }
                } else if (FsUtil.isFile(inode)) {
                    visitor.onFile(inode, path);
                } else if (FsUtil.isSymlink(inode)) {
                    visitor.onSymLink(inode, path);
                } else {
                    throw new IllegalStateException("Unsupported inode type " + inode.getType() + " for " + inode);
                }
            }
        }

        static interface FsVisitorStrategy {
            public void visit(FsImageData var1, FsVisitor var2) throws IOException;

            public void visit(FsImageData var1, FsVisitor var2, String var3) throws IOException;
        }
    }
}

