/*
 * Decompiled with CFR 0.152.
 */
package de.m3y.hadoop.hdfs.hfsa.util;

import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockStoragePolicySuite;
import org.apache.hadoop.hdfs.server.namenode.FsImageProto;

public class FsUtil {
    private static final BlockStoragePolicySuite BLOCK_STORAGE_POLICY_SUITE = BlockStoragePolicySuite.createDefaultSuite();

    private FsUtil() {
    }

    public static boolean isDirectory(FsImageProto.INodeSection.INode inode) {
        return inode.getType() == FsImageProto.INodeSection.INode.Type.DIRECTORY;
    }

    public static boolean isFile(FsImageProto.INodeSection.INode inode) {
        return inode.getType() == FsImageProto.INodeSection.INode.Type.FILE;
    }

    public static boolean isSymlink(FsImageProto.INodeSection.INode inode) {
        return inode.getType() == FsImageProto.INodeSection.INode.Type.SYMLINK;
    }

    public static int getFileReplication(FsImageProto.INodeSection.INodeFile file) {
        if (file.hasErasureCodingPolicyID()) {
            return 1;
        }
        return file.getReplication();
    }

    public static String toString(FsPermission permission) {
        return String.format("%o", permission.toShort());
    }

    public static BlockStoragePolicy getBlockStoragePolicy(FsImageProto.INodeSection.INodeFile iNodeFile) {
        if (iNodeFile.hasStoragePolicyID()) {
            byte policyId = (byte)iNodeFile.getStoragePolicyID();
            return BLOCK_STORAGE_POLICY_SUITE.getPolicy(policyId);
        }
        return BLOCK_STORAGE_POLICY_SUITE.getDefaultPolicy();
    }

    public static long getFileSize(FsImageProto.INodeSection.INodeFile file) {
        long size = 0L;
        for (HdfsProtos.BlockProto p : file.getBlocksList()) {
            size += p.getNumBytes();
        }
        return size;
    }
}

