/*
 * Decompiled with CFR 0.152.
 */
package de.m3y.hadoop.hdfs.hfsa.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IECBinary {
    private static final Pattern PATTERN_VALUE_WITH_STORAGE_UNIT = Pattern.compile("(\\d+)\\s*(\\w*)");
    private static final String[] UNITS = new String[]{"B", "KiB", "MiB", "GiB", "TiB", "PiB"};

    private IECBinary() {
    }

    public static String format(long numericalValue) {
        if (numericalValue < 1024L) {
            return numericalValue + " B";
        }
        int exp = (int)(Math.log(numericalValue) / Math.log(1024.0));
        String pre = "KMGTPE".charAt(exp - 1) + "i";
        return String.format("%.0f %sB", (double)numericalValue / Math.pow(1024.0, exp), pre);
    }

    public static long parse(String formattedValue) {
        Matcher matcher = PATTERN_VALUE_WITH_STORAGE_UNIT.matcher(formattedValue);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Expected pattern " + PATTERN_VALUE_WITH_STORAGE_UNIT.pattern() + " but got value <" + formattedValue + ">");
        }
        long number = Long.parseLong(matcher.group(1));
        String unit = matcher.group(2);
        if (null != unit) {
            for (int i = 0; i < UNITS.length; ++i) {
                if (!unit.equalsIgnoreCase(UNITS[i])) continue;
                number = (long)((double)number * Math.pow(1024.0, i));
                break;
            }
        }
        return number;
    }
}

