/*
 * Decompiled with CFR 0.152.
 */
package de.m3y.hadoop.hdfs.hfsa.util;

import java.util.Arrays;

public class SizeBucket {
    private long[] fileSizeBuckets;
    private final BucketModel bucketModel;

    public SizeBucket() {
        this(new Bucket2nModel());
    }

    public SizeBucket(BucketModel bucketModel) {
        this.bucketModel = bucketModel;
        this.fileSizeBuckets = new long[bucketModel.getInitialNumberOfBuckets()];
    }

    public void add(long size) {
        int bucket = this.bucketModel.computeBucket(size);
        if (bucket >= this.fileSizeBuckets.length) {
            long[] newFileSizeBuckets = new long[bucket + 1];
            System.arraycopy(this.fileSizeBuckets, 0, newFileSizeBuckets, 0, this.fileSizeBuckets.length);
            this.fileSizeBuckets = newFileSizeBuckets;
        }
        int n = bucket;
        this.fileSizeBuckets[n] = this.fileSizeBuckets[n] + 1L;
    }

    public long[] computeBucketUpperBorders() {
        return this.getBucketModel().computeBucketUpperBorders(this.findMaxNumBucket());
    }

    public int findMaxNumBucket() {
        int max = 0;
        for (int i = 0; i < this.fileSizeBuckets.length; ++i) {
            if (this.fileSizeBuckets[i] <= 0L) continue;
            max = i;
        }
        return max;
    }

    long findMaxBucketCount() {
        long max = 0L;
        for (long numBucketEntries : this.fileSizeBuckets) {
            if (max >= numBucketEntries) continue;
            max = numBucketEntries;
        }
        return max;
    }

    public long getBucketCounter(int bucket) {
        return this.fileSizeBuckets[bucket];
    }

    public long[] get() {
        return this.fileSizeBuckets;
    }

    public int size() {
        return this.fileSizeBuckets.length;
    }

    public BucketModel getBucketModel() {
        return this.bucketModel;
    }

    public String toString() {
        return "SizeBucket{" + Arrays.toString(this.fileSizeBuckets) + "}";
    }

    static class Bucket2nModel
    implements BucketModel {
        Bucket2nModel() {
        }

        @Override
        public int computeBucket(long size) {
            if (size == 0L) {
                return 0;
            }
            if (size < 0x100000L) {
                return 1;
            }
            if (size < 0x200000L) {
                return 2;
            }
            double mb = (double)size / 2097152.0;
            int v = (int)(Math.log(mb) / Math.log(2.0));
            return v + 3;
        }

        @Override
        public long[] computeBucketUpperBorders(int maxNumBuckets) {
            long[] sizes = new long[maxNumBuckets + 1];
            sizes[0] = 0L;
            if (sizes.length > 1) {
                sizes[1] = 0x100000L;
                for (int i = 2; i < sizes.length; ++i) {
                    sizes[i] = sizes[i - 1] * 2L;
                }
            }
            return sizes;
        }

        @Override
        public int getInitialNumberOfBuckets() {
            return this.computeBucket(0x1900000000L);
        }
    }

    public static interface BucketModel {
        public int computeBucket(long var1);

        public long[] computeBucketUpperBorders(int var1);

        public int getInitialNumberOfBuckets();
    }
}

