/*
 * Decompiled with CFR 0.152.
 */
package de.m3y.maven.inject;

import de.m3y.maven.inject.Injection;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="inject", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresProject=true, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
@Execute(goal="inject", lifecycle="process-classes")
public class MavenInjectMojo
extends AbstractMojo {
    @Parameter(required=true)
    private Injection[] injections;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.directory}/classes")
    private File outputDirectory;
    @Parameter(property="project.compileClasspathElements", required=true, readonly=true)
    private List<String> classpathElements;

    public void execute() throws MojoFailureException {
        ClassPool pool = this.createClassPool();
        for (Injection injection : this.injections) {
            this.doInject(injection, pool);
        }
    }

    private void doInject(Injection injection, ClassPool pool) throws MojoFailureException {
        String value = injection.getValue();
        if (null == value) {
            throw new MojoFailureException("Value is null for injection " + injection);
        }
        if (null != injection.getPointCut()) {
            this.handleInject(pool, injection.getPointCut(), value);
        }
        if (null != injection.getPointCuts()) {
            for (String pointcut : injection.getPointCuts()) {
                this.handleInject(pool, pointcut, value);
            }
        }
    }

    private void handleInject(ClassPool pool, String pointcut, String value) throws MojoFailureException {
        SourceTarget sourceTarget = this.parseSourceTarget(pointcut);
        this.getLog().info((CharSequence)("Injecting value '" + value + "' into " + pointcut));
        try {
            CtClass clazz = pool.get(sourceTarget.clazzName);
            if (clazz.isFrozen()) {
                clazz.defrost();
            }
            try {
                this.handle(clazz, sourceTarget.attribute, value);
            }
            catch (NotFoundException e) {
                throw new MojoFailureException("Can not load " + sourceTarget.clazzName + " attribute/method " + sourceTarget.attribute, (Throwable)e);
            }
            clazz.writeFile(this.outputDirectory.getAbsolutePath());
        }
        catch (NotFoundException e) {
            throw new MojoFailureException("Can not load " + sourceTarget.clazzName, (Throwable)e);
        }
        catch (CannotCompileException e) {
            throw new MojoFailureException("Can not compile", (Throwable)e);
        }
        catch (IOException e) {
            throw new MojoFailureException("Can write class ", (Throwable)e);
        }
    }

    private void handle(CtClass clazz, String attribute, String value) throws NotFoundException, CannotCompileException {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Injecting " + clazz.getName() + "#" + attribute + " with value " + value));
        }
        for (CtField field : clazz.getFields()) {
            if (!field.getName().equals(attribute)) continue;
            CtField clazzField = clazz.getField(attribute);
            clazz.removeField(clazzField);
            clazz.addField(clazzField, CtField.Initializer.constant((String)value));
            return;
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Did not find field " + attribute + ", trying methods ..."));
        }
        CtMethod clazzMethod = clazz.getDeclaredMethod(attribute);
        clazzMethod.setBody("return \"" + value + "\";");
    }

    private SourceTarget parseSourceTarget(String target) throws MojoFailureException {
        int idx = target.lastIndexOf(46);
        if (idx < 0) {
            throw new MojoFailureException("Can not parse " + target + " into pattern <FULL_CLASS_NAME>.<ATTRIBUTE|METHOD>. Expected pattern like foo.Bar.MY_VERSION or foo.Bar.getSomeValue");
        }
        SourceTarget sourceTarget = new SourceTarget();
        sourceTarget.clazzName = target.substring(0, idx);
        sourceTarget.attribute = target.substring(idx + 1);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Extract class " + sourceTarget.clazzName + " and attribute/method " + sourceTarget.attribute));
        }
        return sourceTarget;
    }

    private ClassPool createClassPool() throws MojoFailureException {
        try {
            List classpathElements = this.project.getCompileClasspathElements();
            ClassPool pool = ClassPool.getDefault();
            for (Object element : classpathElements) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Adding " + element + " to classpath"));
                }
                pool.insertClassPath(element.toString());
            }
            return pool;
        }
        catch (NotFoundException | DependencyResolutionRequiredException e) {
            throw new MojoFailureException("Can not load project compile classpath", e);
        }
    }

    private static class SourceTarget {
        String clazzName;
        String attribute;

        private SourceTarget() {
        }
    }
}

