/*
 * Decompiled with CFR 0.152.
 */
package de.m3y.maven.wire;

import com.google.common.base.Stopwatch;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import com.squareup.wire.java.JavaGenerator;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.Profile;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.PruningRules;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.SchemaLoader;
import com.squareup.wire.schema.Type;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate-sources", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true)
public class WireGenerateSourcesMojo
extends AbstractMojo {
    @Parameter(property="wire.android", defaultValue="false")
    private boolean emitAndroid;
    @Parameter(property="wire.androidAnnotations", defaultValue="false")
    private boolean emitAndroidAnnotations;
    @Parameter(property="wire.compact", defaultValue="false")
    private boolean emitCompact;
    @Parameter(property="wire.protoSourceDirectory", defaultValue="${project.basedir}/src/main/proto")
    private String protoSourceDirectory;
    @Parameter(property="wire.protoPaths")
    private String[] protoPaths;
    @Parameter(property="wire.includes")
    private String[] includes;
    @Parameter(property="wire.excludes")
    private String[] excludes;
    @Parameter(property="wire.protoFiles", required=true)
    private String[] protoFiles;
    @Parameter(property="wire.generatedSourceDirectory", defaultValue="${project.build.directory}/generated-sources/wire")
    private String generatedSourceDirectory;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        this.project.addCompileSourceRoot(this.generatedSourceDirectory);
        try {
            List<String> directories = this.protoPaths != null && this.protoPaths.length > 0 ? Arrays.asList(this.protoPaths) : Collections.singletonList(this.protoSourceDirectory);
            List<String> protoFilesList = Arrays.asList(this.protoFiles);
            Stopwatch stopwatch1 = Stopwatch.createStarted();
            SchemaLoader schemaLoader = new SchemaLoader(FileSystems.getDefault());
            schemaLoader.initRoots(directories.stream().map(Location::get).collect(Collectors.toList()), protoFilesList.stream().map(Location::get).collect(Collectors.toList()));
            Schema schema = schemaLoader.loadSchema();
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Found in " + directories + " proto files " + schema.getProtoFiles()));
            }
            this.getLog().info((CharSequence)String.format("Loaded %s proto files in %s", schema.getProtoFiles().size(), stopwatch1));
            Profile profile = schemaLoader.loadProfile(this.emitAndroid ? "android" : "java", schema);
            PruningRules pruningRules = this.pruningRules();
            if (!pruningRules.isEmpty()) {
                schema = this.retainRoots(pruningRules, schema);
            }
            JavaGenerator javaGenerator = JavaGenerator.get((Schema)schema).withAndroid(this.emitAndroid).withAndroidAnnotations(this.emitAndroidAnnotations).withCompact(this.emitCompact).withProfile(profile);
            for (ProtoFile protoFile : schema.getProtoFiles()) {
                if (!protoFilesList.isEmpty() && !protoFilesList.contains(protoFile.getLocation().getPath())) continue;
                for (Type type : protoFile.getTypes()) {
                    Stopwatch stopwatch = Stopwatch.createStarted();
                    TypeSpec typeSpec = javaGenerator.generateType(type);
                    ClassName javaTypeName = javaGenerator.generatedTypeName(type);
                    this.writeJavaFile(javaTypeName, typeSpec, type.getLocation().withPathOnly());
                    this.getLog().info((CharSequence)String.format("Generated %s in %s", javaTypeName, stopwatch));
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Wire Plugin: Failure compiling proto sources.", e);
        }
    }

    private PruningRules pruningRules() {
        PruningRules.Builder pruningRulesBuilder = new PruningRules.Builder();
        if (this.includes != null) {
            for (String identifier : this.includes) {
                pruningRulesBuilder.addRoot(identifier);
            }
        }
        if (this.excludes != null) {
            for (String identifier : this.excludes) {
                pruningRulesBuilder.prune(identifier);
            }
        }
        return pruningRulesBuilder.build();
    }

    private Schema retainRoots(PruningRules pruningRules, Schema schema) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        int oldSize = this.countTypes(schema);
        Schema prunedSchema = schema.prune(pruningRules);
        int newSize = this.countTypes(prunedSchema);
        for (String rule : pruningRules.unusedRoots()) {
            this.getLog().warn((CharSequence)String.format("Unused include: %s", rule));
        }
        for (String rule : pruningRules.unusedPrunes()) {
            this.getLog().warn((CharSequence)String.format("Unused exclude: %s", rule));
        }
        this.getLog().info((CharSequence)String.format("Pruned schema from %s types to %s types in %s", oldSize, newSize, stopwatch));
        return prunedSchema;
    }

    private int countTypes(Schema prunedSchema) {
        int result = 0;
        for (ProtoFile protoFile : prunedSchema.getProtoFiles()) {
            result += protoFile.getTypes().size();
        }
        return result;
    }

    private void writeJavaFile(ClassName javaTypeName, TypeSpec typeSpec, Location location) throws IOException {
        JavaFile.Builder builder = JavaFile.builder((String)javaTypeName.packageName(), (TypeSpec)typeSpec).addFileComment("$L", new Object[]{"Code generated by Wire protocol buffer compiler, do not edit."});
        if (location != null) {
            builder.addFileComment("\nSource file: $L", new Object[]{location});
        }
        JavaFile javaFile = builder.build();
        try {
            javaFile.writeTo(new File(this.generatedSourceDirectory));
        }
        catch (IOException e) {
            throw new IOException("Failed to write " + javaFile.packageName + "." + javaFile.typeSpec.name + " to " + this.generatedSourceDirectory, e);
        }
    }
}

