/*
 * Decompiled with CFR 0.152.
 */
package de.m3y.prometheus.assertj;

import io.prometheus.client.Collector;
import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.DoubleAssert;

public abstract class AbstractMetricFamilySamplesAssert<SELF extends AbstractMetricFamilySamplesAssert<SELF>>
extends AbstractAssert<SELF, Collector.MetricFamilySamples> {
    protected AbstractMetricFamilySamplesAssert(Collector.MetricFamilySamples metricFamilySamples) {
        super((Object)metricFamilySamples, AbstractMetricFamilySamplesAssert.class);
    }

    public SELF hasType(Collector.Type type) {
        this.isNotNull();
        if (!Objects.equals(((Collector.MetricFamilySamples)this.actual).type, type)) {
            this.failWithMessage("Expected MetricFamilySamples's %s type to be <%s> but was <%s>", new Object[]{((Collector.MetricFamilySamples)this.actual).name, type, ((Collector.MetricFamilySamples)this.actual).type});
        }
        return (SELF)((Object)((AbstractMetricFamilySamplesAssert)this.myself));
    }

    public SELF hasAnySamples() {
        this.isNotNull();
        if (null == ((Collector.MetricFamilySamples)this.actual).samples || ((Collector.MetricFamilySamples)this.actual).samples.isEmpty()) {
            this.failWithMessage("Expected one or more MetricFamilySamples %s samples but samples <%s> are null or empty", new Object[]{((Collector.MetricFamilySamples)this.actual).name, ((Collector.MetricFamilySamples)this.actual).samples});
        }
        return (SELF)((Object)((AbstractMetricFamilySamplesAssert)this.myself));
    }

    public SELF hasSampleSize(int size) {
        this.isNotNull();
        if (null == ((Collector.MetricFamilySamples)this.actual).samples) {
            this.failWithMessage("Expected MetricFamilySamples's %s samples <%s> but was null", new Object[]{((Collector.MetricFamilySamples)this.actual).name});
        }
        if (((Collector.MetricFamilySamples)this.actual).samples.size() != size) {
            this.failWithMessage("Expected MetricFamilySamples's %s samples with size %s but is with size %s .\nSamples are :\n%s", new Object[]{((Collector.MetricFamilySamples)this.actual).name, size, ((Collector.MetricFamilySamples)this.actual).samples.size(), this.toPrettyString(((Collector.MetricFamilySamples)this.actual).samples)});
        }
        return (SELF)((Object)((AbstractMetricFamilySamplesAssert)this.myself));
    }

    public SELF hasSampleLabelNames(String ... labelNames) {
        this.hasAnySamples();
        String sampleName = ((Collector.MetricFamilySamples)this.actual).name;
        if (((Collector.MetricFamilySamples)this.actual).type == Collector.Type.SUMMARY || ((Collector.MetricFamilySamples)this.actual).type == Collector.Type.HISTOGRAM) {
            sampleName = sampleName + "_count";
        } else if (((Collector.MetricFamilySamples)this.actual).type == Collector.Type.COUNTER) {
            sampleName = sampleName + "_total";
        } else if (((Collector.MetricFamilySamples)this.actual).type == Collector.Type.INFO) {
            sampleName = sampleName + "_info";
        }
        List<String> actualLabelNames = AbstractMetricFamilySamplesAssert.getLabelNames((Collector.MetricFamilySamples)this.actual, sampleName);
        try {
            Assertions.assertThat(actualLabelNames).containsExactlyInAnyOrder((Object[])labelNames);
        }
        catch (AssertionError ae) {
            if (labelNames.length == 0) {
                this.failWithMessage("Expected MetricFamilySamples's %s samples to have no labels: %s ", new Object[]{((Collector.MetricFamilySamples)this.actual).name, ((Throwable)((Object)ae)).getMessage()});
            }
            this.failWithMessage("Expected MetricFamilySamples's %s samples to have given labels: %s ", new Object[]{((Collector.MetricFamilySamples)this.actual).name, ((Throwable)((Object)ae)).getMessage() + "\nSamples are:\n" + this.toPrettyString(((Collector.MetricFamilySamples)this.actual).samples)});
        }
        return (SELF)((Object)((AbstractMetricFamilySamplesAssert)this.myself));
    }

    protected SELF hasSampleValue(String sampleName, List<String> labelValues, UnaryOperator<? super DoubleAssert> valueAssert) {
        this.isNotNull();
        this.hasAnySamples();
        String effectiveSampleName = sampleName;
        if (((Collector.MetricFamilySamples)this.actual).type == Collector.Type.COUNTER) {
            effectiveSampleName = effectiveSampleName + "_total";
        } else if (((Collector.MetricFamilySamples)this.actual).type == Collector.Type.INFO) {
            effectiveSampleName = effectiveSampleName + "_info";
        }
        List<String> labelNames = AbstractMetricFamilySamplesAssert.getLabelNames((Collector.MetricFamilySamples)this.actual, effectiveSampleName);
        Collector.MetricFamilySamples.Sample sample = this.findSample(effectiveSampleName, labelNames, labelValues);
        if (null == sample) {
            this.failWithMessage("Expected %s{%s} sample in samples :\n%s", new Object[]{effectiveSampleName, this.joinLabelNamesAndValues(labelNames, labelValues), this.toPrettyString(((Collector.MetricFamilySamples)this.actual).samples)});
        } else if (null != valueAssert) {
            try {
                valueAssert.apply(new DoubleAssert(sample.value));
            }
            catch (AssertionError ae) {
                this.failWithMessage("Unexpected value for %s{%s} : %s", new Object[]{effectiveSampleName, this.joinLabelNamesAndValues(labelNames, labelValues), ((Throwable)((Object)ae)).getMessage()});
            }
        }
        return (SELF)((Object)((AbstractMetricFamilySamplesAssert)this.myself));
    }

    private String toPrettyString(List<Collector.MetricFamilySamples.Sample> samples) {
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        for (Collector.MetricFamilySamples.Sample sample : samples) {
            if (buf.length() > 1) {
                buf.append(",\n");
            }
            this.toPrettyString(buf, sample);
        }
        buf.append(']');
        return buf.toString();
    }

    private void toPrettyString(StringBuilder buf, Collector.MetricFamilySamples.Sample sample) {
        buf.append(sample.name).append('{');
        for (int i = 0; i < sample.labelNames.size(); ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append((String)sample.labelNames.get(i)).append('=').append((String)sample.labelValues.get(i));
        }
        buf.append("} ").append(sample.value);
    }

    private Collector.MetricFamilySamples.Sample findSample(String sampleName, List<String> labelNames, List<String> labelValues) {
        for (Collector.MetricFamilySamples.Sample sample : ((Collector.MetricFamilySamples)this.actual).samples) {
            if (!sampleName.equals(sample.name) || !sample.labelNames.equals(labelNames)) continue;
            if (null == labelValues) {
                return sample;
            }
            if (!sample.labelValues.equals(labelValues)) continue;
            return sample;
        }
        return null;
    }

    private String joinLabelNamesAndValues(List<String> labelNames, List<String> labelValues) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < Math.max(labelNames.size(), labelValues.size()); ++i) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(i < labelNames.size() ? labelNames.get(i) : "");
            buf.append('=');
            buf.append(i < labelValues.size() ? labelValues.get(i) : "");
        }
        return buf.toString();
    }

    private static List<String> getLabelNames(Collector.MetricFamilySamples metricFamilySamples, String sampleName) {
        if (null == metricFamilySamples.samples || metricFamilySamples.samples.isEmpty()) {
            throw new IllegalArgumentException(metricFamilySamples.name + " has no samples : " + metricFamilySamples.samples);
        }
        for (Collector.MetricFamilySamples.Sample sample : metricFamilySamples.samples) {
            if (!sampleName.equals(sample.name)) continue;
            return sample.labelNames;
        }
        throw new IllegalStateException("Can not extract label names for sample name " + sampleName + " from " + metricFamilySamples);
    }
}

