/*
 * Decompiled with CFR 0.152.
 */
package de.m3y.prometheus.assertj;

import de.m3y.prometheus.assertj.StringUtils;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class MetricFamilySamplesUtils {
    private MetricFamilySamplesUtils() {
    }

    public static Collector.MetricFamilySamples getMetricFamilySamples(String name) {
        return MetricFamilySamplesUtils.getMetricFamilySamples(CollectorRegistry.defaultRegistry, name);
    }

    public static Collector.MetricFamilySamples getMetricFamilySamples(CollectorRegistry collectorRegistry, String name) {
        return MetricFamilySamplesUtils.getMetricFamilySamples(Collections.list(collectorRegistry.metricFamilySamples()), name);
    }

    public static Collector.MetricFamilySamples getMetricFamilySamples(List<Collector.MetricFamilySamples> metricFamilySamples, String name) {
        String[] similar = StringUtils.similar(name, (String[])metricFamilySamples.stream().map(o -> o.name).toArray(String[]::new), 5);
        return metricFamilySamples.stream().filter(mfs -> name.equals(mfs.name)).findAny().orElseThrow(() -> new IllegalArgumentException("No MetricFamilySamples found by name " + name + " , closest names are " + Arrays.toString(similar)));
    }
}

