/*
 * Decompiled with CFR 0.152.
 */
package de.m3y.prometheus.assertj;

import java.util.Arrays;
import org.apache.commons.text.similarity.LevenshteinDistance;

public class StringUtils {
    private StringUtils() {
    }

    public static String[] similar(String reference, String[] options, int n) {
        LevenshteinDistance levenshteinDistance = new LevenshteinDistance();
        Object[] values = new StringIntTupel[options.length];
        for (int i = 0; i < values.length; ++i) {
            String option = options[i];
            StringIntTupel tupel = new StringIntTupel();
            tupel.content = option;
            tupel.distance = levenshteinDistance.apply((CharSequence)reference, (CharSequence)option);
            values[i] = tupel;
        }
        Arrays.sort(values);
        String[] candidates = new String[Math.min(options.length, n)];
        for (int i = 0; i < candidates.length; ++i) {
            candidates[i] = ((StringIntTupel)values[i]).content;
        }
        return candidates;
    }

    private static class StringIntTupel
    implements Comparable<StringIntTupel> {
        String content;
        int distance;

        private StringIntTupel() {
        }

        @Override
        public int compareTo(StringIntTupel o) {
            return Integer.compare(this.distance, o.distance);
        }

        public String toString() {
            return "{content='" + this.content + '\'' + ", distance=" + this.distance + '}';
        }
    }
}

