/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.whoisServerList.publicSuffixList;

import de.malkusch.whoisServerList.publicSuffixList.PublicSuffixList;
import de.malkusch.whoisServerList.publicSuffixList.index.Index;
import de.malkusch.whoisServerList.publicSuffixList.index.IndexFactory;
import de.malkusch.whoisServerList.publicSuffixList.parser.Parser;
import de.malkusch.whoisServerList.publicSuffixList.rule.Rule;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Properties;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class PublicSuffixListFactory {
    public static final String PROPERTY_URL = "psl.url";
    public static final String PROPERTY_CHARSET = "psl.charset";
    public static final String PROPERTY_LIST_FILE = "psl.file";
    @Deprecated
    public static final String PROPERTY_INDEX = "psl.index";
    public static final String PROPERTY_INDEX_FACTORY = "psl.indexFactory";
    public static final String PROPERTY_FILE = "/psl.properties";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Properties getDefaults() {
        try (InputStream stream = this.getClass().getResourceAsStream(PROPERTY_FILE);){
            Properties properties = new Properties();
            properties.load(stream);
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PublicSuffixList build(Properties properties) throws IOException, ClassNotFoundException {
        String propertyFile = properties.getProperty(PROPERTY_LIST_FILE);
        try (InputStream listStream = this.getClass().getResourceAsStream(propertyFile);){
            PublicSuffixList list;
            URL url = new URL(properties.getProperty(PROPERTY_URL));
            Charset charset = Charset.forName(properties.getProperty(PROPERTY_CHARSET));
            Parser parser = new Parser();
            List<Rule> rules = parser.parse(listStream, charset);
            rules.add(Rule.DEFAULT);
            String indexFactoryClassName = properties.getProperty(PROPERTY_INDEX_FACTORY);
            Class<?> indexFactoryClass = Class.forName(indexFactoryClassName);
            IndexFactory indexFactory = (IndexFactory)indexFactoryClass.newInstance();
            Index index = indexFactory.build(rules);
            PublicSuffixList publicSuffixList = list = new PublicSuffixList(index, url, charset);
            return publicSuffixList;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public PublicSuffixList build() {
        try {
            return this.build(this.getDefaults());
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

