/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.whoisServerList.publicSuffixList.rule;

import de.malkusch.whoisServerList.publicSuffixList.rule.LabelMatcher;
import de.malkusch.whoisServerList.publicSuffixList.util.DomainUtil;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

@Immutable
final class RuleMatcher {
    private final String[] reversedLabels;

    RuleMatcher(String[] labels) {
        this.reversedLabels = (String[])labels.clone();
        ArrayUtils.reverse((Object[])this.reversedLabels);
    }

    RuleMatcher(String pattern) {
        this(DomainUtil.splitLabels(pattern));
    }

    String match(String domain) {
        if (domain == null) {
            return null;
        }
        Object[] reversedDomainLabels = DomainUtil.splitLabels(domain);
        ArrayUtils.reverse((Object[])reversedDomainLabels);
        if (reversedDomainLabels.length < this.reversedLabels.length) {
            return null;
        }
        Object[] reversedMatchedLabels = new String[this.reversedLabels.length];
        for (int i = 0; i < this.reversedLabels.length; ++i) {
            if (i > reversedDomainLabels.length) {
                return null;
            }
            String matchLabel = this.reversedLabels[i];
            LabelMatcher matcher = new LabelMatcher(matchLabel);
            Object domainLabel = reversedDomainLabels[i];
            if (!matcher.isMatch((String)domainLabel)) {
                return null;
            }
            reversedMatchedLabels[i] = domainLabel;
        }
        ArrayUtils.reverse((Object[])reversedMatchedLabels);
        return DomainUtil.joinLabels((String[])reversedMatchedLabels);
    }

    String getPattern() {
        Object[] labels = (String[])this.reversedLabels.clone();
        ArrayUtils.reverse((Object[])labels);
        return DomainUtil.joinLabels((String[])labels);
    }

    public String toString() {
        return this.getPattern();
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }
}

