/*
 * Decompiled with CFR 0.152.
 */
package de.mannodermaus.junit5.internal.runners;

import android.annotation.SuppressLint;
import android.util.Log;
import androidx.annotation.VisibleForTesting;
import de.mannodermaus.junit5.internal.LibcoreAccess;
import de.mannodermaus.junit5.internal.runners.AndroidJUnit5RunnerParams;
import de.mannodermaus.junit5.internal.runners.AndroidJUnit5RunnerParamsKt;
import de.mannodermaus.junit5.internal.runners.AndroidJUnitPlatformRunnerListener;
import de.mannodermaus.junit5.internal.runners.AndroidJUnitPlatformTestTree;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.LauncherFactory;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u001d\b\u0007\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0005H\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lde/mannodermaus/junit5/internal/runners/AndroidJUnit5;", "Lorg/junit/runner/Runner;", "testClass", "Ljava/lang/Class;", "runnerParams", "Lde/mannodermaus/junit5/internal/runners/AndroidJUnit5RunnerParams;", "(Ljava/lang/Class;Lde/mannodermaus/junit5/internal/runners/AndroidJUnit5RunnerParams;)V", "launcher", "Lorg/junit/platform/launcher/Launcher;", "kotlin.jvm.PlatformType", "testTree", "Lde/mannodermaus/junit5/internal/runners/AndroidJUnitPlatformTestTree;", "generateTestTree", "params", "getDescription", "Lorg/junit/runner/Description;", "registerEnvironmentVariables", "", "registerSystemProperties", "run", "notifier", "Lorg/junit/runner/notification/RunNotifier;", "runner_release"})
@SuppressLint(value={"NewApi"})
@VisibleForTesting(otherwise=3)
public final class AndroidJUnit5
extends Runner {
    @NotNull
    private final Class<?> testClass;
    @NotNull
    private final AndroidJUnit5RunnerParams runnerParams;
    private final Launcher launcher;
    @NotNull
    private final AndroidJUnitPlatformTestTree testTree;

    @JvmOverloads
    public AndroidJUnit5(@NotNull Class<?> testClass, @NotNull AndroidJUnit5RunnerParams runnerParams) {
        Intrinsics.checkNotNullParameter(testClass, (String)"testClass");
        Intrinsics.checkNotNullParameter((Object)runnerParams, (String)"runnerParams");
        this.testClass = testClass;
        this.runnerParams = runnerParams;
        this.launcher = LauncherFactory.create();
        this.testTree = this.generateTestTree(this.runnerParams);
    }

    public /* synthetic */ AndroidJUnit5(Class clazz, AndroidJUnit5RunnerParams androidJUnit5RunnerParams, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            androidJUnit5RunnerParams = AndroidJUnit5RunnerParamsKt.createRunnerParams(clazz);
        }
        this(clazz, androidJUnit5RunnerParams);
    }

    @NotNull
    public Description getDescription() {
        return this.testTree.getSuiteDescription();
    }

    public void run(@NotNull RunNotifier notifier) {
        Intrinsics.checkNotNullParameter((Object)notifier, (String)"notifier");
        this.registerEnvironmentVariables();
        this.registerSystemProperties();
        TestExecutionListener[] testExecutionListenerArray = new TestExecutionListener[]{new AndroidJUnitPlatformRunnerListener(this.testTree, notifier)};
        this.launcher.execute(this.testTree.getTestPlan(), testExecutionListenerArray);
    }

    private final void registerEnvironmentVariables() {
        Map<String, String> $this$forEach$iv = this.runnerParams.getEnvironmentVariables();
        boolean $i$f$forEach = false;
        Map<String, String> map = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> $dstr$key$value = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry<String, String> entry = $dstr$key$value;
            boolean bl3 = false;
            String key = entry.getKey();
            Map.Entry<String, String> entry2 = $dstr$key$value;
            boolean bl4 = false;
            String value = entry2.getValue();
            try {
                LibcoreAccess.INSTANCE.setenv(key, value);
            }
            catch (Throwable t) {
                Log.w((String)"AndroidJUnit5", (String)"Error while setting up environment variables.", (Throwable)t);
            }
        }
    }

    private final void registerSystemProperties() {
        Map<String, String> $this$forEach$iv = this.runnerParams.getSystemProperties();
        boolean $i$f$forEach = false;
        Map<String, String> map = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> $dstr$key$value = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry<String, String> entry = $dstr$key$value;
            boolean bl3 = false;
            String key = entry.getKey();
            Map.Entry<String, String> entry2 = $dstr$key$value;
            boolean bl4 = false;
            String value = entry2.getValue();
            try {
                System.setProperty(key, value);
            }
            catch (Throwable t) {
                Log.w((String)"AndroidJUnit5", (String)"Error while setting up system properties.", (Throwable)t);
            }
        }
    }

    private final AndroidJUnitPlatformTestTree generateTestTree(AndroidJUnit5RunnerParams params) {
        LauncherDiscoveryRequest discoveryRequest = params.createDiscoveryRequest();
        TestPlan testPlan = this.launcher.discover(discoveryRequest);
        Intrinsics.checkNotNullExpressionValue((Object)testPlan, (String)"testPlan");
        return new AndroidJUnitPlatformTestTree(testPlan, this.testClass, params.isIsolatedMethodRun());
    }

    @JvmOverloads
    public AndroidJUnit5(@NotNull Class<?> testClass) {
        Intrinsics.checkNotNullParameter(testClass, (String)"testClass");
        this(testClass, null, 2, null);
    }
}

