/*
 * Decompiled with CFR 0.152.
 */
package de.mannodermaus.junit5.internal.runners;

import android.annotation.SuppressLint;
import android.util.Log;
import de.mannodermaus.junit5.internal.runners.AndroidJUnitPlatformTestTree;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lde/mannodermaus/junit5/internal/runners/AndroidJUnitPlatformRunnerListener;", "Lorg/junit/platform/launcher/TestExecutionListener;", "testTree", "Lde/mannodermaus/junit5/internal/runners/AndroidJUnitPlatformTestTree;", "notifier", "Lorg/junit/runner/notification/RunNotifier;", "(Lde/mannodermaus/junit5/internal/runners/AndroidJUnitPlatformTestTree;Lorg/junit/runner/notification/RunNotifier;)V", "dynamicTestRegistered", "", "testIdentifier", "Lorg/junit/platform/launcher/TestIdentifier;", "executionFinished", "testExecutionResult", "Lorg/junit/platform/engine/TestExecutionResult;", "executionSkipped", "reason", "", "executionStarted", "fireTestIgnored", "toFailure", "Lorg/junit/runner/notification/Failure;", "description", "Lorg/junit/runner/Description;", "runner_release"})
@SuppressLint(value={"NewApi"})
public final class AndroidJUnitPlatformRunnerListener
implements TestExecutionListener {
    @NotNull
    private final AndroidJUnitPlatformTestTree testTree;
    @NotNull
    private final RunNotifier notifier;

    public AndroidJUnitPlatformRunnerListener(@NotNull AndroidJUnitPlatformTestTree testTree, @NotNull RunNotifier notifier) {
        Intrinsics.checkNotNullParameter((Object)testTree, (String)"testTree");
        Intrinsics.checkNotNullParameter((Object)notifier, (String)"notifier");
        this.testTree = testTree;
        this.notifier = notifier;
    }

    public void executionStarted(@NotNull TestIdentifier testIdentifier) {
        Intrinsics.checkNotNullParameter((Object)testIdentifier, (String)"testIdentifier");
        Description description = this.testTree.getDescription(testIdentifier);
        if (testIdentifier.isTest()) {
            this.notifier.fireTestStarted(description);
        }
    }

    public void dynamicTestRegistered(@NotNull TestIdentifier testIdentifier) {
        Intrinsics.checkNotNullParameter((Object)testIdentifier, (String)"testIdentifier");
        Object t = testIdentifier.getParentId().get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"testIdentifier.parentId.get()");
        this.testTree.addDynamicDescription(testIdentifier, (String)t);
    }

    public void executionSkipped(@NotNull TestIdentifier testIdentifier, @NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)testIdentifier, (String)"testIdentifier");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        if (testIdentifier.isTest()) {
            this.fireTestIgnored(testIdentifier, reason);
        } else {
            Iterable $this$forEach$iv = this.testTree.getTestsInSubtree(testIdentifier);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TestIdentifier identifier = (TestIdentifier)element$iv;
                boolean bl = false;
                this.fireTestIgnored(identifier, reason);
            }
        }
    }

    private final void fireTestIgnored(TestIdentifier testIdentifier, String reason) {
        Description description = this.testTree.getDescription(testIdentifier);
        this.notifier.fireTestIgnored(description);
        Log.w((String)"AndroidJUnit5", (String)(this.testTree.getTestName(testIdentifier) + " is ignored. " + reason));
    }

    public void executionFinished(@NotNull TestIdentifier testIdentifier, @NotNull TestExecutionResult testExecutionResult) {
        Intrinsics.checkNotNullParameter((Object)testIdentifier, (String)"testIdentifier");
        Intrinsics.checkNotNullParameter((Object)testExecutionResult, (String)"testExecutionResult");
        Description description = this.testTree.getDescription(testIdentifier);
        TestExecutionResult.Status status = testExecutionResult.getStatus();
        if (status == TestExecutionResult.Status.ABORTED) {
            this.notifier.fireTestAssumptionFailed(this.toFailure(testExecutionResult, description));
        } else if (status == TestExecutionResult.Status.FAILED) {
            this.notifier.fireTestFailure(this.toFailure(testExecutionResult, description));
        }
        if (description.isTest()) {
            this.notifier.fireTestFinished(description);
        }
    }

    private final Failure toFailure(TestExecutionResult testExecutionResult, Description description) {
        return new Failure(description, (Throwable)testExecutionResult.getThrowable().orElse(null));
    }
}

