/*
 * Decompiled with CFR 0.152.
 */
package de.mannodermaus.junit5.internal.runners;

import android.annotation.SuppressLint;
import de.mannodermaus.junit5.internal.extensions.TestIdentifierExtKt;
import de.mannodermaus.junit5.internal.runners.AndroidJUnitPlatformTestTree;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.reflect.KProperty1;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.suite.api.SuiteDisplayName;
import org.junit.platform.suite.api.UseTechnicalNames;
import org.junit.runner.Description;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0010\"\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001:\u0001*B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u0011J \u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0018\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0018\u0010\u001f\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010 \u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u000bH\u0002J\u001c\u0010!\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0002J\u000e\u0010\"\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u000bJ\u0014\u0010#\u001a\u00020\u00112\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0002J\u0010\u0010$\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\u000bH\u0002J\u000e\u0010&\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u000bJ\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000b0(2\u0006\u0010)\u001a\u00020\u000bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006+"}, d2={"Lde/mannodermaus/junit5/internal/runners/AndroidJUnitPlatformTestTree;", "", "testPlan", "Lorg/junit/platform/launcher/TestPlan;", "testClass", "Ljava/lang/Class;", "isIsolatedMethodRun", "", "(Lorg/junit/platform/launcher/TestPlan;Ljava/lang/Class;Z)V", "descriptions", "", "Lorg/junit/platform/launcher/TestIdentifier;", "Lorg/junit/runner/Description;", "modifiedTestPlan", "Lde/mannodermaus/junit5/internal/runners/AndroidJUnitPlatformTestTree$ModifiedTestPlan;", "nameExtractor", "Lkotlin/Function1;", "", "suiteDescription", "getSuiteDescription", "()Lorg/junit/runner/Description;", "getTestPlan", "()Lorg/junit/platform/launcher/TestPlan;", "addDynamicDescription", "", "newIdentifier", "parentId", "buildDescription", "identifier", "parent", "buildDescriptionTree", "createJUnit4Description", "formatTestName", "generateSuiteDescription", "getDescription", "getSuiteDisplayName", "getTechnicalName", "testIdentifier", "getTestName", "getTestsInSubtree", "", "ancestor", "ModifiedTestPlan", "runner_release"})
@SuppressLint(value={"NewApi"})
public final class AndroidJUnitPlatformTestTree {
    private final boolean isIsolatedMethodRun;
    @NotNull
    private final Map<TestIdentifier, Description> descriptions;
    @NotNull
    private final ModifiedTestPlan modifiedTestPlan;
    @NotNull
    private final Function1<TestIdentifier, String> nameExtractor;
    @NotNull
    private final Description suiteDescription;

    public AndroidJUnitPlatformTestTree(@NotNull TestPlan testPlan, @NotNull Class<?> testClass, boolean isIsolatedMethodRun) {
        Intrinsics.checkNotNullParameter((Object)testPlan, (String)"testPlan");
        Intrinsics.checkNotNullParameter(testClass, (String)"testClass");
        this.isIsolatedMethodRun = isIsolatedMethodRun;
        boolean bl = false;
        this.descriptions = new LinkedHashMap();
        this.modifiedTestPlan = new ModifiedTestPlan(testPlan);
        this.nameExtractor = (Function1)new Function1<TestIdentifier, String>(this){

            @NotNull
            public final String invoke(@NotNull TestIdentifier p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((AndroidJUnitPlatformTestTree)this.receiver).getTestName(p0);
            }
        };
        this.suiteDescription = this.generateSuiteDescription(testPlan, testClass);
    }

    @NotNull
    public final Description getSuiteDescription() {
        return this.suiteDescription;
    }

    @NotNull
    public final String getTestName(@NotNull TestIdentifier identifier) {
        String string;
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        if (identifier.isContainer()) {
            string = this.getTechnicalName(identifier);
        } else if (TestIdentifierExtKt.isDynamicTest(identifier)) {
            boolean bl = false;
            List nameComponents = new ArrayList();
            TestIdentifier currentNode = identifier;
            while (currentNode != null && TestIdentifierExtKt.isDynamicTest(currentNode)) {
                nameComponents.add(this.formatTestName(currentNode));
                currentNode = this.modifiedTestPlan.getRealParent(currentNode).orElse(null);
            }
            CollectionsKt.reverse((List)nameComponents);
            string = CollectionsKt.joinToString$default((Iterable)nameComponents, (CharSequence)": ", null, null, (int)0, null, null, (int)62, null);
        } else {
            string = this.formatTestName(identifier);
        }
        return string;
    }

    private final String formatTestName(TestIdentifier identifier) {
        if (this.isIsolatedMethodRun) {
            String reportName = identifier.getLegacyReportingName();
            Intrinsics.checkNotNullExpressionValue((Object)reportName, (String)"reportName");
            int bracketIndex = StringsKt.indexOf$default((CharSequence)reportName, (char)'(', (int)0, (boolean)false, (int)6, null);
            if (bracketIndex > -1) {
                String string = reportName;
                int n = 0;
                boolean bl = false;
                String string2 = string.substring(n, bracketIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                return string2;
            }
        }
        String string = identifier.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"identifier.displayName");
        return StringsKt.replace$default((String)string, (String)"()", (String)"", (boolean)false, (int)4, null);
    }

    @NotNull
    public final TestPlan getTestPlan() {
        return this.modifiedTestPlan.getDelegate();
    }

    @NotNull
    public final Description getDescription(@NotNull TestIdentifier identifier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        return (Description)MapsKt.getValue(this.descriptions, (Object)identifier);
    }

    private final Description generateSuiteDescription(TestPlan testPlan, Class<?> testClass) {
        String displayName = testClass.isAnnotationPresent(UseTechnicalNames.class) ? testClass.getName() : this.getSuiteDisplayName(testClass);
        Description description = Description.createSuiteDescription((String)displayName, (Annotation[])new Annotation[0]);
        boolean bl = false;
        boolean bl2 = false;
        Description it = description;
        boolean bl3 = false;
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        this.buildDescriptionTree(it, testPlan);
        Description description2 = description;
        Intrinsics.checkNotNullExpressionValue((Object)description2, (String)"createSuiteDescription(displayName).also {\n            buildDescriptionTree(it, testPlan)\n        }");
        return description2;
    }

    private final String getSuiteDisplayName(Class<?> testClass) {
        KProperty1 kProperty1 = (KProperty1)getSuiteDisplayName.1.INSTANCE;
        String string = AnnotationUtils.findAnnotation((AnnotatedElement)testClass, SuiteDisplayName.class).map(arg_0 -> AndroidJUnitPlatformTestTree.getSuiteDisplayName$lambda-1(kProperty1, arg_0)).filter(getSuiteDisplayName.2.INSTANCE).orElse(testClass.getName());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"findAnnotation(testClass, SuiteDisplayName::class.java)\n            .map(SuiteDisplayName::value)\n            .filter(String::isNotBlank)\n            .orElse(testClass.name)");
        return string;
    }

    private final void buildDescriptionTree(Description suiteDescription, TestPlan testPlan) {
        Set set = testPlan.getRoots();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"testPlan.roots");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TestIdentifier identifier = (TestIdentifier)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)identifier, (String)"identifier");
            this.buildDescription(identifier, suiteDescription, testPlan);
        }
    }

    public final void addDynamicDescription(@NotNull TestIdentifier newIdentifier, @NotNull String parentId) {
        Intrinsics.checkNotNullParameter((Object)newIdentifier, (String)"newIdentifier");
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        Description parent = this.getDescription(this.modifiedTestPlan.getTestIdentifier(parentId));
        this.buildDescription(newIdentifier, parent, this.modifiedTestPlan);
    }

    private final void buildDescription(TestIdentifier identifier, Description parent, TestPlan testPlan) {
        Description newDescription = this.createJUnit4Description(identifier, testPlan);
        parent.addChild(newDescription);
        Object object = this.descriptions;
        boolean bl = false;
        object.put((TestIdentifier)identifier, (Description)newDescription);
        object = testPlan.getChildren(identifier);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"testPlan.getChildren(identifier)");
        Iterable $this$forEach$iv = (Iterable)object;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TestIdentifier child = (TestIdentifier)element$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)child, (String)"child");
            this.buildDescription(child, newDescription, testPlan);
        }
    }

    private final Description createJUnit4Description(TestIdentifier identifier, TestPlan testPlan) {
        Description description;
        String name = (String)this.nameExtractor.invoke((Object)identifier);
        if (identifier.isTest()) {
            Function1<TestIdentifier, String> function1 = this.nameExtractor;
            Description description2 = Description.createTestDescription((String)testPlan.getParent(identifier).map(arg_0 -> AndroidJUnitPlatformTestTree.createJUnit4Description$lambda-4(function1, arg_0)).orElse("<unrooted>"), (String)name, (Serializable)((Serializable)((Object)identifier.getUniqueId())));
            Intrinsics.checkNotNullExpressionValue((Object)description2, (String)"{\n            Description.createTestDescription(\n                /* className = */ testPlan.getParent(identifier)\n                    .map(nameExtractor)\n                    .orElse(\"<unrooted>\"),\n                /* name = */ name,\n                /* uniqueId = */ identifier.uniqueId\n            )\n        }");
            description = description2;
        } else {
            Description description3 = Description.createSuiteDescription((String)name, (Serializable)((Serializable)((Object)identifier.getUniqueId())), (Annotation[])new Annotation[0]);
            Intrinsics.checkNotNullExpressionValue((Object)description3, (String)"{\n            Description.createSuiteDescription(name, identifier.uniqueId)\n        }");
            description = description3;
        }
        return description;
    }

    private final String getTechnicalName(TestIdentifier testIdentifier) {
        Optional optionalSource = testIdentifier.getSource();
        if (optionalSource.isPresent()) {
            Object object = optionalSource.get();
            Intrinsics.checkNotNullExpressionValue(object, (String)"optionalSource.get()");
            TestSource source = (TestSource)object;
            if (source instanceof ClassSource) {
                object = ((ClassSource)source).getJavaClass().getName();
                Intrinsics.checkNotNullExpressionValue(object, (String)"source.javaClass.name");
                return object;
            }
            if (source instanceof MethodSource) {
                String string;
                String methodParameterTypes = ((MethodSource)source).getMethodParameterTypes();
                Intrinsics.checkNotNullExpressionValue((Object)methodParameterTypes, (String)"methodParameterTypes");
                if (StringsKt.isBlank((CharSequence)methodParameterTypes)) {
                    String string2 = ((MethodSource)source).getMethodName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n                    source.methodName\n                }");
                    string = string2;
                } else {
                    StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                    String string3 = "%s(%s)";
                    Object[] objectArray = new Object[]{((MethodSource)source).getMethodName(), methodParameterTypes};
                    boolean bl = false;
                    String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
                    string = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(format, *args)");
                }
                return string;
            }
        }
        String string = testIdentifier.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"testIdentifier.displayName");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<TestIdentifier> getTestsInSubtree(@NotNull TestIdentifier ancestor) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)ancestor, (String)"ancestor");
        Iterable $this$filter$iv = this.modifiedTestPlan.getDescendants(ancestor);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TestIdentifier it = (TestIdentifier)element$iv$iv;
            boolean bl = false;
            if (!it.isTest()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private static final String getSuiteDisplayName$lambda-1(KProperty1 $tmp0, SuiteDisplayName p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final String createJUnit4Description$lambda-4(Function1 $tmp0, TestIdentifier p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke((Object)p0);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0000\u0012\u00020\t0\u000fH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u00112\u0006\u0010\u0012\u001a\u00020\tH\u0002J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u00142\u0006\u0010\u0017\u001a\u00020\tH\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\u00142\u0006\u0010\u0017\u001a\u00020\tH\u0016J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\u00112\u0006\u0010\u0012\u001a\u00020\tH\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\t0\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\tJ\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\t0\u0014H\u0016J\u0010\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u001e"}, d2={"Lde/mannodermaus/junit5/internal/runners/AndroidJUnitPlatformTestTree$ModifiedTestPlan;", "Lorg/junit/platform/launcher/TestPlan;", "delegate", "(Lorg/junit/platform/launcher/TestPlan;)V", "getDelegate", "()Lorg/junit/platform/launcher/TestPlan;", "add", "", "testIdentifier", "Lorg/junit/platform/launcher/TestIdentifier;", "containsTests", "", "countTestIdentifiers", "", "predicate", "Ljava/util/function/Predicate;", "findEligibleParentOfDynamicTest", "Ljava/util/Optional;", "child", "getChildren", "", "parentId", "", "parent", "getDescendants", "getParent", "getRealParent", "getRoots", "getTestIdentifier", "uniqueId", "runner_release"})
    private static final class ModifiedTestPlan
    extends TestPlan {
        @NotNull
        private final TestPlan delegate;

        public ModifiedTestPlan(@NotNull TestPlan delegate) {
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            super(delegate.containsTests(), delegate.getConfigurationParameters());
            this.delegate = delegate;
        }

        @NotNull
        public final TestPlan getDelegate() {
            return this.delegate;
        }

        @NotNull
        public final Optional<TestIdentifier> getRealParent(@Nullable TestIdentifier child) {
            Optional optional = this.delegate.getParent(child);
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"delegate.getParent(child)");
            return optional;
        }

        @NotNull
        public Optional<TestIdentifier> getParent(@NotNull TestIdentifier child) {
            Intrinsics.checkNotNullParameter((Object)child, (String)"child");
            return TestIdentifierExtKt.isDynamicTest(child) ? this.findEligibleParentOfDynamicTest(child) : this.getRealParent(child);
        }

        private final Optional<TestIdentifier> findEligibleParentOfDynamicTest(TestIdentifier child) {
            Optional<Object> optional;
            Optional node = this.delegate.getParent(child);
            while (node.isPresent()) {
                optional = node.get();
                Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"node.get()");
                if (!TestIdentifierExtKt.isDynamicTest((TestIdentifier)optional)) break;
                node = node.flatMap(arg_0 -> ((TestPlan)this.delegate).getParent(arg_0));
            }
            optional = node;
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"node");
            return optional;
        }

        public void add(@NotNull TestIdentifier testIdentifier) {
            Intrinsics.checkNotNullParameter((Object)testIdentifier, (String)"testIdentifier");
            this.delegate.add(testIdentifier);
        }

        @NotNull
        public Set<TestIdentifier> getRoots() {
            Set set = this.delegate.getRoots();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"delegate.roots");
            return set;
        }

        @NotNull
        public Set<TestIdentifier> getChildren(@NotNull TestIdentifier parent) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            Set set = this.delegate.getChildren(parent);
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"delegate.getChildren(parent)");
            return set;
        }

        @NotNull
        public Set<TestIdentifier> getChildren(@NotNull String parentId) {
            Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
            Set set = this.delegate.getChildren(parentId);
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"delegate.getChildren(parentId)");
            return set;
        }

        @NotNull
        public TestIdentifier getTestIdentifier(@NotNull String uniqueId) {
            Intrinsics.checkNotNullParameter((Object)uniqueId, (String)"uniqueId");
            TestIdentifier testIdentifier = this.delegate.getTestIdentifier(uniqueId);
            Intrinsics.checkNotNullExpressionValue((Object)testIdentifier, (String)"delegate.getTestIdentifier(uniqueId)");
            return testIdentifier;
        }

        public long countTestIdentifiers(@NotNull Predicate<? super TestIdentifier> predicate) {
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            return this.delegate.countTestIdentifiers(predicate);
        }

        @NotNull
        public Set<TestIdentifier> getDescendants(@NotNull TestIdentifier parent) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            Set set = this.delegate.getDescendants(parent);
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"delegate.getDescendants(parent)");
            return set;
        }

        public boolean containsTests() {
            return this.delegate.containsTests();
        }
    }
}

