/*
 * Decompiled with CFR 0.152.
 */
package de.mannodermaus.junit5.internal.runners;

import android.util.Log;
import de.mannodermaus.junit5.internal.extensions.ClassExtKt;
import java.lang.reflect.Method;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lde/mannodermaus/junit5/internal/runners/DummyJUnit5;", "Lorg/junit/runner/Runner;", "testClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)V", "testMethods", "", "Ljava/lang/reflect/Method;", "getDescription", "Lorg/junit/runner/Description;", "run", "", "notifier", "Lorg/junit/runner/notification/RunNotifier;", "runner_release"})
public final class DummyJUnit5
extends Runner {
    @NotNull
    private final Class<?> testClass;
    @NotNull
    private final List<Method> testMethods;

    public DummyJUnit5(@NotNull Class<?> testClass) {
        Intrinsics.checkNotNullParameter(testClass, (String)"testClass");
        this.testClass = testClass;
        this.testMethods = ClassExtKt.jupiterTestMethods(this.testClass);
    }

    public void run(@NotNull RunNotifier notifier) {
        Intrinsics.checkNotNullParameter((Object)notifier, (String)"notifier");
        Log.w((String)"AndroidJUnit5", (String)"JUnit 5 is not supported on this device. All Jupiter tests will be disabled.");
        for (Method testMethod : this.testMethods) {
            Description description = Description.createTestDescription(this.testClass, (String)testMethod.getName());
            notifier.fireTestIgnored(description);
        }
    }

    @NotNull
    public Description getDescription() {
        Description description = Description.createSuiteDescription(this.testClass);
        Intrinsics.checkNotNullExpressionValue((Object)description, (String)"createSuiteDescription(testClass)");
        return description;
    }
}

