/*
 * Decompiled with CFR 0.152.
 */
package JsonXssCleaner;

import JsonXssCleaner.ValueNode;
import java.util.Iterator;
import org.parboiled.BaseParser;
import org.parboiled.Node;
import org.parboiled.Parboiled;
import org.parboiled.Rule;
import org.parboiled.annotations.BuildParseTree;
import org.parboiled.annotations.SkipNode;
import org.parboiled.buffers.InputBuffer;
import org.parboiled.parserunners.RecoveringParseRunner;
import org.parboiled.support.ParsingResult;

@BuildParseTree
public class JsonXssFilter
extends BaseParser<Object> {
    private static JsonXssFilter parser = (JsonXssFilter)Parboiled.createParser(JsonXssFilter.class, (Object[])new Object[0]);

    Rule Json() {
        return this.Sequence(this.WhiteSpace(), this.Optional(this.FirstOf(this.JsonObject(), this.JsonArray(), new Object[0]).skipNode()).skipNode(), new Object[]{this.WhiteSpace(), EOI}).label("Root");
    }

    @SkipNode
    Rule JsonObject() {
        return this.Sequence(this.String("{"), this.WhiteSpace(), new Object[]{this.ZeroOrMore(this.Pair()).skipNode(), this.ZeroOrMore(this.Sequence(this.WhiteSpace(), this.String(","), new Object[]{this.WhiteSpace(), this.Pair()}).skipNode()).skipNode(), this.WhiteSpace(), this.String("}")});
    }

    @SkipNode
    Rule Pair() {
        return this.Sequence(this.WhiteSpace(), this.JsonString(), new Object[]{this.WhiteSpace(), this.String(":"), this.WhiteSpace(), this.Value(), this.WhiteSpace()});
    }

    Rule Value() {
        return this.FirstOf(this.JsonString(), this.JsonNumber(), new Object[]{this.JsonTrue(), this.JsonFalse(), this.JsonNull(), this.JsonObject(), this.JsonArray()}).skipNode();
    }

    Rule String() {
        return this.ZeroOrMore(this.Character());
    }

    @SkipNode
    Rule JsonString() {
        return this.Sequence(this.String("\""), this.ZeroOrMore(this.Character()).skipNode(), new Object[]{this.String("\"")});
    }

    Rule JsonNumber() {
        return this.FirstOf(this.HexInteger(), this.Float(), new Object[]{this.Integer()});
    }

    @SkipNode
    Rule Float() {
        return this.Sequence(this.Integer(), this.FirstOf(this.Sequence(this.Frac(), this.Exp(), new Object[0]).skipNode(), this.Exp(), new Object[]{this.Frac()}).skipNode(), new Object[0]);
    }

    @SkipNode
    Rule HexInteger() {
        return this.Sequence(this.FirstOf(this.String("0x").skipNode(), this.String("-0x").skipNode(), new Object[0]).skipNode(), this.OneOrMore(this.HexDigit()).skipNode(), new Object[0]);
    }

    @SkipNode
    Rule JsonArray() {
        return this.Sequence(this.String("["), this.WhiteSpace(), new Object[]{this.ZeroOrMore(this.Value()).skipNode(), this.ZeroOrMore(this.Sequence(this.WhiteSpace(), this.String(","), new Object[]{this.WhiteSpace(), this.Value()}).skipNode()).skipNode(), this.WhiteSpace(), this.String("]")});
    }

    @SkipNode
    Rule Character() {
        return this.FirstOf(this.subLess(), this.subMore(), new Object[]{this.subQuote(), this.subExecuteQuote(), this.subDoubleQuote(), this.EscapedChar(), this.NormalChar()});
    }

    Rule subLess() {
        return this.Sequence(this.FirstOf(this.String("<").skipNode(), this.IgnoreCase("\\u003c").skipNode(), new Object[0]).skipNode(), this.push(new ValueNode("&lt;")), new Object[0]);
    }

    Rule subMore() {
        return this.Sequence(this.FirstOf(this.String(">").skipNode(), this.IgnoreCase("\\u003e").skipNode(), new Object[0]).skipNode(), this.push(new ValueNode("&gt;")), new Object[0]);
    }

    Rule subQuote() {
        return this.Sequence(this.FirstOf(this.String("'").skipNode(), this.IgnoreCase("\\u0027").skipNode(), new Object[0]).skipNode(), this.push(new ValueNode("&apos;")), new Object[0]);
    }

    Rule subExecuteQuote() {
        return this.Sequence(this.FirstOf(this.String("`").skipNode(), this.IgnoreCase("\\u0060").skipNode(), new Object[0]).skipNode(), this.push(new ValueNode("&#96;")), new Object[0]);
    }

    Rule subDoubleQuote() {
        return this.Sequence(this.FirstOf(this.String("\\\"").skipNode(), this.IgnoreCase("\\\\u0022").skipNode(), new Object[0]).skipNode(), this.push(new ValueNode("&quot;")), new Object[0]);
    }

    Rule EscapedChar() {
        return this.Sequence(this.String("\\").skipNode(), this.FirstOf(this.AnyOf("\"\\/bfnrt").skipNode(), this.Unicode(), new Object[0]).skipNode(), new Object[0]);
    }

    Rule NormalChar() {
        return this.Sequence(this.TestNot(this.AnyOf("\"\\").skipNode()), ANY.skipNode(), new Object[0]);
    }

    @SkipNode
    Rule Unicode() {
        return this.Sequence(this.String("u").skipNode(), this.HexDigit(), new Object[]{this.HexDigit(), this.HexDigit(), this.HexDigit()});
    }

    @SkipNode
    Rule Integer() {
        return this.Sequence(this.Optional(this.AnyOf("+-").skipNode()).skipNode(), this.Digit(), new Object[]{this.Optional(this.Digits()).skipNode()});
    }

    @SkipNode
    Rule Digits() {
        return this.OneOrMore(this.Digit());
    }

    @SkipNode
    Rule Digit() {
        return this.CharRange('0', '9');
    }

    @SkipNode
    Rule HexDigit() {
        return this.FirstOf(this.Digit(), this.CharRange('a', 'f').skipNode(), new Object[]{this.CharRange('A', 'F').skipNode()});
    }

    @SkipNode
    Rule Frac() {
        return this.Sequence(this.String(".").skipNode(), this.Digits(), new Object[0]);
    }

    @SkipNode
    Rule Exp() {
        return this.Sequence(this.IgnoreCase("e").skipNode(), this.Integer(), new Object[0]);
    }

    Rule JsonTrue() {
        return this.String("true");
    }

    Rule JsonFalse() {
        return this.String("false");
    }

    Rule JsonNull() {
        return this.String("null");
    }

    @SkipNode
    Rule WhiteSpace() {
        return this.ZeroOrMore(this.AnyOf(" \n\r\t\f").skipNode());
    }

    private static String clean(String inp, Rule root) {
        ParsingResult result = new RecoveringParseRunner(root).run(inp);
        if (!result.matched || !result.parseErrors.isEmpty()) {
            return null;
        }
        return JsonXssFilter.traverse((Node<ValueNode>)result.parseTreeRoot, result.inputBuffer, null).toString();
    }

    public static String cleanJson(String inp) {
        return JsonXssFilter.clean(inp, parser.Json());
    }

    public static String cleanString(String inp) {
        return JsonXssFilter.clean(inp, parser.String());
    }

    public static void main(String[] argv) {
        String inp = " [9,\"0xaffe meno\", \"[\\t\\b\\f\\n\\r\\\\\\\"\\uaffe ]\", true,false ,   null, 0x10, -0x10, -9, 8.7, -8.7, 8e+10,8e10,8e-10, -8e+10,-8e10,-8e-10, 8.8e+10,8.8e10,8.9e-10, -8.8e+10,-8.8e10,-8.9e-10,[1,2],{}]";
        inp = "{\"meno\": 42.9, \"abels\":\"<script>\", \"1\": " + inp + "}";
        System.out.println("Hello Json:" + inp);
        System.out.println("Ciao  Json:" + JsonXssFilter.cleanJson(inp));
        System.out.println("Ciao  String:" + JsonXssFilter.cleanString("meno<script>ja"));
    }

    private static StringBuilder traverse(Node<ValueNode> o, InputBuffer inp, StringBuilder _sb) {
        StringBuilder sb = _sb;
        if (sb == null) {
            sb = new StringBuilder();
        }
        if (_sb != null) {
            if (o.getValue() != null && o.getLabel().startsWith("sub")) {
                sb.append(((ValueNode)o.getValue()).getValue());
            } else {
                String str = inp.extract(o.getStartIndex(), o.getEndIndex());
                sb.append(str);
            }
        }
        Iterator i = o.getChildren().iterator();
        while (i.hasNext()) {
            JsonXssFilter.traverse((Node<ValueNode>)((Node)i.next()), inp, sb);
        }
        return sb;
    }
}

