/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.grizzly;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.Body;
import com.ning.http.client.BodyGenerator;
import com.ning.http.client.ConnectionsPool;
import com.ning.http.client.Cookie;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.FluentStringsMap;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.MaxRedirectException;
import com.ning.http.client.Part;
import com.ning.http.client.PerRequestConfig;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.Realm;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import com.ning.http.client.UpgradeHandler;
import com.ning.http.client.filter.FilterContext;
import com.ning.http.client.filter.ResponseFilter;
import com.ning.http.client.listener.TransferCompletionHandler;
import com.ning.http.client.providers.grizzly.FeedableBodyGenerator;
import com.ning.http.client.providers.grizzly.GrizzlyAsyncHttpProviderConfig;
import com.ning.http.client.providers.grizzly.GrizzlyConnectionsPool;
import com.ning.http.client.providers.grizzly.GrizzlyResponse;
import com.ning.http.client.providers.grizzly.GrizzlyResponseBodyPart;
import com.ning.http.client.providers.grizzly.GrizzlyResponseFuture;
import com.ning.http.client.providers.grizzly.GrizzlyResponseHeaders;
import com.ning.http.client.providers.grizzly.GrizzlyResponseStatus;
import com.ning.http.client.providers.grizzly.TransportCustomizer;
import com.ning.http.client.websocket.WebSocket;
import com.ning.http.client.websocket.WebSocketByteListener;
import com.ning.http.client.websocket.WebSocketCloseCodeReasonListener;
import com.ning.http.client.websocket.WebSocketPingListener;
import com.ning.http.client.websocket.WebSocketPongListener;
import com.ning.http.client.websocket.WebSocketTextListener;
import com.ning.http.client.websocket.WebSocketUpgradeHandler;
import com.ning.http.multipart.MultipartRequestEntity;
import com.ning.http.util.AsyncHttpProviderUtils;
import com.ning.http.util.AuthenticatorUtils;
import com.ning.http.util.ProxyUtils;
import com.ning.http.util.SslUtils;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLContext;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.FileTransfer;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.FilterChainEvent;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.http.ContentEncoding;
import org.glassfish.grizzly.http.EncodingFilter;
import org.glassfish.grizzly.http.GZipContentEncoding;
import org.glassfish.grizzly.http.HttpClientFilter;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.Protocol;
import org.glassfish.grizzly.http.util.CookieSerializerUtils;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.http.util.MimeHeaders;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.impl.SafeFutureImpl;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.nio.transport.TCPNIOConnectorHandler;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.ssl.SSLFilter;
import org.glassfish.grizzly.strategies.SameThreadIOStrategy;
import org.glassfish.grizzly.strategies.WorkerThreadIOStrategy;
import org.glassfish.grizzly.utils.BufferOutputStream;
import org.glassfish.grizzly.utils.Charsets;
import org.glassfish.grizzly.utils.DelayedExecutor;
import org.glassfish.grizzly.utils.Futures;
import org.glassfish.grizzly.utils.IdleTimeoutFilter;
import org.glassfish.grizzly.websockets.DataFrame;
import org.glassfish.grizzly.websockets.DefaultWebSocket;
import org.glassfish.grizzly.websockets.HandShake;
import org.glassfish.grizzly.websockets.ProtocolHandler;
import org.glassfish.grizzly.websockets.Version;
import org.glassfish.grizzly.websockets.WebSocketEngine;
import org.glassfish.grizzly.websockets.WebSocketFilter;
import org.glassfish.grizzly.websockets.WebSocketListener;
import org.glassfish.grizzly.websockets.draft06.ClosingFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrizzlyAsyncHttpProvider
implements AsyncHttpProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(GrizzlyAsyncHttpProvider.class);
    private static final boolean SEND_FILE_SUPPORT = GrizzlyAsyncHttpProvider.configSendFileSupport();
    private final Attribute<HttpTransactionContext> REQUEST_STATE_ATTR = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(HttpTransactionContext.class.getName());
    private final BodyHandlerFactory bodyHandlerFactory = new BodyHandlerFactory();
    private final TCPNIOTransport clientTransport;
    private final AsyncHttpClientConfig clientConfig;
    private final ConnectionManager connectionManager;
    DelayedExecutor.Resolver<Connection> resolver;
    private DelayedExecutor timeoutExecutor;

    public GrizzlyAsyncHttpProvider(AsyncHttpClientConfig clientConfig) {
        this.clientConfig = clientConfig;
        TCPNIOTransportBuilder builder = TCPNIOTransportBuilder.newInstance();
        this.clientTransport = builder.build();
        this.initializeTransport(clientConfig);
        this.connectionManager = new ConnectionManager(this, this.clientTransport);
        try {
            this.clientTransport.start();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public <T> ListenableFuture<T> execute(final Request request, final AsyncHandler<T> handler) throws IOException {
        GrizzlyResponseFuture future;
        block4: {
            future = new GrizzlyResponseFuture(this, request, handler);
            future.setDelegate(SafeFutureImpl.create());
            CompletionHandler<Connection> connectHandler = new CompletionHandler<Connection>(){

                @Override
                public void cancelled() {
                    future.cancel(true);
                }

                @Override
                public void failed(Throwable throwable) {
                    future.abort(throwable);
                }

                @Override
                public void completed(Connection c) {
                    block5: {
                        try {
                            GrizzlyAsyncHttpProvider.this.execute(c, request, handler, future);
                        }
                        catch (Exception e) {
                            if (e instanceof RuntimeException) {
                                this.failed(e);
                            } else if (e instanceof IOException) {
                                this.failed(e);
                            }
                            if (!LOGGER.isWarnEnabled()) break block5;
                            LOGGER.warn(e.toString(), e);
                        }
                    }
                }

                @Override
                public void updated(Connection c) {
                }
            };
            try {
                this.connectionManager.doAsyncTrackedConnection(request, future, connectHandler);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                if (!LOGGER.isWarnEnabled()) break block4;
                LOGGER.warn(e.toString(), e);
            }
        }
        return future;
    }

    @Override
    public void close() {
        try {
            this.connectionManager.destroy();
            this.clientTransport.stop();
            ExecutorService service = this.clientConfig.executorService();
            if (service != null) {
                service.shutdown();
            }
            if (this.timeoutExecutor != null) {
                this.timeoutExecutor.stop();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public Response prepareResponse(HttpResponseStatus status, HttpResponseHeaders headers, Collection<HttpResponseBodyPart> bodyParts) {
        return new GrizzlyResponse(status, headers, bodyParts);
    }

    protected <T> ListenableFuture<T> execute(Connection c, Request request, AsyncHandler<T> handler, GrizzlyResponseFuture<T> future) throws IOException {
        block5: {
            try {
                if (this.getHttpTransactionContext(c) == null) {
                    this.setHttpTransactionContext(c, new HttpTransactionContext(future, request, handler));
                }
                c.write(request, this.createWriteCompletionHandler(future));
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                if (!LOGGER.isWarnEnabled()) break block5;
                LOGGER.warn(e.toString(), e);
            }
        }
        return future;
    }

    protected void initializeTransport(final AsyncHttpClientConfig clientConfig) {
        SSLContext context;
        boolean defaultSecState;
        FilterChainBuilder fcb = FilterChainBuilder.stateless();
        fcb.add(new AsyncHttpClientTransportFilter());
        final int timeout = clientConfig.getRequestTimeoutInMs();
        if (timeout > 0) {
            int delay = 500;
            if (timeout < delay) {
                delay = timeout - 10;
            }
            this.timeoutExecutor = IdleTimeoutFilter.createDefaultIdleDelayedExecutor(delay, TimeUnit.MILLISECONDS);
            this.timeoutExecutor.start();
            IdleTimeoutFilter.TimeoutResolver timeoutResolver = new IdleTimeoutFilter.TimeoutResolver(){

                public long getTimeout(FilterChainContext ctx) {
                    HttpTransactionContext context = GrizzlyAsyncHttpProvider.this.getHttpTransactionContext(ctx.getConnection());
                    if (context != null) {
                        long timeout2;
                        if (context.isWSRequest) {
                            return clientConfig.getWebSocketIdleTimeoutInMs();
                        }
                        PerRequestConfig config = context.request.getPerRequestConfig();
                        if (config != null && (timeout2 = (long)config.getRequestTimeoutInMs()) > 0L) {
                            return timeout2;
                        }
                    }
                    return timeout;
                }
            };
            IdleTimeoutFilter timeoutFilter = new IdleTimeoutFilter(this.timeoutExecutor, timeoutResolver, new IdleTimeoutFilter.TimeoutHandler(){

                public void onTimeout(Connection connection) {
                    GrizzlyAsyncHttpProvider.this.timeout(connection);
                }
            });
            fcb.add(timeoutFilter);
            this.resolver = timeoutFilter.getResolver();
        }
        boolean bl = defaultSecState = (context = clientConfig.getSSLContext()) != null;
        if (context == null) {
            try {
                context = SslUtils.getSSLContext();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        SSLEngineConfigurator configurator = new SSLEngineConfigurator(context, true, false, false);
        SwitchingSSLFilter filter = new SwitchingSSLFilter(configurator, defaultSecState);
        fcb.add(filter);
        AsyncHttpClientEventFilter eventFilter = new AsyncHttpClientEventFilter(this);
        AsyncHttpClientFilter clientFilter = new AsyncHttpClientFilter(clientConfig);
        ContentEncoding[] encodings = eventFilter.getContentEncodings();
        if (encodings.length > 0) {
            for (ContentEncoding encoding : encodings) {
                eventFilter.removeContentEncoding(encoding);
            }
        }
        if (clientConfig.isCompressionEnabled()) {
            eventFilter.addContentEncoding(new GZipContentEncoding(512, 512, new ClientEncodingFilter()));
        }
        fcb.add(eventFilter);
        fcb.add(clientFilter);
        GrizzlyAsyncHttpProviderConfig providerConfig = (GrizzlyAsyncHttpProviderConfig)clientConfig.getAsyncHttpProviderConfig();
        if (providerConfig != null) {
            TransportCustomizer customizer = (TransportCustomizer)providerConfig.getProperty(GrizzlyAsyncHttpProviderConfig.Property.TRANSPORT_CUSTOMIZER);
            if (customizer != null) {
                customizer.customize(this.clientTransport, fcb);
            } else {
                this.doDefaultTransportConfig();
            }
        } else {
            this.doDefaultTransportConfig();
        }
        fcb.add(new WebSocketFilter());
        this.clientTransport.getAsyncQueueIO().getWriter().setMaxPendingBytesPerConnection(-1);
        this.clientTransport.setProcessor(fcb.build());
    }

    void touchConnection(Connection c, Request request) {
        PerRequestConfig config = request.getPerRequestConfig();
        if (config != null) {
            long timeout = config.getRequestTimeoutInMs();
            if (timeout > 0L) {
                long newTimeout = System.currentTimeMillis() + timeout;
                if (this.resolver != null) {
                    this.resolver.setTimeoutMillis(c, newTimeout);
                }
            }
        } else {
            long timeout = this.clientConfig.getRequestTimeoutInMs();
            if (timeout > 0L && this.resolver != null) {
                this.resolver.setTimeoutMillis(c, System.currentTimeMillis() + timeout);
            }
        }
    }

    private static boolean configSendFileSupport() {
        return (!System.getProperty("os.name").equalsIgnoreCase("linux") || GrizzlyAsyncHttpProvider.linuxSendFileSupported()) && !System.getProperty("os.name").equalsIgnoreCase("HP-UX");
    }

    private static boolean linuxSendFileSupported() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.6")) {
            int idx = version.indexOf(95);
            if (idx == -1) {
                return false;
            }
            int patchRev = Integer.parseInt(version.substring(idx + 1));
            return patchRev >= 18;
        }
        return version.startsWith("1.7") || version.startsWith("1.8");
    }

    private void doDefaultTransportConfig() {
        ExecutorService service = this.clientConfig.executorService();
        if (service != null) {
            this.clientTransport.setIOStrategy(WorkerThreadIOStrategy.getInstance());
            this.clientTransport.setWorkerThreadPool(service);
        } else {
            this.clientTransport.setIOStrategy(SameThreadIOStrategy.getInstance());
        }
    }

    private <T> CompletionHandler<WriteResult> createWriteCompletionHandler(final GrizzlyResponseFuture<T> future) {
        return new CompletionHandler<WriteResult>(){

            @Override
            public void cancelled() {
                future.cancel(true);
            }

            @Override
            public void failed(Throwable throwable) {
                future.abort(throwable);
            }

            @Override
            public void completed(WriteResult result) {
            }

            @Override
            public void updated(WriteResult result) {
            }
        };
    }

    void setHttpTransactionContext(AttributeStorage storage, HttpTransactionContext httpTransactionState) {
        if (httpTransactionState == null) {
            this.REQUEST_STATE_ATTR.remove(storage);
        } else {
            this.REQUEST_STATE_ATTR.set(storage, httpTransactionState);
        }
    }

    HttpTransactionContext getHttpTransactionContext(AttributeStorage storage) {
        return this.REQUEST_STATE_ATTR.get(storage);
    }

    void timeout(Connection c) {
        HttpTransactionContext context = this.getHttpTransactionContext(c);
        this.setHttpTransactionContext(c, null);
        context.abort(new TimeoutException("Timeout exceeded"));
    }

    static int getPort(URI uri, int p) {
        int port = p;
        if (port == -1) {
            String protocol = uri.getScheme().toLowerCase();
            if ("http".equals(protocol) || "ws".equals(protocol)) {
                port = 80;
            } else if ("https".equals(protocol) || "wss".equals(protocol)) {
                port = 443;
            } else {
                throw new IllegalArgumentException("Unknown protocol: " + protocol);
            }
        }
        return port;
    }

    boolean sendRequest(FilterChainContext ctx, Request request, HttpRequestPacket requestPacket) throws IOException {
        boolean isWriteComplete = true;
        if (GrizzlyAsyncHttpProvider.requestHasEntityBody(request)) {
            HttpTransactionContext context = this.getHttpTransactionContext(ctx.getConnection());
            BodyHandler handler = this.bodyHandlerFactory.getBodyHandler(request);
            if (requestPacket.getHeaders().contains(Header.Expect) && requestPacket.getHeaders().getValue(1).equalsIgnoreCase("100-Continue")) {
                handler = new ExpectHandler(handler);
            }
            context.bodyHandler = handler;
            isWriteComplete = handler.doHandle(ctx, request, requestPacket);
        } else {
            ctx.write((Object)requestPacket, ctx.getTransportContext().getCompletionHandler());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("REQUEST: " + requestPacket.toString());
        }
        return isWriteComplete;
    }

    private static boolean requestHasEntityBody(Request request) {
        String method = request.getMethod();
        return Method.POST.matchesMethod(method) || Method.PUT.matchesMethod(method) || Method.PATCH.matchesMethod(method) || Method.DELETE.matchesMethod(method);
    }

    private static final class AHCWebSocketListenerAdapter
    implements WebSocketListener {
        private final com.ning.http.client.websocket.WebSocketListener ahcListener;
        private final WebSocket webSocket;

        AHCWebSocketListenerAdapter(com.ning.http.client.websocket.WebSocketListener ahcListener, WebSocket webSocket) {
            this.ahcListener = ahcListener;
            this.webSocket = webSocket;
        }

        public void onClose(org.glassfish.grizzly.websockets.WebSocket gWebSocket, DataFrame dataFrame) {
            try {
                if (WebSocketCloseCodeReasonListener.class.isAssignableFrom(this.ahcListener.getClass())) {
                    ClosingFrame cf = (ClosingFrame)ClosingFrame.class.cast(dataFrame);
                    ((WebSocketCloseCodeReasonListener)WebSocketCloseCodeReasonListener.class.cast(this.ahcListener)).onClose(this.webSocket, cf.getCode(), cf.getReason());
                } else {
                    this.ahcListener.onClose(this.webSocket);
                }
            }
            catch (Throwable e) {
                this.ahcListener.onError(e);
            }
        }

        public void onConnect(org.glassfish.grizzly.websockets.WebSocket gWebSocket) {
            try {
                this.ahcListener.onOpen(this.webSocket);
            }
            catch (Throwable e) {
                this.ahcListener.onError(e);
            }
        }

        public void onMessage(org.glassfish.grizzly.websockets.WebSocket webSocket, String s) {
            try {
                if (WebSocketTextListener.class.isAssignableFrom(this.ahcListener.getClass())) {
                    ((WebSocketTextListener)WebSocketTextListener.class.cast(this.ahcListener)).onMessage(s);
                }
            }
            catch (Throwable e) {
                this.ahcListener.onError(e);
            }
        }

        public void onMessage(org.glassfish.grizzly.websockets.WebSocket webSocket, byte[] bytes) {
            try {
                if (WebSocketByteListener.class.isAssignableFrom(this.ahcListener.getClass())) {
                    ((WebSocketByteListener)WebSocketByteListener.class.cast(this.ahcListener)).onMessage(bytes);
                }
            }
            catch (Throwable e) {
                this.ahcListener.onError(e);
            }
        }

        public void onPing(org.glassfish.grizzly.websockets.WebSocket webSocket, byte[] bytes) {
            try {
                if (WebSocketPingListener.class.isAssignableFrom(this.ahcListener.getClass())) {
                    ((WebSocketPingListener)WebSocketPingListener.class.cast(this.ahcListener)).onPing(bytes);
                }
            }
            catch (Throwable e) {
                this.ahcListener.onError(e);
            }
        }

        public void onPong(org.glassfish.grizzly.websockets.WebSocket webSocket, byte[] bytes) {
            try {
                if (WebSocketPongListener.class.isAssignableFrom(this.ahcListener.getClass())) {
                    ((WebSocketPongListener)WebSocketPongListener.class.cast(this.ahcListener)).onPong(bytes);
                }
            }
            catch (Throwable e) {
                this.ahcListener.onError(e);
            }
        }

        public void onFragment(org.glassfish.grizzly.websockets.WebSocket webSocket, String s, boolean b) {
            try {
                if (WebSocketTextListener.class.isAssignableFrom(this.ahcListener.getClass())) {
                    ((WebSocketTextListener)WebSocketTextListener.class.cast(this.ahcListener)).onFragment(s, b);
                }
            }
            catch (Throwable e) {
                this.ahcListener.onError(e);
            }
        }

        public void onFragment(org.glassfish.grizzly.websockets.WebSocket webSocket, byte[] bytes, boolean b) {
            try {
                if (WebSocketByteListener.class.isAssignableFrom(this.ahcListener.getClass())) {
                    ((WebSocketByteListener)WebSocketByteListener.class.cast(this.ahcListener)).onFragment(bytes, b);
                }
            }
            catch (Throwable e) {
                this.ahcListener.onError(e);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AHCWebSocketListenerAdapter that = (AHCWebSocketListenerAdapter)o;
            if (this.ahcListener != null ? !this.ahcListener.equals(that.ahcListener) : that.ahcListener != null) {
                return false;
            }
            return !(this.webSocket != null ? !this.webSocket.equals(that.webSocket) : that.webSocket != null);
        }

        public int hashCode() {
            int result = this.ahcListener != null ? this.ahcListener.hashCode() : 0;
            result = 31 * result + (this.webSocket != null ? this.webSocket.hashCode() : 0);
            return result;
        }
    }

    private static final class GrizzlyWebSocketAdapter
    implements WebSocket {
        private final org.glassfish.grizzly.websockets.WebSocket gWebSocket;

        GrizzlyWebSocketAdapter(org.glassfish.grizzly.websockets.WebSocket gWebSocket) {
            this.gWebSocket = gWebSocket;
        }

        public WebSocket sendMessage(byte[] message) {
            this.gWebSocket.send(message);
            return this;
        }

        public WebSocket stream(byte[] fragment, boolean last) {
            if (fragment != null && fragment.length > 0) {
                this.gWebSocket.stream(last, fragment, 0, fragment.length);
            }
            return this;
        }

        public WebSocket stream(byte[] fragment, int offset, int len, boolean last) {
            if (fragment != null && fragment.length > 0) {
                this.gWebSocket.stream(last, fragment, offset, len);
            }
            return this;
        }

        public WebSocket sendTextMessage(String message) {
            this.gWebSocket.send(message);
            return this;
        }

        public WebSocket streamText(String fragment, boolean last) {
            this.gWebSocket.stream(last, fragment);
            return this;
        }

        public WebSocket sendPing(byte[] payload) {
            this.gWebSocket.sendPing(payload);
            return this;
        }

        public WebSocket sendPong(byte[] payload) {
            this.gWebSocket.sendPong(payload);
            return this;
        }

        public WebSocket addWebSocketListener(com.ning.http.client.websocket.WebSocketListener l) {
            this.gWebSocket.add(new AHCWebSocketListenerAdapter(l, this));
            return this;
        }

        public WebSocket removeWebSocketListener(com.ning.http.client.websocket.WebSocketListener l) {
            this.gWebSocket.remove(new AHCWebSocketListenerAdapter(l, this));
            return this;
        }

        public boolean isOpen() {
            return this.gWebSocket.isConnected();
        }

        public void close() {
            this.gWebSocket.close();
        }
    }

    private static final class GrizzlyTransferAdapter
    extends TransferCompletionHandler.TransferAdapter {
        public GrizzlyTransferAdapter(FluentCaseInsensitiveStringsMap headers) throws IOException {
            super(headers);
        }

        public void getBytes(byte[] bytes) {
        }
    }

    static final class SwitchingSSLFilter
    extends SSLFilter {
        private final boolean secureByDefault;
        final Attribute<Boolean> CONNECTION_IS_SECURE = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(SwitchingSSLFilter.class.getName());

        SwitchingSSLFilter(SSLEngineConfigurator clientConfig, boolean secureByDefault) {
            super(null, clientConfig);
            this.secureByDefault = secureByDefault;
        }

        public NextAction handleEvent(FilterChainContext ctx, FilterChainEvent event) throws IOException {
            if (event.type() == SSLSwitchingEvent.class) {
                SSLSwitchingEvent se = (SSLSwitchingEvent)event;
                this.CONNECTION_IS_SECURE.set(se.connection, (Boolean)se.secure);
                return ctx.getStopAction();
            }
            return ctx.getInvokeAction();
        }

        public NextAction handleRead(FilterChainContext ctx) throws IOException {
            if (this.isSecure(ctx.getConnection())) {
                return super.handleRead(ctx);
            }
            return ctx.getInvokeAction();
        }

        public NextAction handleWrite(FilterChainContext ctx) throws IOException {
            if (this.isSecure(ctx.getConnection())) {
                return super.handleWrite(ctx);
            }
            return ctx.getInvokeAction();
        }

        private boolean isSecure(Connection c) {
            Boolean secStatus = this.CONNECTION_IS_SECURE.get(c);
            if (secStatus == null) {
                secStatus = this.secureByDefault;
            }
            return secStatus;
        }

        static final class SSLSwitchingEvent
        implements FilterChainEvent {
            final boolean secure;
            final Connection connection;

            SSLSwitchingEvent(boolean secure, Connection c) {
                this.secure = secure;
                this.connection = c;
            }

            public Object type() {
                return SSLSwitchingEvent.class;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ConnectionManager {
        private static final Attribute<Boolean> DO_NOT_CACHE = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(ConnectionManager.class.getName());
        private final ConnectionsPool<String, Connection> pool;
        private final TCPNIOConnectorHandler connectionHandler;
        private final ConnectionMonitor connectionMonitor;
        private final GrizzlyAsyncHttpProvider provider;

        ConnectionManager(GrizzlyAsyncHttpProvider provider, TCPNIOTransport transport) {
            ConnectionsPool<?, ?> pool;
            this.provider = provider;
            AsyncHttpClientConfig config = provider.clientConfig;
            ConnectionsPool<String, Connection> connectionPool = config.getAllowPoolingConnection() ? ((pool = config.getConnectionsPool()) != null ? pool : new GrizzlyConnectionsPool(config)) : new NonCachingPool();
            this.pool = connectionPool;
            this.connectionHandler = TCPNIOConnectorHandler.builder(transport).build();
            int maxConns = provider.clientConfig.getMaxTotalConnections();
            this.connectionMonitor = new ConnectionMonitor(maxConns);
        }

        static void markConnectionAsDoNotCache(Connection c) {
            DO_NOT_CACHE.set(c, Boolean.TRUE);
        }

        static boolean isConnectionCacheable(Connection c) {
            Boolean canCache = DO_NOT_CACHE.get(c);
            return canCache != null ? canCache : false;
        }

        void doAsyncTrackedConnection(Request request, GrizzlyResponseFuture requestFuture, CompletionHandler<Connection> connectHandler) throws IOException, ExecutionException, InterruptedException {
            String url = request.getUrl();
            Connection c = this.pool.poll(AsyncHttpProviderUtils.getBaseUrl(url));
            if (c == null) {
                if (!this.connectionMonitor.acquire()) {
                    throw new IOException("Max connections exceeded");
                }
                this.doAsyncConnect(url, request, requestFuture, connectHandler);
            } else {
                this.provider.touchConnection(c, request);
                connectHandler.completed(c);
            }
        }

        Connection obtainConnection(Request request, GrizzlyResponseFuture requestFuture) throws IOException, ExecutionException, InterruptedException, TimeoutException {
            Connection c = this.obtainConnection0(request.getUrl(), request, requestFuture);
            DO_NOT_CACHE.set(c, Boolean.TRUE);
            return c;
        }

        void doAsyncConnect(String url, Request request, GrizzlyResponseFuture requestFuture, CompletionHandler<Connection> connectHandler) throws IOException, ExecutionException, InterruptedException {
            int port;
            URI uri = AsyncHttpProviderUtils.createUri(url);
            ProxyServer proxy = this.getProxyServer(request);
            if (ProxyUtils.avoidProxy(proxy, request)) {
                proxy = null;
            }
            String host = proxy != null ? proxy.getHost() : uri.getHost();
            int n = port = proxy != null ? proxy.getPort() : uri.getPort();
            if (request.getLocalAddress() != null) {
                this.connectionHandler.connect(new InetSocketAddress(host, GrizzlyAsyncHttpProvider.getPort(uri, port)), new InetSocketAddress(request.getLocalAddress(), 0), this.createConnectionCompletionHandler(request, requestFuture, connectHandler));
            } else {
                this.connectionHandler.connect((SocketAddress)new InetSocketAddress(host, GrizzlyAsyncHttpProvider.getPort(uri, port)), this.createConnectionCompletionHandler(request, requestFuture, connectHandler));
            }
        }

        private Connection obtainConnection0(String url, Request request, GrizzlyResponseFuture requestFuture) throws IOException, ExecutionException, InterruptedException, TimeoutException {
            URI uri = AsyncHttpProviderUtils.createUri(url);
            ProxyServer proxy = this.getProxyServer(request);
            if (ProxyUtils.avoidProxy(proxy, request)) {
                proxy = null;
            }
            String host = proxy != null ? proxy.getHost() : uri.getHost();
            int port = proxy != null ? proxy.getPort() : uri.getPort();
            int cTimeout = this.provider.clientConfig.getConnectionTimeoutInMs();
            FutureImpl future = Futures.createSafeFuture();
            CompletionHandler<Connection> ch = Futures.toCompletionHandler(future, this.createConnectionCompletionHandler(request, requestFuture, null));
            if (cTimeout > 0) {
                this.connectionHandler.connect((SocketAddress)new InetSocketAddress(host, GrizzlyAsyncHttpProvider.getPort(uri, port)), ch);
                return (Connection)future.get(cTimeout, TimeUnit.MILLISECONDS);
            }
            this.connectionHandler.connect((SocketAddress)new InetSocketAddress(host, GrizzlyAsyncHttpProvider.getPort(uri, port)), ch);
            return (Connection)future.get();
        }

        private ProxyServer getProxyServer(Request request) {
            ProxyServer proxyServer = request.getProxyServer();
            if (proxyServer == null) {
                proxyServer = this.provider.clientConfig.getProxyServer();
            }
            return proxyServer;
        }

        boolean returnConnection(String url, Connection c) {
            boolean result;
            boolean bl = result = DO_NOT_CACHE.get(c) == null && this.pool.offer(AsyncHttpProviderUtils.getBaseUrl(url), c);
            if (result && this.provider.resolver != null) {
                this.provider.resolver.setTimeoutMillis(c, IdleTimeoutFilter.FOREVER);
            }
            return result;
        }

        boolean canReturnConnection(Connection c) {
            return DO_NOT_CACHE.get(c) != null || this.pool.canCacheConnection();
        }

        void destroy() {
            this.pool.destroy();
        }

        CompletionHandler<Connection> createConnectionCompletionHandler(final Request request, final GrizzlyResponseFuture future, final CompletionHandler<Connection> wrappedHandler) {
            return new CompletionHandler<Connection>(){

                @Override
                public void cancelled() {
                    if (wrappedHandler != null) {
                        wrappedHandler.cancelled();
                    } else {
                        future.cancel(true);
                    }
                }

                @Override
                public void failed(Throwable throwable) {
                    if (wrappedHandler != null) {
                        wrappedHandler.failed(throwable);
                    } else {
                        future.abort(throwable);
                    }
                }

                @Override
                public void completed(Connection connection) {
                    future.setConnection(connection);
                    ConnectionManager.this.provider.touchConnection(connection, request);
                    if (wrappedHandler != null) {
                        connection.addCloseListener(ConnectionManager.this.connectionMonitor);
                        wrappedHandler.completed(connection);
                    }
                }

                @Override
                public void updated(Connection result) {
                    if (wrappedHandler != null) {
                        wrappedHandler.updated(result);
                    }
                }
            };
        }

        private static class ConnectionMonitor
        implements Connection.CloseListener {
            private final Semaphore connections;

            ConnectionMonitor(int maxConnections) {
                this.connections = maxConnections != -1 ? new Semaphore(maxConnections) : null;
            }

            public boolean acquire() {
                return this.connections == null || this.connections.tryAcquire();
            }

            public void onClosed(Connection connection, Connection.CloseType closeType) throws IOException {
                if (this.connections != null) {
                    this.connections.release();
                }
            }
        }
    }

    private static final class BodyGeneratorBodyHandler
    implements BodyHandler {
        private BodyGeneratorBodyHandler() {
        }

        public boolean handlesBodyType(Request request) {
            return request.getBodyGenerator() != null;
        }

        public boolean doHandle(FilterChainContext ctx, Request request, HttpRequestPacket requestPacket) throws IOException {
            BodyGenerator generator = request.getBodyGenerator();
            Body bodyLocal = generator.createBody();
            long len = bodyLocal.getContentLength();
            if (len > 0L) {
                requestPacket.setContentLengthLong(len);
            } else {
                requestPacket.setChunked(true);
            }
            MemoryManager mm = ctx.getMemoryManager();
            boolean last = false;
            while (!last) {
                Object buffer = mm.allocate(8192);
                buffer.allowBufferDispose(true);
                long readBytes = bodyLocal.read(buffer.toByteBuffer());
                if (readBytes > 0L) {
                    buffer.position((int)readBytes);
                    buffer.trim();
                } else {
                    buffer.dispose();
                    if (readBytes < 0L) {
                        last = true;
                        buffer = Buffers.EMPTY_BUFFER;
                    } else {
                        if (generator instanceof FeedableBodyGenerator) {
                            ((FeedableBodyGenerator)generator).initializeAsynchronousTransfer(ctx, requestPacket);
                            return false;
                        }
                        throw new IllegalStateException("BodyGenerator unexpectedly returned 0 bytes available");
                    }
                }
                HttpContent content = ((HttpContent.Builder)((HttpContent.Builder)requestPacket.httpContentBuilder().content((Buffer)buffer)).last(last)).build();
                ctx.write((Object)content, !requestPacket.isCommitted() ? ctx.getTransportContext().getCompletionHandler() : null);
            }
            return true;
        }
    }

    private final class FileBodyHandler
    implements BodyHandler {
        private FileBodyHandler() {
        }

        public boolean handlesBodyType(Request request) {
            return request.getFile() != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean doHandle(FilterChainContext ctx, Request request, final HttpRequestPacket requestPacket) throws IOException {
            File f = request.getFile();
            requestPacket.setContentLengthLong(f.length());
            final HttpTransactionContext context = GrizzlyAsyncHttpProvider.this.getHttpTransactionContext(ctx.getConnection());
            if (!SEND_FILE_SUPPORT || requestPacket.isSecure()) {
                FileInputStream fis = new FileInputStream(request.getFile());
                MemoryManager mm = ctx.getMemoryManager();
                AtomicInteger written = new AtomicInteger();
                boolean last = false;
                try {
                    byte[] buf = new byte[8192];
                    while (!last) {
                        Buffer b = null;
                        int read = fis.read(buf);
                        if (read < 0) {
                            last = true;
                            b = Buffers.EMPTY_BUFFER;
                        }
                        if (b != Buffers.EMPTY_BUFFER) {
                            written.addAndGet(read);
                            b = Buffers.wrap(mm, buf, 0, read);
                        }
                        HttpContent content = ((HttpContent.Builder)((HttpContent.Builder)requestPacket.httpContentBuilder().content(b)).last(last)).build();
                        ctx.write((Object)content, !requestPacket.isCommitted() ? ctx.getTransportContext().getCompletionHandler() : null);
                    }
                }
                finally {
                    try {
                        fis.close();
                    }
                    catch (IOException ignored) {}
                }
            }
            ctx.write((Object)requestPacket, !requestPacket.isCommitted() ? ctx.getTransportContext().getCompletionHandler() : null);
            ctx.write((Object)new FileTransfer(f), (CompletionHandler<WriteResult>)new EmptyCompletionHandler<WriteResult>(){

                @Override
                public void updated(WriteResult result) {
                    AsyncHandler handler = context.handler;
                    if (handler != null && TransferCompletionHandler.class.isAssignableFrom(handler.getClass())) {
                        long written = result.getWrittenSize();
                        long total = context.totalBodyWritten.addAndGet(written);
                        ((TransferCompletionHandler)handler).onContentWriteProgress(written, total, requestPacket.getContentLength());
                    }
                }
            });
            return true;
        }
    }

    private static final class PartsBodyHandler
    implements BodyHandler {
        private PartsBodyHandler() {
        }

        public boolean handlesBodyType(Request request) {
            List<Part> parts = request.getParts();
            return parts != null && !parts.isEmpty();
        }

        public boolean doHandle(FilterChainContext ctx, Request request, HttpRequestPacket requestPacket) throws IOException {
            MultipartRequestEntity mre = AsyncHttpProviderUtils.createMultipartRequestEntity(request.getParts(), request.getParams());
            requestPacket.setContentLengthLong(mre.getContentLength());
            requestPacket.setContentType(mre.getContentType());
            MemoryManager mm = ctx.getMemoryManager();
            Object b = mm.allocate(512);
            BufferOutputStream o = new BufferOutputStream(mm, (Buffer)b, true);
            mre.writeRequest(o);
            b = o.getBuffer();
            b.trim();
            if (b.hasRemaining()) {
                HttpContent content = ((HttpContent.Builder)requestPacket.httpContentBuilder().content((Buffer)b)).build();
                content.setLast(true);
                ctx.write((Object)content, !requestPacket.isCommitted() ? ctx.getTransportContext().getCompletionHandler() : null);
            }
            return true;
        }
    }

    private static final class StreamDataBodyHandler
    implements BodyHandler {
        private StreamDataBodyHandler() {
        }

        public boolean handlesBodyType(Request request) {
            return request.getStreamData() != null;
        }

        public boolean doHandle(FilterChainContext ctx, Request request, HttpRequestPacket requestPacket) throws IOException {
            int read;
            InputStream in;
            byte[] b;
            Object buffer;
            MemoryManager mm;
            block6: {
                mm = ctx.getMemoryManager();
                buffer = mm.allocate(512);
                b = new byte[512];
                in = request.getStreamData();
                try {
                    in.reset();
                }
                catch (IOException ioe) {
                    if (!LOGGER.isDebugEnabled()) break block6;
                    LOGGER.debug(ioe.toString(), ioe);
                }
            }
            if (in.markSupported()) {
                in.mark(0);
            }
            while ((read = in.read(b)) != -1) {
                if (read > buffer.remaining()) {
                    buffer = mm.reallocate(buffer, buffer.capacity() + 512);
                }
                buffer.put(b, 0, read);
            }
            buffer.trim();
            if (buffer.hasRemaining()) {
                HttpContent content = ((HttpContent.Builder)requestPacket.httpContentBuilder().content((Buffer)buffer)).build();
                buffer.allowBufferDispose(false);
                content.setLast(true);
                ctx.write((Object)content, !requestPacket.isCommitted() ? ctx.getTransportContext().getCompletionHandler() : null);
            }
            return true;
        }
    }

    private static final class EntityWriterBodyHandler
    implements BodyHandler {
        private EntityWriterBodyHandler() {
        }

        public boolean handlesBodyType(Request request) {
            return request.getEntityWriter() != null;
        }

        public boolean doHandle(FilterChainContext ctx, Request request, HttpRequestPacket requestPacket) throws IOException {
            MemoryManager mm = ctx.getMemoryManager();
            Object b = mm.allocate(512);
            BufferOutputStream o = new BufferOutputStream(mm, (Buffer)b, true);
            Request.EntityWriter writer = request.getEntityWriter();
            writer.writeEntity(o);
            b = o.getBuffer();
            b.trim();
            if (b.hasRemaining()) {
                HttpContent content = ((HttpContent.Builder)requestPacket.httpContentBuilder().content((Buffer)b)).build();
                content.setLast(true);
                ctx.write((Object)content, !requestPacket.isCommitted() ? ctx.getTransportContext().getCompletionHandler() : null);
            }
            return true;
        }
    }

    private final class ParamsBodyHandler
    implements BodyHandler {
        private ParamsBodyHandler() {
        }

        public boolean handlesBodyType(Request request) {
            FluentStringsMap params = request.getParams();
            return params != null && !params.isEmpty();
        }

        public boolean doHandle(FilterChainContext ctx, Request request, HttpRequestPacket requestPacket) throws IOException {
            FluentStringsMap params;
            if (requestPacket.getContentType() == null) {
                requestPacket.setContentType("application/x-www-form-urlencoded");
            }
            StringBuilder sb = null;
            String charset = request.getBodyEncoding();
            if (charset == null) {
                charset = Charsets.DEFAULT_CHARACTER_ENCODING;
            }
            if (!(params = request.getParams()).isEmpty()) {
                for (Map.Entry<String, List<String>> entry : params.entrySet()) {
                    String name = entry.getKey();
                    List<String> values = entry.getValue();
                    if (values == null || values.isEmpty()) continue;
                    if (sb == null) {
                        sb = new StringBuilder(128);
                    }
                    for (String value : values) {
                        if (sb.length() > 0) {
                            sb.append('&');
                        }
                        sb.append(URLEncoder.encode(name, charset)).append('=').append(URLEncoder.encode(value, charset));
                    }
                }
            }
            if (sb != null) {
                byte[] data = sb.toString().getBytes(charset);
                MemoryManager mm = ctx.getMemoryManager();
                Buffer gBuffer = Buffers.wrap(mm, data);
                HttpContent content = ((HttpContent.Builder)requestPacket.httpContentBuilder().content(gBuffer)).build();
                if (requestPacket.getContentLength() == -1L && !GrizzlyAsyncHttpProvider.this.clientConfig.isCompressionEnabled()) {
                    requestPacket.setContentLengthLong(data.length);
                }
                content.setLast(true);
                ctx.write((Object)content, !requestPacket.isCommitted() ? ctx.getTransportContext().getCompletionHandler() : null);
            }
            return true;
        }
    }

    private static final class NoBodyHandler
    implements BodyHandler {
        private NoBodyHandler() {
        }

        public boolean handlesBodyType(Request request) {
            return false;
        }

        public boolean doHandle(FilterChainContext ctx, Request request, HttpRequestPacket requestPacket) throws IOException {
            HttpContent content = ((HttpContent.Builder)requestPacket.httpContentBuilder().content(Buffers.EMPTY_BUFFER)).build();
            content.setLast(true);
            ctx.write((Object)content, !requestPacket.isCommitted() ? ctx.getTransportContext().getCompletionHandler() : null);
            return true;
        }
    }

    private final class StringBodyHandler
    implements BodyHandler {
        private StringBodyHandler() {
        }

        public boolean handlesBodyType(Request request) {
            return request.getStringData() != null;
        }

        public boolean doHandle(FilterChainContext ctx, Request request, HttpRequestPacket requestPacket) throws IOException {
            String charset = request.getBodyEncoding();
            if (charset == null) {
                charset = Charsets.DEFAULT_CHARACTER_ENCODING;
            }
            byte[] data = request.getStringData().getBytes(charset);
            MemoryManager mm = ctx.getMemoryManager();
            Buffer gBuffer = Buffers.wrap(mm, data);
            if (requestPacket.getContentLength() == -1L && !GrizzlyAsyncHttpProvider.this.clientConfig.isCompressionEnabled()) {
                requestPacket.setContentLengthLong(data.length);
            }
            HttpContent content = ((HttpContent.Builder)requestPacket.httpContentBuilder().content(gBuffer)).build();
            content.setLast(true);
            ctx.write((Object)content, !requestPacket.isCommitted() ? ctx.getTransportContext().getCompletionHandler() : null);
            return true;
        }
    }

    private final class ByteArrayBodyHandler
    implements BodyHandler {
        private ByteArrayBodyHandler() {
        }

        public boolean handlesBodyType(Request request) {
            return request.getByteData() != null;
        }

        public boolean doHandle(FilterChainContext ctx, Request request, HttpRequestPacket requestPacket) throws IOException {
            String charset = request.getBodyEncoding();
            if (charset == null) {
                charset = Charsets.DEFAULT_CHARACTER_ENCODING;
            }
            byte[] data = new String(request.getByteData(), charset).getBytes(charset);
            MemoryManager mm = ctx.getMemoryManager();
            Buffer gBuffer = Buffers.wrap(mm, data);
            if (requestPacket.getContentLength() == -1L && !GrizzlyAsyncHttpProvider.this.clientConfig.isCompressionEnabled()) {
                requestPacket.setContentLengthLong(data.length);
            }
            HttpContent content = ((HttpContent.Builder)requestPacket.httpContentBuilder().content(gBuffer)).build();
            content.setLast(true);
            ctx.write((Object)content, !requestPacket.isCommitted() ? ctx.getTransportContext().getCompletionHandler() : null);
            return true;
        }
    }

    private static final class ExpectHandler
    implements BodyHandler {
        private final BodyHandler delegate;
        private Request request;
        private HttpRequestPacket requestPacket;

        private ExpectHandler(BodyHandler delegate) {
            this.delegate = delegate;
        }

        public boolean handlesBodyType(Request request) {
            return this.delegate.handlesBodyType(request);
        }

        public boolean doHandle(FilterChainContext ctx, Request request, HttpRequestPacket requestPacket) throws IOException {
            this.request = request;
            this.requestPacket = requestPacket;
            ctx.write((Object)requestPacket, !requestPacket.isCommitted() ? ctx.getTransportContext().getCompletionHandler() : null);
            return true;
        }

        public void finish(FilterChainContext ctx) throws IOException {
            this.delegate.doHandle(ctx, this.request, this.requestPacket);
        }
    }

    private final class BodyHandlerFactory {
        private final BodyHandler[] HANDLERS;

        private BodyHandlerFactory() {
            this.HANDLERS = new BodyHandler[]{new StringBodyHandler(), new ByteArrayBodyHandler(), new ParamsBodyHandler(), new EntityWriterBodyHandler(), new StreamDataBodyHandler(), new PartsBodyHandler(), new FileBodyHandler(), new BodyGeneratorBodyHandler()};
        }

        public BodyHandler getBodyHandler(Request request) {
            for (BodyHandler h : this.HANDLERS) {
                if (!h.handlesBodyType(request)) continue;
                return h;
            }
            return new NoBodyHandler();
        }
    }

    private static interface BodyHandler {
        public static final int MAX_CHUNK_SIZE = 8192;

        public boolean handlesBodyType(Request var1);

        public boolean doHandle(FilterChainContext var1, Request var2, HttpRequestPacket var3) throws IOException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NonCachingPool
    implements ConnectionsPool<String, Connection> {
        private NonCachingPool() {
        }

        @Override
        public boolean offer(String uri, Connection connection) {
            return false;
        }

        @Override
        public Connection poll(String uri) {
            return null;
        }

        @Override
        public boolean removeAll(Connection connection) {
            return false;
        }

        @Override
        public boolean canCacheConnection() {
            return true;
        }

        @Override
        public void destroy() {
        }
    }

    private static final class ClientEncodingFilter
    implements EncodingFilter {
        private ClientEncodingFilter() {
        }

        public boolean applyEncoding(HttpHeader httpPacket) {
            httpPacket.addHeader(Header.AcceptEncoding, "gzip");
            return true;
        }

        public boolean applyDecoding(HttpHeader httpPacket) {
            HttpResponsePacket httpResponse = (HttpResponsePacket)httpPacket;
            DataChunk bc = httpResponse.getHeaders().getValue(Header.ContentEncoding);
            return bc != null && bc.indexOf("gzip", 0) != -1;
        }
    }

    private static final class AsyncHttpClientEventFilter
    extends HttpClientFilter {
        private final Map<Integer, StatusHandler> HANDLER_MAP = new HashMap<Integer, StatusHandler>();
        private final GrizzlyAsyncHttpProvider provider;

        AsyncHttpClientEventFilter(GrizzlyAsyncHttpProvider provider) {
            this.provider = provider;
            this.HANDLER_MAP.put(HttpStatus.UNAUTHORIZED_401.getStatusCode(), AuthorizationHandler.INSTANCE);
            this.HANDLER_MAP.put(HttpStatus.MOVED_PERMANENTLY_301.getStatusCode(), RedirectHandler.INSTANCE);
            this.HANDLER_MAP.put(HttpStatus.FOUND_302.getStatusCode(), RedirectHandler.INSTANCE);
            this.HANDLER_MAP.put(HttpStatus.TEMPORARY_REDIRECT_307.getStatusCode(), RedirectHandler.INSTANCE);
        }

        public void exceptionOccurred(FilterChainContext ctx, Throwable error) {
            this.provider.getHttpTransactionContext(ctx.getConnection()).abort(error);
        }

        protected void onHttpContentParsed(HttpContent content, FilterChainContext ctx) {
            HttpTransactionContext context = this.provider.getHttpTransactionContext(ctx.getConnection());
            AsyncHandler handler = context.handler;
            if (handler != null && context.currentState != AsyncHandler.STATE.ABORT) {
                try {
                    context.currentState = handler.onBodyPartReceived(new GrizzlyResponseBodyPart(content, null, ctx.getConnection(), this.provider));
                }
                catch (Exception e) {
                    handler.onThrowable(e);
                }
            }
        }

        protected void onHttpHeadersEncoded(HttpHeader httpHeader, FilterChainContext ctx) {
            HttpTransactionContext context = this.provider.getHttpTransactionContext(ctx.getConnection());
            AsyncHandler handler = context.handler;
            if (handler != null && TransferCompletionHandler.class.isAssignableFrom(handler.getClass())) {
                ((TransferCompletionHandler)handler).onHeaderWriteCompleted();
            }
        }

        protected void onHttpContentEncoded(HttpContent content, FilterChainContext ctx) {
            HttpTransactionContext context = this.provider.getHttpTransactionContext(ctx.getConnection());
            AsyncHandler handler = context.handler;
            if (handler != null && TransferCompletionHandler.class.isAssignableFrom(handler.getClass())) {
                int written = content.getContent().remaining();
                long total = context.totalBodyWritten.addAndGet(written);
                ((TransferCompletionHandler)handler).onContentWriteProgress(written, total, content.getHttpHeader().getContentLength());
            }
        }

        protected void onInitialLineParsed(HttpHeader httpHeader, FilterChainContext ctx) {
            GrizzlyResponseStatus responseStatus;
            super.onInitialLineParsed(httpHeader, ctx);
            if (httpHeader.isSkipRemainder()) {
                return;
            }
            HttpTransactionContext context = this.provider.getHttpTransactionContext(ctx.getConnection());
            int status = ((HttpResponsePacket)httpHeader).getStatus();
            if (HttpStatus.CONINTUE_100.statusMatches(status)) {
                ctx.notifyUpstream(new ContinueEvent(context));
                return;
            }
            if (context.statusHandler != null && !context.statusHandler.handlesStatus(status)) {
                context.statusHandler = null;
                context.invocationStatus = StatusHandler.InvocationStatus.CONTINUE;
            } else {
                context.statusHandler = null;
            }
            if (context.invocationStatus == StatusHandler.InvocationStatus.CONTINUE) {
                if (this.HANDLER_MAP.containsKey(status)) {
                    context.statusHandler = this.HANDLER_MAP.get(status);
                }
                if (context.statusHandler instanceof RedirectHandler && !AsyncHttpClientEventFilter.isRedirectAllowed(context)) {
                    context.statusHandler = null;
                }
            }
            if (AsyncHttpClientEventFilter.isRedirectAllowed(context)) {
                if (AsyncHttpClientEventFilter.isRedirect(status)) {
                    if (context.statusHandler == null) {
                        context.statusHandler = RedirectHandler.INSTANCE;
                    }
                    context.redirectCount.incrementAndGet();
                    if (AsyncHttpClientEventFilter.redirectCountExceeded(context)) {
                        httpHeader.setSkipRemainder(true);
                        context.abort(new MaxRedirectException());
                    }
                } else if (context.redirectCount.get() > 0) {
                    context.redirectCount.set(0);
                }
            }
            context.responseStatus = responseStatus = new GrizzlyResponseStatus((HttpResponsePacket)httpHeader, AsyncHttpClientEventFilter.getURI(context.requestUrl), this.provider);
            if (context.statusHandler != null) {
                return;
            }
            if (context.currentState != AsyncHandler.STATE.ABORT) {
                try {
                    AsyncHandler handler = context.handler;
                    if (handler != null) {
                        context.currentState = handler.onStatusReceived(responseStatus);
                    }
                }
                catch (Exception e) {
                    httpHeader.setSkipRemainder(true);
                    context.abort(e);
                }
            }
        }

        protected void onHttpHeaderError(HttpHeader httpHeader, FilterChainContext ctx, Throwable t) throws IOException {
            t.printStackTrace();
            httpHeader.setSkipRemainder(true);
            HttpTransactionContext context = this.provider.getHttpTransactionContext(ctx.getConnection());
            context.abort(t);
        }

        protected void onHttpHeadersParsed(HttpHeader httpHeader, FilterChainContext ctx) {
            block21: {
                boolean result;
                super.onHttpHeadersParsed(httpHeader, ctx);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("RESPONSE: " + httpHeader.toString());
                }
                if (httpHeader.containsHeader(Header.Connection) && "close".equals(httpHeader.getHeader(Header.Connection))) {
                    ConnectionManager.markConnectionAsDoNotCache(ctx.getConnection());
                }
                if (httpHeader.isSkipRemainder()) {
                    return;
                }
                HttpTransactionContext context = this.provider.getHttpTransactionContext(ctx.getConnection());
                AsyncHandler handler = context.handler;
                List<ResponseFilter> filters = context.provider.clientConfig.getResponseFilters();
                GrizzlyResponseHeaders responseHeaders = new GrizzlyResponseHeaders((HttpResponsePacket)httpHeader, null, this.provider);
                if (!filters.isEmpty()) {
                    FilterContext fc = new FilterContext.FilterContextBuilder().asyncHandler(handler).request(context.request).responseHeaders(responseHeaders).responseStatus(context.responseStatus).build();
                    try {
                        for (ResponseFilter f : filters) {
                            fc = f.filter(fc);
                        }
                    }
                    catch (Exception e) {
                        context.abort(e);
                    }
                    if (fc.replayRequest()) {
                        httpHeader.setSkipRemainder(true);
                        Request newRequest = fc.getRequest();
                        AsyncHandler newHandler = fc.getAsyncHandler();
                        try {
                            ConnectionManager m = context.provider.connectionManager;
                            Connection c = m.obtainConnection(newRequest, context.future);
                            HttpTransactionContext newContext = context.copy();
                            context.future = null;
                            this.provider.setHttpTransactionContext(c, newContext);
                            try {
                                context.provider.execute(c, newRequest, newHandler, context.future);
                            }
                            catch (IOException ioe) {
                                newContext.abort(ioe);
                            }
                        }
                        catch (Exception e) {
                            context.abort(e);
                        }
                        return;
                    }
                }
                if (context.statusHandler != null && context.invocationStatus == StatusHandler.InvocationStatus.CONTINUE && !(result = context.statusHandler.handleStatus((HttpResponsePacket)httpHeader, context, ctx))) {
                    httpHeader.setSkipRemainder(true);
                    return;
                }
                if (context.isWSRequest) {
                    try {
                        context.protocolHandler.setConnection(ctx.getConnection());
                        DefaultWebSocket ws = new DefaultWebSocket(context.protocolHandler, new WebSocketListener[0]);
                        context.webSocket = new GrizzlyWebSocketAdapter(ws);
                        if (context.currentState == AsyncHandler.STATE.UPGRADE) {
                            httpHeader.setChunked(false);
                            ws.onConnect();
                            WebSocketEngine.getEngine().setWebSocketHolder(ctx.getConnection(), context.protocolHandler, ws);
                            ((WebSocketUpgradeHandler)context.handler).onSuccess(context.webSocket);
                            int wsTimeout = context.provider.clientConfig.getWebSocketIdleTimeoutInMs();
                            IdleTimeoutFilter.setCustomTimeout(ctx.getConnection(), wsTimeout <= 0 ? IdleTimeoutFilter.FOREVER : (long)wsTimeout, TimeUnit.MILLISECONDS);
                            context.result(handler.onCompleted());
                            break block21;
                        }
                        httpHeader.setSkipRemainder(true);
                        ((WebSocketUpgradeHandler)context.handler).onClose(context.webSocket, 1002, "WebSocket protocol error: unexpected HTTP response status during handshake.");
                        context.result(null);
                    }
                    catch (Exception e) {
                        httpHeader.setSkipRemainder(true);
                        context.abort(e);
                    }
                } else if (context.currentState != AsyncHandler.STATE.ABORT) {
                    try {
                        context.currentState = handler.onHeadersReceived(responseHeaders);
                    }
                    catch (Exception e) {
                        httpHeader.setSkipRemainder(true);
                        context.abort(e);
                    }
                }
            }
        }

        protected boolean onHttpPacketParsed(HttpHeader httpHeader, FilterChainContext ctx) {
            if (httpHeader.isSkipRemainder()) {
                this.clearResponse(ctx.getConnection());
                AsyncHttpClientEventFilter.cleanup(ctx, this.provider);
                return false;
            }
            boolean result = super.onHttpPacketParsed(httpHeader, ctx);
            HttpTransactionContext context = AsyncHttpClientEventFilter.cleanup(ctx, this.provider);
            AsyncHandler handler = context.handler;
            if (handler != null) {
                try {
                    context.result(handler.onCompleted());
                }
                catch (Exception e) {
                    context.abort(e);
                }
            } else {
                context.done(null);
            }
            return result;
        }

        private static boolean isRedirectAllowed(HttpTransactionContext ctx) {
            boolean allowed = ctx.request.isRedirectEnabled();
            if (ctx.request.isRedirectOverrideSet()) {
                return allowed;
            }
            if (!allowed) {
                allowed = ctx.redirectsAllowed;
            }
            return allowed;
        }

        private static HttpTransactionContext cleanup(FilterChainContext ctx, GrizzlyAsyncHttpProvider provider) {
            Connection c = ctx.getConnection();
            HttpTransactionContext context = provider.getHttpTransactionContext(c);
            context.provider.setHttpTransactionContext(c, null);
            if (!context.provider.connectionManager.canReturnConnection(c)) {
                context.abort(new IOException("Maximum pooled connections exceeded"));
            } else if (!context.provider.connectionManager.returnConnection(context.requestUrl, c)) {
                ctx.getConnection().close().markForRecycle(true);
            }
            return context;
        }

        private static URI getURI(String url) {
            return AsyncHttpProviderUtils.createUri(url);
        }

        private static boolean redirectCountExceeded(HttpTransactionContext context) {
            return context.redirectCount.get() > context.maxRedirectCount;
        }

        private static boolean isRedirect(int status) {
            return HttpStatus.MOVED_PERMANENTLY_301.statusMatches(status) || HttpStatus.FOUND_302.statusMatches(status) || HttpStatus.SEE_OTHER_303.statusMatches(status) || HttpStatus.TEMPORARY_REDIRECT_307.statusMatches(status);
        }

        private static Request newRequest(URI uri, HttpResponsePacket response, HttpTransactionContext ctx, boolean asGet) {
            RequestBuilder builder = new RequestBuilder(ctx.request);
            if (asGet) {
                builder.setMethod("GET");
            }
            builder.setUrl(uri.toString());
            if (ctx.provider.clientConfig.isRemoveQueryParamOnRedirect()) {
                builder.setQueryParameters(null);
            }
            for (String cookieStr : response.getHeaders().values(Header.Cookie)) {
                Cookie c = AsyncHttpProviderUtils.parseCookie(cookieStr);
                builder.addOrReplaceCookie(c);
            }
            return builder.build();
        }

        private static final class RedirectHandler
        implements StatusHandler {
            private static final RedirectHandler INSTANCE = new RedirectHandler();

            private RedirectHandler() {
            }

            public boolean handlesStatus(int statusCode) {
                return AsyncHttpClientEventFilter.isRedirect(statusCode);
            }

            public boolean handleStatus(HttpResponsePacket responsePacket, HttpTransactionContext httpTransactionContext, FilterChainContext ctx) {
                String redirectURL = responsePacket.getHeader(Header.Location);
                if (redirectURL == null) {
                    throw new IllegalStateException("redirect received, but no location header was present");
                }
                URI orig = httpTransactionContext.lastRedirectURI == null ? AsyncHttpProviderUtils.createUri(httpTransactionContext.requestUrl) : AsyncHttpProviderUtils.getRedirectUri(AsyncHttpProviderUtils.createUri(httpTransactionContext.requestUrl), httpTransactionContext.lastRedirectURI);
                httpTransactionContext.lastRedirectURI = redirectURL;
                URI uri = AsyncHttpProviderUtils.getRedirectUri(orig, redirectURL);
                if (uri.toString().equalsIgnoreCase(orig.toString())) {
                    httpTransactionContext.statusHandler = null;
                    httpTransactionContext.invocationStatus = StatusHandler.InvocationStatus.CONTINUE;
                    try {
                        httpTransactionContext.handler.onStatusReceived(httpTransactionContext.responseStatus);
                    }
                    catch (Exception e) {
                        httpTransactionContext.abort(e);
                    }
                    return true;
                }
                Request requestToSend = AsyncHttpClientEventFilter.newRequest(uri, responsePacket, httpTransactionContext, this.sendAsGet(responsePacket, httpTransactionContext));
                ConnectionManager m = httpTransactionContext.provider.connectionManager;
                try {
                    Connection c = m.obtainConnection(requestToSend, httpTransactionContext.future);
                    if (this.switchingSchemes(orig, uri)) {
                        try {
                            this.notifySchemeSwitch(ctx, c, uri);
                        }
                        catch (IOException ioe) {
                            httpTransactionContext.abort(ioe);
                        }
                    }
                    HttpTransactionContext newContext = httpTransactionContext.copy();
                    httpTransactionContext.future = null;
                    newContext.invocationStatus = StatusHandler.InvocationStatus.CONTINUE;
                    newContext.request = requestToSend;
                    newContext.requestUrl = requestToSend.getUrl();
                    httpTransactionContext.provider.setHttpTransactionContext(c, newContext);
                    httpTransactionContext.provider.execute(c, requestToSend, newContext.handler, newContext.future);
                    return false;
                }
                catch (Exception e) {
                    httpTransactionContext.abort(e);
                    httpTransactionContext.invocationStatus = StatusHandler.InvocationStatus.CONTINUE;
                    return true;
                }
            }

            private boolean sendAsGet(HttpResponsePacket response, HttpTransactionContext ctx) {
                int statusCode = response.getStatus();
                return statusCode >= 302 && statusCode <= 303 && (statusCode != 302 || !ctx.provider.clientConfig.isStrict302Handling());
            }

            private boolean switchingSchemes(URI oldUri, URI newUri) {
                return !oldUri.getScheme().equals(newUri.getScheme());
            }

            private void notifySchemeSwitch(FilterChainContext ctx, Connection c, URI uri) throws IOException {
                ctx.notifyDownstream(new SwitchingSSLFilter.SSLSwitchingEvent("https".equals(uri.getScheme()), c));
            }
        }

        private static final class AuthorizationHandler
        implements StatusHandler {
            private static final AuthorizationHandler INSTANCE = new AuthorizationHandler();

            private AuthorizationHandler() {
            }

            public boolean handlesStatus(int statusCode) {
                return HttpStatus.UNAUTHORIZED_401.statusMatches(statusCode);
            }

            public boolean handleStatus(HttpResponsePacket responsePacket, HttpTransactionContext httpTransactionContext, FilterChainContext ctx) {
                String auth = responsePacket.getHeader(Header.WWWAuthenticate);
                if (auth == null) {
                    throw new IllegalStateException("401 response received, but no WWW-Authenticate header was present");
                }
                Realm realm = httpTransactionContext.request.getRealm();
                if (realm == null) {
                    realm = httpTransactionContext.provider.clientConfig.getRealm();
                }
                if (realm == null) {
                    httpTransactionContext.invocationStatus = StatusHandler.InvocationStatus.STOP;
                    return true;
                }
                responsePacket.setSkipRemainder(true);
                Request req = httpTransactionContext.request;
                realm = new Realm.RealmBuilder().clone(realm).setScheme(realm.getAuthScheme()).setUri(URI.create(httpTransactionContext.requestUrl).getPath()).setMethodName(req.getMethod()).setUsePreemptiveAuth(true).parseWWWAuthenticateHeader(auth).build();
                if (auth.toLowerCase().startsWith("basic")) {
                    req.getHeaders().remove(Header.Authorization.toString());
                    try {
                        req.getHeaders().add(Header.Authorization.toString(), AuthenticatorUtils.computeBasicAuthentication(realm));
                    }
                    catch (UnsupportedEncodingException ignored) {}
                } else if (auth.toLowerCase().startsWith("digest")) {
                    req.getHeaders().remove(Header.Authorization.toString());
                    try {
                        req.getHeaders().add(Header.Authorization.toString(), AuthenticatorUtils.computeDigestAuthentication(realm));
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new IllegalStateException("Digest authentication not supported", e);
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new IllegalStateException("Unsupported encoding.", e);
                    }
                } else {
                    throw new IllegalStateException("Unsupported authorization method: " + auth);
                }
                ConnectionManager m = httpTransactionContext.provider.connectionManager;
                try {
                    Connection c = m.obtainConnection(req, httpTransactionContext.future);
                    HttpTransactionContext newContext = httpTransactionContext.copy();
                    httpTransactionContext.future = null;
                    httpTransactionContext.provider.setHttpTransactionContext(c, newContext);
                    newContext.invocationStatus = StatusHandler.InvocationStatus.STOP;
                    try {
                        httpTransactionContext.provider.execute(c, req, httpTransactionContext.handler, httpTransactionContext.future);
                        return false;
                    }
                    catch (IOException ioe) {
                        newContext.abort(ioe);
                        return false;
                    }
                }
                catch (Exception e) {
                    httpTransactionContext.abort(e);
                    httpTransactionContext.invocationStatus = StatusHandler.InvocationStatus.STOP;
                    return false;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class AsyncHttpClientFilter
    extends BaseFilter {
        private final AsyncHttpClientConfig config;

        AsyncHttpClientFilter(AsyncHttpClientConfig config) {
            this.config = config;
        }

        @Override
        public NextAction handleWrite(FilterChainContext ctx) throws IOException {
            Object message = ctx.getMessage();
            if (message instanceof Request) {
                ctx.setMessage(null);
                if (!this.sendAsGrizzlyRequest((Request)message, ctx)) {
                    return ctx.getSuspendAction();
                }
            } else if (message instanceof Buffer) {
                return ctx.getInvokeAction();
            }
            return ctx.getStopAction();
        }

        @Override
        public NextAction handleEvent(FilterChainContext ctx, FilterChainEvent event) throws IOException {
            Object type = event.type();
            if (type == ContinueEvent.class) {
                ContinueEvent continueEvent = (ContinueEvent)event;
                ((ExpectHandler)((ContinueEvent)continueEvent).context.bodyHandler).finish(ctx);
            }
            return ctx.getStopAction();
        }

        private boolean sendAsGrizzlyRequest(Request request, FilterChainContext ctx) throws IOException {
            AsyncHandler h;
            boolean avoidProxy;
            HttpRequestPacket requestPacket;
            boolean useProxy;
            HttpTransactionContext httpCtx = GrizzlyAsyncHttpProvider.this.getHttpTransactionContext(ctx.getConnection());
            if (this.isUpgradeRequest(httpCtx.handler) && this.isWSRequest(httpCtx.requestUrl)) {
                httpCtx.isWSRequest = true;
                this.convertToUpgradeRequest(httpCtx);
            }
            URI uri = AsyncHttpProviderUtils.createUri(httpCtx.requestUrl);
            HttpRequestPacket.Builder builder = HttpRequestPacket.builder();
            boolean secure = "https".equals(uri.getScheme());
            builder.method(request.getMethod());
            builder.protocol(Protocol.HTTP_1_1);
            String host = request.getVirtualHost();
            if (host != null) {
                builder.header(Header.Host, host);
            } else if (uri.getPort() == -1) {
                builder.header(Header.Host, uri.getHost());
            } else {
                builder.header(Header.Host, uri.getHost() + ':' + uri.getPort());
            }
            ProxyServer proxy = this.getProxyServer(request);
            boolean bl = useProxy = proxy != null;
            if (useProxy) {
                if (secure) {
                    builder.method(Method.CONNECT);
                    builder.uri(AsyncHttpProviderUtils.getAuthority(uri));
                } else {
                    builder.uri(uri.toString());
                }
            } else {
                builder.uri(uri.getPath());
            }
            if (GrizzlyAsyncHttpProvider.requestHasEntityBody(request)) {
                long contentLength = request.getContentLength();
                if (contentLength > 0L) {
                    builder.contentLength(contentLength);
                    builder.chunked(false);
                } else {
                    builder.chunked(true);
                }
            }
            if (httpCtx.isWSRequest) {
                try {
                    URI wsURI = new URI(httpCtx.wsRequestURI);
                    httpCtx.protocolHandler = Version.DRAFT17.createHandler(true);
                    httpCtx.handshake = httpCtx.protocolHandler.createHandShake(wsURI);
                    requestPacket = (HttpRequestPacket)httpCtx.handshake.composeHeaders().getHttpHeader();
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException("Invalid WS URI: " + httpCtx.wsRequestURI);
                }
            } else {
                requestPacket = builder.build();
            }
            requestPacket.setSecure(true);
            if (!useProxy && !httpCtx.isWSRequest) {
                this.addQueryString(request, requestPacket);
            }
            this.addHeaders(request, requestPacket);
            this.addCookies(request, requestPacket);
            if (useProxy && !(avoidProxy = ProxyUtils.avoidProxy(proxy, request))) {
                if (!requestPacket.getHeaders().contains(Header.ProxyConnection)) {
                    requestPacket.setHeader(Header.ProxyConnection, "keep-alive");
                }
                if (proxy.getPrincipal() != null) {
                    requestPacket.setHeader(Header.ProxyAuthorization, AuthenticatorUtils.computeBasicAuthentication(proxy));
                }
            }
            if ((h = httpCtx.handler) != null && TransferCompletionHandler.class.isAssignableFrom(h.getClass())) {
                FluentCaseInsensitiveStringsMap map = new FluentCaseInsensitiveStringsMap(request.getHeaders());
                ((TransferCompletionHandler)TransferCompletionHandler.class.cast(h)).transferAdapter(new GrizzlyTransferAdapter(map));
            }
            return GrizzlyAsyncHttpProvider.this.sendRequest(ctx, request, requestPacket);
        }

        private boolean isUpgradeRequest(AsyncHandler handler) {
            return handler instanceof UpgradeHandler;
        }

        private boolean isWSRequest(String requestUri) {
            return requestUri.charAt(0) == 'w' && requestUri.charAt(1) == 's';
        }

        private void convertToUpgradeRequest(HttpTransactionContext ctx) {
            int colonIdx = ctx.requestUrl.indexOf(58);
            if (colonIdx < 2 || colonIdx > 3) {
                throw new IllegalArgumentException("Invalid websocket URL: " + ctx.requestUrl);
            }
            StringBuilder sb = new StringBuilder(ctx.requestUrl);
            sb.replace(0, colonIdx, colonIdx == 2 ? "http" : "https");
            ctx.wsRequestURI = ctx.requestUrl;
            ctx.requestUrl = sb.toString();
        }

        private ProxyServer getProxyServer(Request request) {
            ProxyServer proxyServer = request.getProxyServer();
            if (proxyServer == null) {
                proxyServer = this.config.getProxyServer();
            }
            return proxyServer;
        }

        private void addHeaders(Request request, HttpRequestPacket requestPacket) {
            MimeHeaders headers;
            FluentCaseInsensitiveStringsMap map = request.getHeaders();
            if (map != null && !map.isEmpty()) {
                for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                    String headerName = entry.getKey();
                    List<String> headerValues = entry.getValue();
                    if (headerValues == null || headerValues.isEmpty()) continue;
                    for (String headerValue : headerValues) {
                        requestPacket.addHeader(headerName, headerValue);
                    }
                }
            }
            if (!(headers = requestPacket.getHeaders()).contains(Header.Connection)) {
                requestPacket.addHeader(Header.Connection, "keep-alive");
            }
            if (!headers.contains(Header.Accept)) {
                requestPacket.addHeader(Header.Accept, "*/*");
            }
            if (!headers.contains(Header.UserAgent)) {
                requestPacket.addHeader(Header.UserAgent, this.config.getUserAgent());
            }
        }

        private void addCookies(Request request, HttpRequestPacket requestPacket) {
            Collection<Cookie> cookies = request.getCookies();
            if (cookies != null && !cookies.isEmpty()) {
                StringBuilder sb = new StringBuilder(128);
                org.glassfish.grizzly.http.Cookie[] gCookies = new org.glassfish.grizzly.http.Cookie[cookies.size()];
                this.convertCookies(cookies, gCookies);
                CookieSerializerUtils.serializeClientCookies(sb, gCookies);
                requestPacket.addHeader(Header.Cookie, sb.toString());
            }
        }

        private void convertCookies(Collection<Cookie> cookies, org.glassfish.grizzly.http.Cookie[] gCookies) {
            int idx = 0;
            for (Cookie cookie : cookies) {
                org.glassfish.grizzly.http.Cookie gCookie = new org.glassfish.grizzly.http.Cookie(cookie.getName(), cookie.getValue());
                gCookie.setDomain(cookie.getDomain());
                gCookie.setPath(cookie.getPath());
                gCookie.setVersion(cookie.getVersion());
                gCookie.setMaxAge(cookie.getMaxAge());
                gCookie.setSecure(cookie.isSecure());
                gCookies[idx] = gCookie;
                ++idx;
            }
        }

        private void addQueryString(Request request, HttpRequestPacket requestPacket) {
            FluentStringsMap map = request.getQueryParams();
            if (map != null && !map.isEmpty()) {
                StringBuilder sb = new StringBuilder(128);
                for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                    String name = entry.getKey();
                    List<String> values = entry.getValue();
                    if (values == null || values.isEmpty()) continue;
                    try {
                        int len = values.size();
                        for (int i = 0; i < len; ++i) {
                            String value = values.get(i);
                            if (value != null && value.length() > 0) {
                                sb.append(URLEncoder.encode(name, "UTF-8")).append('=').append(URLEncoder.encode(values.get(i), "UTF-8")).append('&');
                                continue;
                            }
                            sb.append(URLEncoder.encode(name, "UTF-8")).append('&');
                        }
                    }
                    catch (UnsupportedEncodingException ignored) {
                    }
                }
                String queryString = sb.deleteCharAt(sb.length() - 1).toString();
                requestPacket.setQueryString(queryString);
            }
        }
    }

    private final class AsyncHttpClientTransportFilter
    extends TransportFilter {
        private AsyncHttpClientTransportFilter() {
        }

        public NextAction handleRead(FilterChainContext ctx) throws IOException {
            final HttpTransactionContext context = GrizzlyAsyncHttpProvider.this.getHttpTransactionContext(ctx.getConnection());
            if (context == null) {
                return super.handleRead(ctx);
            }
            ctx.getTransportContext().setCompletionHandler(new CompletionHandler(){

                public void cancelled() {
                }

                public void failed(Throwable throwable) {
                    if (throwable instanceof EOFException) {
                        context.abort(new IOException("Remotely Closed"));
                    }
                    context.abort(throwable);
                }

                public void completed(Object result) {
                }

                public void updated(Object result) {
                }
            });
            return super.handleRead(ctx);
        }
    }

    private static final class ContinueEvent
    implements FilterChainEvent {
        private final HttpTransactionContext context;

        ContinueEvent(HttpTransactionContext context) {
            this.context = context;
        }

        public Object type() {
            return ContinueEvent.class;
        }
    }

    final class HttpTransactionContext {
        final AtomicInteger redirectCount = new AtomicInteger(0);
        final int maxRedirectCount;
        final boolean redirectsAllowed;
        final GrizzlyAsyncHttpProvider provider = GrizzlyAsyncHttpProvider.this;
        Request request;
        String requestUrl;
        AsyncHandler handler;
        BodyHandler bodyHandler;
        StatusHandler statusHandler;
        StatusHandler.InvocationStatus invocationStatus = StatusHandler.InvocationStatus.CONTINUE;
        GrizzlyResponseStatus responseStatus;
        GrizzlyResponseFuture future;
        String lastRedirectURI;
        AtomicLong totalBodyWritten = new AtomicLong();
        AsyncHandler.STATE currentState;
        String wsRequestURI;
        boolean isWSRequest;
        HandShake handshake;
        ProtocolHandler protocolHandler;
        WebSocket webSocket;

        HttpTransactionContext(GrizzlyResponseFuture future, Request request, AsyncHandler handler) {
            this.future = future;
            this.request = request;
            this.handler = handler;
            this.redirectsAllowed = this.provider.clientConfig.isRedirectEnabled();
            this.maxRedirectCount = this.provider.clientConfig.getMaxRedirects();
            this.requestUrl = request.getUrl();
        }

        HttpTransactionContext copy() {
            HttpTransactionContext newContext = new HttpTransactionContext(this.future, this.request, this.handler);
            newContext.invocationStatus = this.invocationStatus;
            newContext.bodyHandler = this.bodyHandler;
            newContext.currentState = this.currentState;
            newContext.statusHandler = this.statusHandler;
            newContext.lastRedirectURI = this.lastRedirectURI;
            newContext.redirectCount.set(this.redirectCount.get());
            return newContext;
        }

        void abort(Throwable t) {
            if (this.future != null) {
                this.future.abort(t);
            }
        }

        void done(Callable c) {
            if (this.future != null) {
                this.future.done(c);
            }
        }

        void result(Object result) {
            if (this.future != null) {
                this.future.delegate.result(result);
                this.future.done(null);
            }
        }
    }

    private static interface StatusHandler {
        public boolean handleStatus(HttpResponsePacket var1, HttpTransactionContext var2, FilterChainContext var3);

        public boolean handlesStatus(int var1);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum InvocationStatus {
            CONTINUE,
            STOP;

        }
    }
}

