/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.util;

import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http.util.BufferChunk;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.HttpUtils;
import org.glassfish.grizzly.memory.MemoryManager;

public class HttpCodecUtils {
    public static Buffer getLongAsBuffer(MemoryManager memoryManager, long length) {
        Object b = memoryManager.allocate(20);
        b.allowBufferDispose(true);
        HttpUtils.longToBuffer(length, b);
        return b;
    }

    public static Buffer put(MemoryManager memoryManager, Buffer dstBuffer, DataChunk chunk) {
        if (chunk.isNull()) {
            return dstBuffer;
        }
        if (chunk.getType() == DataChunk.Type.Buffer) {
            BufferChunk bc = chunk.getBufferChunk();
            int length = bc.getLength();
            if (dstBuffer.remaining() < length) {
                dstBuffer = HttpCodecUtils.resizeBuffer(memoryManager, dstBuffer, length);
            }
            dstBuffer.put(bc.getBuffer(), bc.getStart(), length);
            return dstBuffer;
        }
        return HttpCodecUtils.put(memoryManager, dstBuffer, chunk.toString());
    }

    public static Buffer put(MemoryManager memoryManager, Buffer dstBuffer, String s) {
        int size = s.length();
        if (dstBuffer.remaining() < size) {
            dstBuffer = HttpCodecUtils.resizeBuffer(memoryManager, dstBuffer, size);
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            int c = s.charAt(i);
            if (c <= 31 && c != 9 || c == 127 || c > 255) {
                c = 32;
            }
            byte b = (byte)c;
            dstBuffer.put(b);
        }
        return dstBuffer;
    }

    public static Buffer put(MemoryManager memoryManager, Buffer dstBuffer, byte[] array) {
        if (dstBuffer.remaining() < array.length) {
            dstBuffer = HttpCodecUtils.resizeBuffer(memoryManager, dstBuffer, array.length);
        }
        dstBuffer.put(array);
        return dstBuffer;
    }

    public static Buffer put(MemoryManager memoryManager, Buffer dstBuffer, Buffer buffer) {
        int addSize = buffer.remaining();
        if (dstBuffer.remaining() < addSize) {
            dstBuffer = HttpCodecUtils.resizeBuffer(memoryManager, dstBuffer, addSize);
        }
        dstBuffer.put(buffer);
        return dstBuffer;
    }

    public static Buffer put(MemoryManager memoryManager, Buffer dstBuffer, byte value) {
        if (!dstBuffer.hasRemaining()) {
            dstBuffer = HttpCodecUtils.resizeBuffer(memoryManager, dstBuffer, 1);
        }
        dstBuffer.put(value);
        return dstBuffer;
    }

    public static Buffer resizeBuffer(MemoryManager memoryManager, Buffer buffer, int grow) {
        return memoryManager.reallocate(buffer, Math.max(buffer.capacity() + grow, buffer.capacity() * 3 / 2 + 1));
    }
}

