/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.util;

import java.io.CharConversionException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.http.util.BufferChunk;
import org.glassfish.grizzly.http.util.CharChunk;
import org.glassfish.grizzly.http.util.Constants;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.MimeHeaders;
import org.glassfish.grizzly.http.util.URLDecoder;
import org.glassfish.grizzly.localization.LogMessages;

public final class Parameters {
    private static final Logger logger = Grizzly.logger(Parameters.class);
    private final LinkedHashMap<String, ArrayList<String>> paramHashValues = new LinkedHashMap();
    private boolean didQueryParameters = false;
    private boolean didMerge = false;
    MimeHeaders headers;
    DataChunk queryDC;
    public static final int INITIAL_SIZE = 4;
    private Parameters child = null;
    private Parameters parent = null;
    private Parameters currentChild = null;
    Charset encoding = null;
    Charset queryStringEncoding = null;
    private int limit = -1;
    private int parameterCount = 0;
    final BufferChunk tmpName = new BufferChunk();
    final BufferChunk tmpValue = new BufferChunk();
    private BufferChunk origName = new BufferChunk();
    private BufferChunk origValue = new BufferChunk();
    final CharChunk tmpNameC = new CharChunk(1024);
    final CharChunk tmpValueC = new CharChunk(1024);
    public static final String DEFAULT_ENCODING = "ISO-8859-1";
    public static final Charset DEFAULT_CHARSET = Constants.DEFAULT_HTTP_CHARSET;
    private static final int debug = 0;

    public void setQuery(DataChunk queryBC) {
        this.queryDC = queryBC;
    }

    public void setHeaders(MimeHeaders headers) {
        this.headers = headers;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setEncoding(Charset encoding) {
        this.encoding = encoding;
    }

    public void setQueryStringEncoding(Charset queryStringEncoding) {
        this.queryStringEncoding = queryStringEncoding;
    }

    public void recycle() {
        this.paramHashValues.clear();
        this.didQueryParameters = false;
        this.currentChild = null;
        this.didMerge = false;
        this.encoding = null;
        this.parameterCount = 0;
    }

    public Parameters getCurrentSet() {
        if (this.currentChild == null) {
            return this;
        }
        return this.currentChild;
    }

    public void push() {
        if (this.currentChild == null) {
            this.currentChild = new Parameters();
            this.currentChild.parent = this;
            return;
        }
        if (this.currentChild.child == null) {
            this.currentChild.child = new Parameters();
            this.currentChild.child.parent = this.currentChild;
        }
        this.currentChild = this.currentChild.child;
        this.currentChild.setEncoding(this.encoding);
    }

    public void pop() {
        if (this.currentChild == null) {
            throw new RuntimeException("Attempt to pop without a push");
        }
        this.currentChild.recycle();
        this.currentChild = this.currentChild.parent;
    }

    public void addParameterValues(String key, String[] newValues) {
        ArrayList<Object> values;
        if (key == null) {
            return;
        }
        if (this.paramHashValues.containsKey(key)) {
            values = this.paramHashValues.get(key);
        } else {
            values = new ArrayList(1);
            this.paramHashValues.put(key, values);
        }
        values.ensureCapacity(values.size() + newValues.length);
        Collections.addAll(values, newValues);
    }

    public String[] getParameterValues(String name) {
        this.handleQueryParameters();
        ArrayList<String> values = null;
        if (this.currentChild != null) {
            this.currentChild.merge();
            values = this.currentChild.paramHashValues.get(name);
        } else {
            values = this.paramHashValues.get(name);
        }
        return values != null ? values.toArray(new String[values.size()]) : null;
    }

    public Set<String> getParameterNames() {
        this.handleQueryParameters();
        if (this.currentChild != null) {
            this.currentChild.merge();
            this.currentChild.paramHashValues.keySet();
        }
        return this.paramHashValues.keySet();
    }

    private void merge() {
        this.handleQueryParameters();
        if (this.didMerge) {
            return;
        }
        if (this.parent == null) {
            return;
        }
        this.parent.merge();
        LinkedHashMap<String, ArrayList<String>> parentProps = this.parent.paramHashValues;
        Parameters.merge2(this.paramHashValues, parentProps);
        this.didMerge = true;
    }

    public String getParameter(String name) {
        ArrayList<String> values = this.paramHashValues.get(name);
        if (values != null) {
            if (values.isEmpty()) {
                return "";
            }
            return values.get(0);
        }
        return null;
    }

    public void handleQueryParameters() {
        if (this.didQueryParameters) {
            return;
        }
        this.didQueryParameters = true;
        if (this.queryDC == null || this.queryDC.isNull()) {
            return;
        }
        this.processParameters(this.queryDC, this.queryStringEncoding);
    }

    private static void merge2(LinkedHashMap<String, ArrayList<String>> one, LinkedHashMap<String, ArrayList<String>> two) {
        for (String name : two.keySet()) {
            ArrayList<String> combinedValue;
            ArrayList<String> oneValue = one.get(name);
            ArrayList<String> twoValue = two.get(name);
            if (twoValue == null) continue;
            if (oneValue == null) {
                combinedValue = new ArrayList<String>(twoValue);
            } else {
                combinedValue = new ArrayList(oneValue.size() + twoValue.size());
                combinedValue.addAll(oneValue);
                combinedValue.addAll(twoValue);
            }
            one.put(name, combinedValue);
        }
    }

    public void addParameter(String key, String value) throws IllegalStateException {
        if (key == null) {
            return;
        }
        ++this.parameterCount;
        if (this.limit > -1 && this.parameterCount > this.limit) {
            throw new IllegalStateException();
        }
        ArrayList<String> values = this.paramHashValues.get(key);
        if (values == null) {
            values = new ArrayList(1);
            this.paramHashValues.put(key, values);
        }
        values.add(value);
    }

    public void processParameters(Buffer buffer, int start, int len) {
        this.processParameters(buffer, start, len, this.encoding);
    }

    public void processParameters(Buffer buffer, int start, int len, Charset enc) {
        int decodeFailCount = 0;
        int end = start + len;
        int pos = start;
        while (pos < end) {
            block21: {
                if (this.limit > -1 && this.parameterCount >= this.limit) {
                    logger.warning(LogMessages.WARNING_GRIZZLY_HTTP_SEVERE_GRIZZLY_HTTP_PARAMETERS_MAX_COUNT_FAIL(this.limit));
                    break;
                }
                int nameStart = pos;
                int nameEnd = -1;
                int valueStart = -1;
                int valueEnd = -1;
                boolean parsingName = true;
                boolean decodeName = false;
                boolean decodeValue = false;
                boolean parameterComplete = false;
                do {
                    switch (buffer.get(pos)) {
                        case 61: {
                            if (parsingName) {
                                nameEnd = pos++;
                                parsingName = false;
                                valueStart = pos;
                                break;
                            }
                            ++pos;
                            break;
                        }
                        case 38: {
                            if (parsingName) {
                                nameEnd = pos;
                            } else {
                                valueEnd = pos;
                            }
                            parameterComplete = true;
                            ++pos;
                            break;
                        }
                        case 37: 
                        case 43: {
                            if (parsingName) {
                                decodeName = true;
                            } else {
                                decodeValue = true;
                            }
                            ++pos;
                            break;
                        }
                        default: {
                            ++pos;
                        }
                    }
                } while (!parameterComplete && pos < end);
                if (pos == end) {
                    if (nameEnd == -1) {
                        nameEnd = pos;
                    } else if (valueStart > -1 && valueEnd == -1) {
                        valueEnd = pos;
                    }
                }
                if (nameEnd <= nameStart) {
                    if (!logger.isLoggable(Level.INFO) || valueEnd >= nameStart) continue;
                    logger.info(LogMessages.INFO_GRIZZLY_HTTP_PARAMETERS_INVALID_CHUNK(nameStart, nameEnd, null));
                    continue;
                }
                this.tmpName.setBufferChunk(buffer, nameStart, nameEnd);
                this.tmpValue.setBufferChunk(buffer, valueStart, valueEnd);
                try {
                    String name = decodeName ? this.urlDecode(this.tmpName, enc) : this.tmpName.toString(enc);
                    String value = valueStart != -1 ? (decodeValue ? this.urlDecode(this.tmpValue, enc) : this.tmpValue.toString(enc)) : "";
                    this.addParameter(name, value);
                }
                catch (IOException e) {
                    if (++decodeFailCount != 1 || !logger.isLoggable(Level.INFO)) break block21;
                    logger.log(Level.INFO, LogMessages.INFO_GRIZZLY_HTTP_PARAMETERS_DECODE_FAIL_INFO(this.tmpName.toString(), this.tmpValue.toString()), e);
                }
            }
            this.tmpName.recycle();
            this.tmpValue.recycle();
        }
        if (decodeFailCount > 1) {
            logger.info(LogMessages.INFO_GRIZZLY_HTTP_PARAMETERS_MULTIPLE_DECODING_FAIL(decodeFailCount));
        }
    }

    private String urlDecode(BufferChunk bc, Charset enc) throws IOException {
        String result;
        URLDecoder.decode(bc, true);
        if (enc != null) {
            if (bc.getStart() == -1 && bc.getEnd() == -1) {
                return "";
            }
            result = bc.toString(enc);
        } else {
            CharChunk cc = this.tmpNameC;
            int length = bc.getLength();
            cc.allocate(length, -1);
            Buffer bbuf = bc.getBuffer();
            char[] cbuf = cc.getBuffer();
            int start = bc.getStart();
            for (int i = 0; i < length; ++i) {
                cbuf[i] = (char)(bbuf.get(i + start) & 0xFF);
            }
            cc.setChars(cbuf, 0, length);
            result = cc.toString();
            cc.recycle();
        }
        return result;
    }

    public void processParameters(char[] chars, int start, int len) {
        int end = start + len;
        int pos = start;
        do {
            boolean noEq = false;
            int nameStart = pos;
            int valStart = -1;
            int valEnd = -1;
            int nameEnd = CharChunk.indexOf(chars, nameStart, end, '=');
            int nameEnd2 = CharChunk.indexOf(chars, nameStart, end, '&');
            if (nameEnd2 != -1 && (nameEnd == -1 || nameEnd > nameEnd2)) {
                nameEnd = nameEnd2;
                noEq = true;
                valStart = nameEnd;
                valEnd = nameEnd;
            }
            if (nameEnd == -1) {
                nameEnd = end;
            }
            if (!noEq && (valEnd = CharChunk.indexOf(chars, valStart = nameEnd < end ? nameEnd + 1 : end, end, '&')) == -1) {
                valEnd = valStart < end ? end : valStart;
            }
            pos = valEnd + 1;
            if (nameEnd <= nameStart) continue;
            try {
                this.tmpNameC.append(chars, nameStart, nameEnd - nameStart);
                this.tmpValueC.append(chars, valStart, valEnd - valStart);
                URLDecoder.decode(this.tmpNameC, true);
                URLDecoder.decode(this.tmpValueC, true);
                this.addParameter(this.tmpNameC.toString(), this.tmpValueC.toString());
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.tmpNameC.recycle();
            this.tmpValueC.recycle();
        } while (pos < end);
    }

    public void processParameters(DataChunk data) {
        this.processParameters(data, this.encoding);
    }

    public void processParameters(DataChunk data, Charset encoding) {
        if (data == null || data.isNull() || data.getLength() <= 0) {
            return;
        }
        try {
            if (data.getType() == DataChunk.Type.Buffer) {
                BufferChunk bc = data.getBufferChunk();
                this.processParameters(bc.getBuffer(), bc.getStart(), bc.getLength(), encoding);
            } else {
                if (data.getType() != DataChunk.Type.Chars) {
                    data.toChars(encoding);
                }
                CharChunk cc = data.getCharChunk();
                this.processParameters(cc.getChars(), cc.getStart(), cc.getLength());
            }
        }
        catch (CharConversionException e) {
            throw new IllegalStateException(e);
        }
    }

    public String paramsAsString() {
        StringBuilder sb = new StringBuilder();
        for (String s : this.paramHashValues.keySet()) {
            sb.append(s).append('=');
            ArrayList<String> v = this.paramHashValues.get(s);
            int len = v.size();
            for (int i = 0; i < len; ++i) {
                sb.append(v.get(i)).append(',');
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    private void log(String s) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Parameters: {0}", s);
        }
    }

    public void processSingleParameters(String str) {
        int end = str.length();
        int pos = 0;
        do {
            boolean noEq = false;
            int valStart = -1;
            int valEnd = -1;
            int nameStart = pos;
            int nameEnd = str.indexOf(61, nameStart);
            int nameEnd2 = str.indexOf(38, nameStart);
            if (nameEnd2 == -1) {
                nameEnd2 = end;
            }
            if (nameEnd2 != -1 && (nameEnd == -1 || nameEnd > nameEnd2)) {
                nameEnd = nameEnd2;
                noEq = true;
                valStart = nameEnd;
                valEnd = nameEnd;
            }
            if (nameEnd == -1) {
                nameEnd = end;
            }
            if (!noEq && (valEnd = str.indexOf(38, valStart = nameEnd + 1)) == -1) {
                valEnd = valStart < end ? end : valStart;
            }
            pos = valEnd + 1;
            if (nameEnd <= nameStart) continue;
            try {
                this.tmpNameC.append(str, nameStart, nameEnd - nameStart);
                this.tmpValueC.append(str, valStart, valEnd - valStart);
                URLDecoder.decode(this.tmpNameC, true);
                URLDecoder.decode(this.tmpValueC, true);
                if (str.compareTo(this.tmpNameC.toString()) == 0) {
                    this.addParameter(this.tmpNameC.toString(), this.tmpValueC.toString());
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.tmpNameC.recycle();
            this.tmpValueC.recycle();
        } while (pos < end);
    }

    public void processParameters(String str) {
        int end = str.length();
        int pos = 0;
        do {
            boolean noEq = false;
            int valStart = -1;
            int valEnd = -1;
            int nameStart = pos;
            int nameEnd = str.indexOf(61, nameStart);
            int nameEnd2 = str.indexOf(38, nameStart);
            if (nameEnd2 == -1) {
                nameEnd2 = end;
            }
            if (nameEnd2 != -1 && (nameEnd == -1 || nameEnd > nameEnd2)) {
                nameEnd = nameEnd2;
                noEq = true;
                valStart = nameEnd;
                valEnd = nameEnd;
            }
            if (nameEnd == -1) {
                nameEnd = end;
            }
            if (!noEq && (valEnd = str.indexOf(38, valStart = nameEnd + 1)) == -1) {
                valEnd = valStart < end ? end : valStart;
            }
            pos = valEnd + 1;
            if (nameEnd <= nameStart) continue;
            try {
                this.tmpNameC.append(str, nameStart, nameEnd - nameStart);
                this.tmpValueC.append(str, valStart, valEnd - valStart);
                URLDecoder.decode(this.tmpNameC, true);
                URLDecoder.decode(this.tmpValueC, true);
                this.addParameter(this.tmpNameC.toString(), this.tmpValueC.toString());
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.tmpNameC.recycle();
            this.tmpValueC.recycle();
        } while (pos < end);
    }
}

