/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.impl;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import org.glassfish.grizzly.Cacheable;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.impl.FutureImpl;

public class SafeFutureImpl<R>
implements FutureImpl<R> {
    private static final ThreadCache.CachedTypeIndex<SafeFutureImpl> CACHE_IDX = ThreadCache.obtainIndex(SafeFutureImpl.class, 4);
    private final boolean isRecyclable;
    private final Sync sync = new Sync();

    public static <R> SafeFutureImpl<R> create() {
        SafeFutureImpl future = ThreadCache.takeFromCache(CACHE_IDX);
        if (future != null) {
            return future;
        }
        return new SafeFutureImpl<R>(true);
    }

    public SafeFutureImpl() {
        this(false);
    }

    private SafeFutureImpl(boolean isRecyclable) {
        this.isRecyclable = isRecyclable;
    }

    @Override
    public boolean isCancelled() {
        return this.sync.innerIsCancelled();
    }

    @Override
    public boolean isDone() {
        return this.sync.innerIsDone();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.sync.innerCancel(mayInterruptIfRunning);
    }

    @Override
    public R get() throws InterruptedException, ExecutionException {
        return this.sync.innerGet();
    }

    @Override
    public R get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.sync.innerGet(unit.toNanos(timeout));
    }

    @Override
    public R getResult() {
        return this.sync.innerWeakGet();
    }

    @Override
    public void result(R result) {
        this.sync.innerSet(result);
    }

    @Override
    public void failure(Throwable failure) {
        this.sync.innerSetException(failure);
    }

    @Override
    public void markForRecycle(boolean recycleResult) {
    }

    protected void reset() {
        this.sync.innerReset();
    }

    @Override
    public void recycle(boolean recycleResult) {
        Object result;
        if (recycleResult && (result = this.sync.innerWeakGet()) != null && result instanceof Cacheable) {
            ((Cacheable)result).recycle();
        }
        if (this.isRecyclable) {
            this.reset();
            ThreadCache.putToCache(CACHE_IDX, this);
        }
    }

    @Override
    public void recycle() {
        this.recycle(false);
    }

    protected void onResult(R result) {
    }

    protected void onError(Throwable t) {
    }

    protected void onCancel(boolean mayInterruptIfRunning) {
    }

    private final class Sync
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = -7828117401763700385L;
        private static final int RAN = 2;
        private static final int CANCELLED = 4;
        private R result;
        private Throwable exception;

        Sync() {
        }

        private boolean ranOrCancelled(int state) {
            return (state & 6) != 0;
        }

        @Override
        protected int tryAcquireShared(int ignore) {
            return this.innerIsDone() ? 1 : -1;
        }

        @Override
        protected boolean tryReleaseShared(int ignore) {
            return true;
        }

        boolean innerIsCancelled() {
            return this.getState() == 4;
        }

        boolean innerIsDone() {
            return this.ranOrCancelled(this.getState());
        }

        R innerWeakGet() {
            if (this.getState() > -1) {
                return this.result;
            }
            return null;
        }

        R innerGet() throws InterruptedException, ExecutionException {
            this.acquireSharedInterruptibly(0);
            if (this.getState() == 4) {
                throw new CancellationException();
            }
            if (this.exception != null) {
                throw new ExecutionException(this.exception);
            }
            return this.result;
        }

        R innerGet(long nanosTimeout) throws InterruptedException, ExecutionException, TimeoutException {
            if (!this.tryAcquireSharedNanos(0, nanosTimeout)) {
                throw new TimeoutException();
            }
            if (this.getState() == 4) {
                throw new CancellationException();
            }
            if (this.exception != null) {
                throw new ExecutionException(this.exception);
            }
            return this.result;
        }

        void innerSet(R result) {
            int s;
            do {
                if ((s = this.getState()) == 2) {
                    return;
                }
                if (s != 4) continue;
                this.releaseShared(0);
                return;
            } while (!this.compareAndSetState(s, 2));
            this.result = result;
            this.releaseShared(0);
            SafeFutureImpl.this.onResult(result);
        }

        void innerSetException(Throwable t) {
            int s;
            do {
                if ((s = this.getState()) == 2) {
                    return;
                }
                if (s != 4) continue;
                this.releaseShared(0);
                return;
            } while (!this.compareAndSetState(s, 2));
            this.exception = t;
            this.result = null;
            this.releaseShared(0);
            SafeFutureImpl.this.onError(t);
        }

        boolean innerCancel(boolean mayInterruptIfRunning) {
            int s;
            do {
                if (!this.ranOrCancelled(s = this.getState())) continue;
                return false;
            } while (!this.compareAndSetState(s, 4));
            this.releaseShared(0);
            SafeFutureImpl.this.onCancel(mayInterruptIfRunning);
            return true;
        }

        void innerReset() {
            this.result = null;
            this.exception = null;
            this.setState(0);
        }
    }
}

