/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender.newsearch;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.GZIPContentEncodingFilter;
import de.mediathekview.mlib.tool.Log;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import mServer.crawler.FilmeSuchen;
import mServer.crawler.RunSender;
import mServer.crawler.sender.newsearch.ZDFConfigurationLoader;
import mServer.tool.MserverDaten;

public class ZDFClient {
    private static final String ZDF_SEARCH_URL = "https://api.zdf.de/search/documents";
    private static final String HEADER_ACCESS_CONTROL_REQUEST_HEADERS = "Access-Control-Request-Headers";
    private static final String HEADER_ACCESS_CONTROL_REQUEST_METHOD = "access-control-request-method";
    private static final String HEADER_API_AUTH = "api-auth";
    private static final String HEADER_HOST = "host";
    private static final String HEADER_ORIGIN = "origin";
    private static final String HEADER_USER_AGENT = "user-agent";
    private static final String ACCESS_CONTROL_API_AUTH = "api-auth";
    private static final String ACCESS_CONTROL_REQUEST_METHOD_GET = "GET";
    private static final String HOST = "api.zdf.de";
    private static final String ORIGIN = "https://www.zdf.de";
    private static final String USER_AGENT = "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:50.0) Gecko/20100101 Firefox/50.0";
    private static final String API_TOKEN_PATTERN = "Bearer %s";
    private static final String PROPERTY_HAS_VIDEO = "hasVideo";
    private static final String PROPERTY_SEARCHPARAM_Q = "q";
    private static final String SEARCH_ALL = "*";
    private static final String PROPERTY_SORT_ORDER = "sortOrder";
    private static final String SORT_ORDER_DESC = "desc";
    private static final String PROPERTY_DATE_FROM = "from";
    private static final String PROPERTY_DATE_TO = "to";
    private static final String PROPERTY_SORT_BY = "sortBy";
    private static final String SORT_BY_DATE = "date";
    private static final String PROPERTY_PAGE = "page";
    private static final DateTimeFormatter DATE_TIME_FORMAT = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
    private final ZonedDateTime today = ZonedDateTime.now().withHour(0).withMinute(0);
    private final Client client = Client.create();
    private final Gson gson;

    public ZDFClient() {
        this.client.addFilter((ClientFilter)new GZIPContentEncodingFilter(true));
        this.gson = new Gson();
    }

    public JsonObject execute(String aUrl) {
        WebResource webResource = this.createResource(aUrl);
        return this.execute(webResource, ZDFClientMode.VIDEO);
    }

    public JsonObject executeSearch(int page, int daysPast, int monthFuture) {
        WebResource webResource = this.createResource(ZDF_SEARCH_URL).queryParam(PROPERTY_HAS_VIDEO, Boolean.TRUE.toString()).queryParam(PROPERTY_SEARCHPARAM_Q, SEARCH_ALL).queryParam(PROPERTY_SORT_ORDER, SORT_ORDER_DESC).queryParam(PROPERTY_DATE_FROM, this.today.minusDays(daysPast).format(DATE_TIME_FORMAT)).queryParam(PROPERTY_DATE_TO, this.today.plusMonths(monthFuture).format(DATE_TIME_FORMAT)).queryParam(PROPERTY_SORT_BY, SORT_BY_DATE).queryParam(PROPERTY_PAGE, Integer.toString(page));
        return this.execute(webResource, ZDFClientMode.SEARCH);
    }

    private WebResource createResource(String url) {
        return this.client.resource(url);
    }

    private JsonObject execute(WebResource webResource, ZDFClientMode aMode) {
        String apiToken = this.loadApiToken(aMode);
        ClientResponse response = (ClientResponse)((WebResource.Builder)((WebResource.Builder)((WebResource.Builder)((WebResource.Builder)((WebResource.Builder)webResource.header(HEADER_ACCESS_CONTROL_REQUEST_HEADERS, (Object)"api-auth").header(HEADER_ACCESS_CONTROL_REQUEST_METHOD, (Object)ACCESS_CONTROL_REQUEST_METHOD_GET)).header("api-auth", (Object)apiToken)).header(HEADER_HOST, (Object)HOST)).header(HEADER_ORIGIN, (Object)ORIGIN)).header(HEADER_USER_AGENT, (Object)USER_AGENT)).get(ClientResponse.class);
        if (MserverDaten.debug) {
            Log.sysLog((String)("Lade Seite: " + webResource.getURI()));
        }
        if (response.getStatus() == 200) {
            return this.handleOk(response);
        }
        Log.errorLog((int)496583258, (String)("Lade Seite " + webResource.getURI() + " fehlgeschlagen: " + response.getStatus()));
        this.increment(RunSender.Count.FEHLER);
        return null;
    }

    private JsonObject handleOk(ClientResponse response) {
        this.increment(RunSender.Count.ANZAHL);
        long bytes = response.getLength();
        this.increment(RunSender.Count.SUM_DATA_BYTE, bytes);
        this.increment(RunSender.Count.SUM_TRAFFIC_BYTE, bytes);
        String jsonOutput = (String)response.getEntity(String.class);
        return (JsonObject)this.gson.fromJson(jsonOutput, JsonObject.class);
    }

    private void increment(RunSender.Count count) {
        FilmeSuchen.listeSenderLaufen.inc("ZDF", count);
    }

    private void increment(RunSender.Count count, long value) {
        FilmeSuchen.listeSenderLaufen.inc("ZDF", count, value);
    }

    private String loadApiToken(ZDFClientMode aMode) {
        return String.format(API_TOKEN_PATTERN, ZDFConfigurationLoader.getInstance().loadConfig().getApiToken(aMode));
    }

    public static enum ZDFClientMode {
        SEARCH,
        VIDEO;

    }
}

