/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender.newsearch;

import de.mediathekview.mlib.tool.Log;
import java.io.IOException;
import mServer.crawler.sender.newsearch.ZDFClient;
import mServer.crawler.sender.newsearch.ZDFConfigurationDTO;
import mServer.crawler.sender.newsearch.ZdfIndexPageDeserializer;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public class ZDFConfigurationLoader {
    public static final String ZDF_BEARER_URL = "https://www.zdf.de/";
    private static final String FALLBACK_TOKEN_SEARCH = "309fa9bc88933de7256f4f6f6c5d3373cc36517c";
    private static final String FALLBACK_TOKEN_VIDEO = "69c4eddbe0cf82b2a9277e8106a711db314a3008";
    private static ZDFConfigurationLoader instance;
    private ZDFConfigurationDTO config = null;

    private ZDFConfigurationLoader() {
    }

    public static ZDFConfigurationLoader getInstance() {
        if (instance == null) {
            instance = new ZDFConfigurationLoader();
        }
        return instance;
    }

    public ZDFConfigurationDTO loadConfig() {
        if (this.config == null) {
            try {
                Document document = Jsoup.connect((String)ZDF_BEARER_URL).get();
                ZdfIndexPageDeserializer deserializer = new ZdfIndexPageDeserializer();
                this.config = deserializer.deserialize(document);
                if (this.config.getApiToken(ZDFClient.ZDFClientMode.SEARCH).isEmpty()) {
                    Log.sysLog((String)"Fallback token f\u00fcr SEARCH verwenden.");
                    this.config.setApiToken(ZDFClient.ZDFClientMode.SEARCH, FALLBACK_TOKEN_SEARCH);
                }
                if (this.config.getApiToken(ZDFClient.ZDFClientMode.VIDEO).isEmpty()) {
                    Log.sysLog((String)"Fallback token f\u00fcr VIDEO verwenden.");
                    this.config.setApiToken(ZDFClient.ZDFClientMode.VIDEO, FALLBACK_TOKEN_VIDEO);
                }
            }
            catch (IOException ex) {
                Log.errorLog((int)561515615, (Exception)ex);
                this.config = new ZDFConfigurationDTO();
                this.config.setApiToken(ZDFClient.ZDFClientMode.SEARCH, FALLBACK_TOKEN_SEARCH);
                this.config.setApiToken(ZDFClient.ZDFClientMode.VIDEO, FALLBACK_TOKEN_VIDEO);
            }
        }
        return this.config;
    }
}

