/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender.wdr;

import de.mediathekview.mlib.Config;
import de.mediathekview.mlib.daten.DatenFilm;
import de.mediathekview.mlib.daten.ListeFilme;
import de.mediathekview.mlib.tool.Log;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import mServer.crawler.sender.wdr.WdrSendungDto;
import mServer.crawler.sender.wdr.WdrSendungOverviewDeserializer;
import mServer.crawler.sender.wdr.WdrUrlLoader;
import mServer.crawler.sender.wdr.WdrVideoDetailsDeserializer;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public class WdrSendungCallable
implements Callable<ListeFilme> {
    private final WdrSendungDto dto;
    private final WdrSendungOverviewDeserializer overviewDeserializer = new WdrSendungOverviewDeserializer();

    public WdrSendungCallable(WdrSendungDto aDto) {
        this.dto = aDto;
    }

    @Override
    public ListeFilme call() {
        return this.parse(this.dto, 0);
    }

    private ListeFilme parse(WdrSendungDto aDto, int recoursiveCall) {
        ListeFilme list = new ListeFilme();
        if (!Config.getStop()) {
            aDto.getOverviewUrls().forEach(url -> {
                if (this.isUrlRelevant((String)url) && recoursiveCall < 2) {
                    list.addAll(this.parseSendungOverviewPage((String)url, aDto.getTheme(), recoursiveCall + 1));
                }
            });
            aDto.getVideoUrls().forEach(url -> {
                DatenFilm film;
                if (this.isUrlRelevant((String)url) && (film = this.parseFilmPage((String)url, aDto.getTheme())) != null) {
                    list.add(film);
                }
            });
        }
        return list;
    }

    private Collection<DatenFilm> parseSendungOverviewPage(String strUrl, String parentTheme, int recoursiveCall) {
        if (!this.isUrlRelevant(strUrl)) {
            return new ArrayList<DatenFilm>();
        }
        try {
            Document filmDocument = Jsoup.connect((String)strUrl).get();
            WdrSendungDto sendungDto = this.overviewDeserializer.deserialize(filmDocument);
            sendungDto.setTheme(parentTheme);
            return this.parse(sendungDto, recoursiveCall);
        }
        catch (IOException ex) {
            Log.errorLog((int)763299001, (Exception)ex);
            return new ArrayList<DatenFilm>();
        }
    }

    private boolean isUrlRelevant(String url) {
        if (url.endsWith("lokalzeit/index.html")) {
            return false;
        }
        return !url.contains("wdr.de/hilfe");
    }

    private DatenFilm parseFilmPage(String filmWebsite, String theme) {
        if (Config.getStop()) {
            return null;
        }
        try {
            Document filmDocument = Jsoup.connect((String)filmWebsite).get();
            WdrVideoDetailsDeserializer deserializer = new WdrVideoDetailsDeserializer(new WdrUrlLoader());
            DatenFilm film = deserializer.deserialize(theme, filmDocument);
            return film;
        }
        catch (IOException ex) {
            Log.errorLog((int)763299001, (Exception)ex);
            return null;
        }
    }
}

