/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender.wdr;

import java.util.HashMap;
import java.util.Map;
import mServer.crawler.sender.newsearch.Qualities;
import mServer.crawler.sender.wdr.WdrUrlLoader;
import mServer.crawler.sender.wdr.WdrVideoDto;

public class WdrVideoUrlParser {
    private static final String JS_SEARCH_ALT = "\"alt\":{\"videoURL\":\"";
    private static final String JS_SEARCH_DFLT = "\"dflt\":{\"videoURL\":\"";
    private static final String M3U8_RESOLUTION_BEGIN = "RESOLUTION=";
    private static final String M3U8_RESOLUTION_END = "x";
    private static final String M3U8_URL_BEGIN = "http";
    private static final String M3U8_URL_END = "m3u8";
    private final WdrUrlLoader urlLoader;

    public WdrVideoUrlParser(WdrUrlLoader aUrlLoader) {
        this.urlLoader = aUrlLoader;
    }

    public WdrVideoDto parse(String jsUrl) {
        WdrVideoDto dto = new WdrVideoDto();
        String javascript = this.urlLoader.executeRequest(jsUrl);
        if (javascript.isEmpty()) {
            return dto;
        }
        String url = this.getSubstring(javascript, JS_SEARCH_ALT, "\"");
        String f4m = this.getSubstring(javascript, JS_SEARCH_DFLT, "\"");
        String protocol = jsUrl.substring(0, jsUrl.indexOf(58));
        url = this.addProtocolIfMissing(url, protocol);
        f4m = this.addProtocolIfMissing(f4m, protocol);
        if (url.endsWith(".m3u8")) {
            this.fillUrlsFromM3u8(dto, url);
        }
        if (!f4m.isEmpty() && url.contains("_") && url.endsWith(".mp4")) {
            this.fillUrlsFromf4m(dto, f4m, url);
        }
        dto.setSubtitleUrl(this.addProtocolIfMissing(this.getSubstring(javascript, "\"captionURL\":\"", "\""), protocol));
        return dto;
    }

    private String addProtocolIfMissing(String url, String protocol) {
        if (url.startsWith("//")) {
            return protocol + ":" + url;
        }
        if (url.startsWith("://")) {
            return protocol + url;
        }
        return url;
    }

    private void fillUrlsFromM3u8(WdrVideoDto dto, String m3u8Url) {
        String m3u8Content = this.urlLoader.executeRequest(m3u8Url);
        Map<Integer, String> resolutionUrlMap = this.getResolutionUrlMapFromM3u8(m3u8Content);
        resolutionUrlMap.forEach((key, value) -> {
            if (key >= 1280) {
                dto.addVideo(Qualities.HD, (String)value);
            } else if (key >= 960) {
                dto.addVideo(Qualities.NORMAL, (String)value);
            } else if (key >= 640 && dto.getUrl(Qualities.NORMAL).isEmpty()) {
                dto.addVideo(Qualities.NORMAL, (String)value);
            } else if (key >= 512) {
                dto.addVideo(Qualities.SMALL, (String)value);
            } else if (dto.getUrl(Qualities.SMALL).isEmpty()) {
                dto.addVideo(Qualities.SMALL, (String)value);
            }
        });
        if (dto.getUrl(Qualities.NORMAL).isEmpty() && !dto.getUrl(Qualities.SMALL).isEmpty()) {
            dto.addVideo(Qualities.NORMAL, dto.getUrl(Qualities.SMALL));
        }
    }

    private void fillUrlsFromf4m(WdrVideoDto dto, String f4m, String url) {
        String urlNormal = "";
        String urlSmall = "";
        String urlHd = "";
        String s1 = url.substring(url.lastIndexOf(95) + 1, url.indexOf(".mp4"));
        String s2 = url.substring(0, url.lastIndexOf(95) + 1);
        try {
            int nr = Integer.parseInt(s1);
            if (f4m.contains(nr + 2 + "")) {
                urlHd = s2 + (nr + 2) + ".mp4";
            }
            if (f4m.contains(nr + 4 + "")) {
                urlSmall = s2 + (nr + 4) + ".mp4";
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (!urlHd.isEmpty()) {
            if (urlSmall.isEmpty()) {
                urlSmall = urlNormal;
            }
            urlNormal = urlHd;
        }
        dto.addVideo(Qualities.SMALL, urlSmall);
        dto.addVideo(Qualities.NORMAL, urlNormal);
        dto.addVideo(Qualities.HD, urlHd);
    }

    private Map<Integer, String> getResolutionUrlMapFromM3u8(String m3u8Content) {
        String[] parts;
        HashMap<Integer, String> resolutionUrlMap = new HashMap<Integer, String>();
        for (String part : parts = m3u8Content.split("#")) {
            String resolution = this.getSubstring(part, M3U8_RESOLUTION_BEGIN, M3U8_RESOLUTION_END);
            String url = this.getSubstring(part, M3U8_URL_BEGIN, M3U8_URL_END);
            if (resolution.isEmpty() || url.isEmpty()) continue;
            url = M3U8_URL_BEGIN + url + M3U8_URL_END;
            int resolutionValue = Integer.parseInt(resolution);
            resolutionUrlMap.put(resolutionValue, url);
        }
        return resolutionUrlMap;
    }

    private String getSubstring(String stringToSearchIn, String stringToStart, String stringToEnd) {
        int posStart = stringToSearchIn.indexOf(stringToStart);
        if (posStart < 0) {
            return "";
        }
        int posEnd = stringToSearchIn.indexOf(stringToEnd, posStart += stringToStart.length());
        if (posEnd > -1 && posStart <= posEnd) {
            return stringToSearchIn.substring(posStart, posEnd);
        }
        return "";
    }
}

